Ext.namespace('Ext.ux.senior.layout');

Ext.ux.senior.layout.TableLayout = Ext.extend(Ext.layout.TableLayout, {

    defaultAnchor : '100%',

    extraCell : null,

    parseAnchorRE : /^(r|right|b|bottom)$/i,

    renderItem : function(component, position, target) {
        Ext.ux.senior.layout.TableLayout.superclass.renderItem.apply(this, arguments);
        component.applyMargins();
        this.alignComponent(component);
    },

    /**
     * Alinha o componente conforme especificado na criao. Caso o componente
     * no tenha recebido um alinhamento, este metodo no faz nada
     */
    alignComponent : function(component) {
        var align = component.horizontalAlign;
        if (align) {
            component.addClass('ux-gridlayout-cell-horizontal-' + align);
        }
    },

    getNextCell : function(c) {
        var cell = Ext.ux.senior.layout.TableLayout.superclass.getNextCell.apply(this, arguments);
        var cellEl = Ext.get(cell);
        //esconde o contedo quando ocorre overflow
        cellEl.addClass('ux-gridlayout-td-overflow-hidden');

        //se for fit, ajusta para o tamaho ser calculado via colunas ao invs de
        //ser calculado pelos componentes. (UC-FRC-0063, REQ0039)
        if (this.table && this.columnWidths) {
            this.table.style.tableLayout = "fixed";
        }

        // garante que o nmero de tr  o mesmo que a quantidade de linhas
        var curRow = this.table.tBodies[0].childNodes.length;
        for (; curRow < this.cells.length; curRow++) {
            this.getRow(curRow);
        }
        return cell;
    },

    /**
     * @override
     */
    setContainer : function(ct) {
        Ext.ux.senior.layout.TableLayout.superclass.setContainer.call(this, ct);
        ct.on('resize', this.adjustSize, this, ct);
    },

    /**
     * Usado para no ser necessrio alterar a assinatura do mtodo
     * "adjustSize", que recebe um componente e 4 medidas.
     *
     * @private
     */
    resizeKey : {
        resizing : false
    },

    /**
     * Mtodo utilizado para fazer "doLayout" na grid, que ignora o
     * doLayout (vide documentao do Ext).
     * 
     * @private
     */
    adjustSize : function(ct, resizeKey) {
        if (ct.items) {
            for (var i = 0; i < ct.items.length; i++) {
                var component = ct.get(i);
                if (component instanceof Ext.grid.GridPanel) {
                    if (component.isVisible() !== false) {
                        component.view.layout();
                    }
                }
                this.adjustSize(component, this.resizeKey);
            }
            if (this.resizeKey !== resizeKey) {
                this.verifyAnchor(ct);
            }
        }
    },

    colgroup : null,

    onLayout : function(ct, target) {
        Ext.ux.senior.layout.TableLayout.superclass.onLayout.call(this, ct, target);
        if (!this.colgroup && this.columnWidths && this.table) {
            this.colgroup = document.createElement('colgroup');
            for (var i = 0; i < this.columnWidths.length; i++) {
                var col = document.createElement('col');
                col.style.width = this.columnWidths[i];
                this.colgroup.appendChild(col);
            }
            this.table.insertBefore(this.colgroup, this.table.firstChild);
        }

        if (!this.extraCell && ((this.cells[0] && this.cells[0].length < this.columns) ||
                    (this.columnWidths && this.columnWidths.indexOf('') < 0))) {
            for (var i = 0; i < this.table.tBodies[0].childNodes.length; i++) {
                var td = document.createElement('td');
                td.className = 'x-table-layout-cell';
                td.colSpan = 1;
                td.rowSpan = 1;
                this.getRow(i).appendChild(td);
                this.extraCell = true;
            }
        }
        this.verifyAnchor(ct);
    },

    /**
     * Verifica a existncia de um anchor para o os filhos do containerLayout e
     * realiza o calculo da largura e altura de cada filho com base no anchor.
     * 
     * @private
     */
    verifyAnchor : function(containerLayout) {
        var components = this.getRenderedItems(containerLayout), 
            i, anchorWidth, anchorHeight, component, maxHeight,
            len = components.length;
        var boxes = [];
        for (i = 0; i < len; i++) {
            component = components[i];
            if (!component.anchor) {
                continue;
            }

            var cell = component.getEl().parent();
            while (cell.parent() && !(cell.dom.nodeName == "TD")) {
                cell = cell.parent();
            }

            maxHeight = cell.parent().parent().parent().parent().getHeight();
            anchorHeight = parseInt(maxHeight / cell.parent().parent().dom.children.length);
            anchorWidth = cell.getWidth();

            var wrapperEl = (component.wrap || component.el);
            anchorHeight -= wrapperEl.getMargins('tb');
            anchorWidth -= wrapperEl.getMargins('lr');
            var anchorSpec = component.anchorSpec;
            var anchorsArray = component.anchor.split(' ');
            if (!anchorSpec) {
                component.anchorSpec = anchorSpec = {
                    right : this.parseAnchor(anchorsArray[0], component.initialConfig.width, anchorWidth),
                    bottom : this.parseAnchor(anchorsArray[1], component.initialConfig.height, anchorHeight)
                };
            }
            
            if (Ext.isGecko || Ext.isIE10) {
                anchorWidth -= 1;
            }
            
            var calcWidth = anchorSpec.right ? anchorSpec.right(anchorWidth) : undefined;
            var calcHeight = anchorSpec.bottom ?
                    anchorSpec.bottom(anchorHeight * (component.rowspan || 1)) :
                    parseInt(component.initialConfig.height, 10) || undefined;
            if (calcWidth || calcHeight) {
                boxes.push({
                    cmp : component,
                    width : calcWidth || undefined,
                    height : calcHeight || undefined
                });
            }
        }
        var i, box;
        for (i = 0; i < boxes.length; i++) {
            box = boxes[i];
            box.cmp.setSize(box.width, box.height);
        }

    },

    // private
    parseAnchor : function(a, start, cstart) {
        if (a && a != 'none') {
            // standard anchor
            if (this.parseAnchorRE.test(a)) {
                var diff = cstart - start;
                return function(v) {
                    return v - diff;
                };
                // percentage
            } else if (a.indexOf('%') != -1) {
                var ratio = parseFloat(a.replace('%', '')) * .01;
                return function(v) {
                    return Math.floor(v * ratio);
                };
                // simple offset adjustment
            } else {
                a = parseInt(a, 10);
                if (!isNaN(a)) {
                    return function(v) {
                        return v + a;
                    };
                }
            }
        }
        return false;
    },

    /**
     * Remove todos os TDs vazios, mas nunca o prprio TR.
     * 
     * @param tr
     *            tr a ser verificado
     * @return true se o tr pode ser removido, false caso contrrio
     */
    verifyContent : function(tr) {
        var tds = tr.childNodes;
        for (var i = 0; i < tds.length; i++) {
            var td = tds[i];
            if (td.childNodes.length == 0) {
                Ext.get(td).remove();
            }
        }
        return tr.childNodes.length == 0;
    },

    /**
     * Este mtodo faz uma verificao utilizando um mtodo lento (Element.up) e
     * que sempre retorna true no caso do Seniortools. Por este motivo, foi
     * encurtado o caminho para simplesmente retornar true e economizar
     * processamento.
     * 
     * @param c
     * @param target
     * @returns {Boolean}
     */
    isValidParent : function(c, target) {
        return true;
    }

});

Ext.Container.LAYOUTS['seniortable'] = Ext.ux.senior.layout.TableLayout;
