Ext.ux.senior.LayoutOrganizer = {

    CHANGE_CONTENT : 1,
    CHANGE_SIZE : 2,
    CHANGE_VISIBILITY : 3,
    CHANGE_ITEM : 4,

    enqueuedContainers : new Ext.util.MixedCollection(false),
    enqueuedContainersToFit : new Ext.util.MixedCollection(false),

    enqueueLayout : function(containerId, changeType) {
        var cmp = Ext.getCmp(containerId);
        if (cmp.xtype == "seniorrepeater" && changeType == Ext.ux.senior.LayoutOrganizer.CHANGE_ITEM) {
            cmp.doLayout(false, true);
            return;
        }
        if (!this.enqueuedContainers.containsKey(containerId)) {
            this.enqueuedContainers.add(containerId, changeType);
        }
    },

    /**
     * Enfileira a chamada ao mtodo fitContainer() para o componente informado.
     * @param cmpId o id do componente
     */
    enqueueFitContainer : function(cmpId) {

        if (!this.enqueuedContainersToFit.containsKey(cmpId)) {
            this.enqueuedContainersToFit.add(cmpId);
        }

    },

    applyChanges : function() {
        this.enqueuedContainers.eachKey(this.applyLayout, this);
        this.enqueuedContainers.clear();

        this.enqueuedContainersToFit.each(this.applyFitContainer, this);
        this.enqueuedContainersToFit.clear();
    },

    applyLayout : function(container, type) {
        var cmp = Ext.getCmp(container);
        if (!this.hasParentInQueue(cmp, type) && cmp.needToLayout(type)) {
            cmp.doLayout(false, true);
        }
    },

    /**
     * Chama o mtodo fitContainer() do componente informado, se ele tiver esse mtodo.
     * 
     * @param cmpId o id do componente
     */
    applyFitContainer : function(cmpId) {
        var cmp = Ext.getCmp(cmpId);
        if (cmp.fitContainer) {
            cmp.fitContainer();
        }
    },

    hasParentInQueue : function(container, type) {
        var ownerCt = container.ownerCt;
        while (ownerCt) {
            var changeType = this.enqueuedContainers.get(ownerCt.id);
            if (changeType && ownerCt.needToLayout(changeType)) {
                //o conteiner no pode deve o mesmo do que o ownerCt
                return container.ownerCt.id != container.id;
            }
            ownerCt = ownerCt.ownerCt;
        }
        return false;
    }
};