Ext.namespace('Ext.ux.senior.layout');

Ext.ux.senior.layout.FormLayout = Ext.extend(Ext.layout.FormLayout, {
	
	renderItem : function(c, position, target) {
				Ext.ux.senior.layout.FormLayout.superclass.renderItem.apply(this, arguments);
				// A seguinte rotina aplica margens nos componentes do FormLayout.  necessria uma tratativa especfica apenas
                // para o FormLayout pois seus componentes so pares de Label/Campo, portanto a margin no pode estar no Campo e sim
                // no grupo todo
                                
                // Se o componente do FormLayout for outro Panel no vai ter este div, da aplica no prprio componente
                var marginItem = c.el.findParent("div.x-form-item");
                if (marginItem) {
                    marginItem = new Ext.Element(marginItem);
                } else {
                    marginItem = c.getPositionEl(); 
                }
                var margins = marginItem.getMargins();                
                var toApply;
				// usa as margens do componente ou na ausencia destas, do container pai
                if(c.margins) {
                    toApply = c.margins;
				} else {
					toApply = this.container.margin != undefined ? this.container.margin : "";
				}
                // pode j ter margem de algum estilo, soma para no perder 
                toApply = this.parseMargins(toApply);
                toApply.top += margins.top;
                toApply.bottom += margins.bottom;
                toApply.left += margins.left;
                toApply.right += margins.right;
				marginItem.applyStyles({
					margin : toApply.top + "px " + toApply.right + "px " + toApply.bottom + "px " + toApply.left + "px"
				});
		
	},
	
	/**
     * Sobrescreve o original para que no exista cache de ltimo valor, 
     * pois este comportamento gera erro no IE quando os componentes no esto visveis
     * 
     * @Override
     */
    parseAnchor : function(a, start, cstart) {
        if (a && a != 'none') {
            // standard anchor
            if (this.parseAnchorRE.test(a)) {
                var diff = cstart - start;
                return function(v){
                    return v - diff;
                };
            // percentage
            } else if(a.indexOf('%') != -1) { 
                var ratio = parseFloat(a.replace('%', ''))*.01;
                return function(v){
                      return Math.floor(v*ratio);
                };
            // simple offset adjustment
            } else {
                a = parseInt(a, 10);
                if (!isNaN(a)) {
                    return function(v) {
                          return v + a;
                    };
                }
            }
        }
        return false;
    }
});

Ext.Container.LAYOUTS['seniorform'] = Ext.ux.senior.layout.FormLayout;

