Ext.namespace('Ext.ux.senior.layout');

Ext.ux.senior.layout.BorderLayout = Ext.extend(Ext.layout.BorderLayout, {

    renderItem : function(component, position, target) {
        Ext.ux.senior.layout.BorderLayout.superclass.renderItem.apply(this, arguments);
    }

});

var originalSlideOut = Ext.layout.BorderLayout.Region.prototype.slideOut;
Ext.layout.BorderLayout.Region.prototype.slideOut = function() {

    if (this.panel.hideOriginalBarOnSlide === true) {
        this.isInSlid = true;
        this.panel.expand();
        Ext.getDoc().on("click", this.slideInIf, this);
    } else {
        originalSlideOut.call(this);
    }
};

var originalSlideIn = Ext.layout.BorderLayout.Region.prototype.slideIn;
Ext.layout.BorderLayout.Region.prototype.slideIn = function() {

    if (this.panel.hideOriginalBarOnSlide === true) {
        this.panel.collapse();
        this.clearMonitor();
        this.isInSlid = false;
    } else {
        originalSlideIn.call(this);
    }
};

Ext.layout.BorderLayout.Region.prototype.onExpand = function() {

    this.isCollapsed = false;
    if (this.splitEl) {
        this.splitEl.show();
    }

    if (this.panel.hideOriginalBarOnSlide && this.isInSlid == true) {
        // comportamento especfico para paineis no south com a propriedade hideOriginalBarOnSlide definida.
        var size = this.layout.getLayoutTargetSize();
        var w = size.width, h = size.height, centerH = h, s = this.layout.south, b, m, totalHeight;

        if (s && s.isVisible()) {
            b = s.getSize();
            m = s.getMargins();
            b.width = w - (m.left + m.right);
            b.x = m.left;
            totalHeight = (b.height + m.top + m.bottom);
            b.y = h - totalHeight + m.top;
            centerH -= totalHeight;
            s.applyLayout(b);
        }
        this.panel.el.setStyle('z-index', this.floatingZIndex+5);
    } else {
        this.layout.layout();
        this.panel.el.setStyle('z-index', this.originalZIndex);
    }

    this.state.collapsed = false;
    this.panel.saveState();
};

Ext.layout.BorderLayout.SplitRegion.prototype.onSplitMove =

Ext.layout.BorderLayout.SplitRegion.prototype.onSplitMove.createSequence(function(split, newSize) {
    var panel = this.panel;
    var panelSize = panel.getSize();
    var map = {
        type : 'splitMove',
        width : panelSize.width,
        height : panelSize.height
    };

    for ( var i = 0; i < panel.plugins.length; i++) {
        if (panel.plugins[i] instanceof Ext.ux.senior.plugins.EventManagerPlugin) {
            panel.plugins[i].sendData(map, 'splitMove', panel);
            break;
        }
    }

}, false);

Ext.layout.BorderLayout.Region.prototype.onCollapse =

Ext.layout.BorderLayout.Region.prototype.onCollapse.createSequence(function() {
    if (this.position === 'north' || this.position === 'south' || this.position === 'center') {
        this.expandToolEl.addClass('x-collapse-left');
    }
}, false);

Ext.layout.BorderLayout.Region.prototype.collapseClick =

Ext.layout.BorderLayout.Region.prototype.collapseClick.createSequence(function() {
    this.isInSlid = false;
}, false);

Ext.layout.BorderLayout.Region.prototype.applyLayoutCollapsed =

Ext.layout.BorderLayout.Region.prototype.applyLayoutCollapsed.createSequence(function() {
    // Quando ocorre um resize no browser o layout do componente deve ser atualizado,
    // portanto alinhamos o componente novamente com o elemento de collapse.
    this.panel.el.alignTo(this.collapsedEl, this.getCollapseAnchor());

    // Aps o resize deve ser recalculado a largura do componente, para
    // que ele fique conforme o elemento de collapse.
    var height;
    if (this.position === 'south' || this.position === 'north') {
        this.panel.body.setWidth(this.getCollapsedEl().getWidth());
        this.panel.setWidth(this.getCollapsedEl().getWidth());

    } else if (this.position === 'east' || this.position === 'west') {
        // Retira a altura do header para calcular a altura correta do body.
        height = this.getCollapsedEl().getHeight() - this.panel.header.getHeight();
        this.panel.body.setHeight(height);
    }

}, false);

//Essa propriedade  responsavel por fazer com que panel flutuante, utilizado ao ocorrer um fastView.
//Possa permanecer na frente da modal e do elemento de block.
Ext.layout.BorderLayout.Region.prototype.floatingZIndex = 20000;

Ext.Container.LAYOUTS['seniorborder'] = Ext.ux.senior.layout.BorderLayout;