Ext.namespace('Ext.ux.senior.layout');

Ext.ux.senior.layout.AbsoluteLayout = Ext.extend(Ext.layout.AbsoluteLayout, {
	
	renderItem : function(component, position, target) {
		Ext.ux.senior.layout.AbsoluteLayout.superclass.renderItem.apply(this, arguments);
	},
    
    /**
     * Sobrescreve o original para que no exista cache de ltimo valor, 
     * pois este comportamento gera erro no IE quando os componentes no esto visveis
     * 
     * @Override
     */
    parseAnchor : function(a, start, cstart) {
        if (a && a != 'none') {
            // standard anchor
            if (this.parseAnchorRE.test(a)) {
                var diff = cstart - start;
                return function(v){
                    return v - diff;
                };
            // percentage
            } else if(a.indexOf('%') != -1) { 
                var ratio = parseFloat(a.replace('%', ''))*.01;
                return function(v){
                      return Math.floor(v*ratio);
                };
            // simple offset adjustment
            } else {
                a = parseInt(a, 10);
                if (!isNaN(a)) {
                    return function(v) {
                          return v + a;
                    };
                }
            }
        }
        return false;
    }
	
});

Ext.Container.LAYOUTS['seniorabsolute'] = Ext.ux.senior.layout.AbsoluteLayout;

