Ext.ns('Ext.ux.senior.grid.column');

/**
 * @author Jean.Kirchner
 */
Ext.ux.senior.grid.column.StatusColumn = Ext.extend(Ext.ux.senior.grid.column.DefaultColumn, {

    dataIndex : 0, /* O fato do dataIndex ser 0 no faz com que a coluna seja marcada como alterada (doritos), */
    grid : null,
    header : null,
    changes : null,
    width : 25,
    resizable : false,
    sortable : false,
    menuDisabled : true,
    fixed : true,
    objTooltip : null,
    hints : null,
    headerChecked : false,
    /**
     * Define se a coluna da grid vai ter checkBox. 
     */
    showCheckBox : false,

    /**
     * @template
     */
    init : function(grid) {
        this.grid = grid;

        /* id do elemento do header */
        this.elId = grid.getId() + 'status-column';

        this.header = Ext.ux.senior.grid.column.StatusColumn.headerTemplate.apply({
            id : this.elId
        });

        grid.on("render", function(ct, position) {
            this.onRender(ct, position);
        }, this);

        grid.on('columnresize', function(columnIndex, newSize) {
            this.refreshStatus();
        }, this);
    },

    /**
     * Gera o html necessrio para a renderizao desta coluna
     * 
     * @override Ext.grid.Column#renderer
     */
    renderer : function(value, metadata, record, rowIndex, colIndex, store) {
        var cls = "";
        var style = "";
        if (record.phantom) {
            cls = Ext.ux.senior.grid.column.StatusColumn.cls;
            if (record.error) {
                style = 'background-image : url(resources/images/grid/new_error_record.png)';
            } else {
                style = 'background-image : url(resources/images/grid/new_record.png)';
            }
        } else if (record.dirty) {
            cls = Ext.ux.senior.grid.column.StatusColumn.cls;
            if (record.error) {
                style = 'background-image : url(resources/images/grid/changed_error_record.png)';
            } else {
                style = 'background-image : url(resources/images/grid/changed_record.png)';
            }
        }
        return Ext.ux.senior.grid.column.StatusColumn.template.apply({
            cls : cls,
            style : style
        });
    },

    /**
     * @private
     */
    onRender : function() {
        /**
         * Necessrio para o tooltip, ele precisa saber se j pode criar os htmls do tooltip
         */
        this.rendered = true;
        if (this.changes) {
            this.setChanges(this.changes);
        }
    },

    /**
     * Retorna se as clulas desta coluna podem ser selecionadas ao navegar ou clicar.
     * 
     * @public
     */
    isSelectable : function() {
        return false;
    },

    /**
     * Retorna o elemento onde deve ser aplicado o hint
     * 
     * @private
     */
    getHintTarget : function() {
        return Ext.get(this.elId);
    },

    /**
     * Atualiza na view o estado das alteraes do header da coluna status.
     * 
     * @public
     */
    refreshStatus : function() {
        if (this.changes) {
            this.setChanges(this.changes);
        }
    },

    /**
     * Monta quantidade de registros alterados, excluidos e inseridor para mostrar como hint no StatusColumn
     * 
     * Changes deve ter as trs propriedades: inserted modified removed
     * 
     * @public
     */
    setChanges : function(changes) {
        //armazena para que quando as colunas forem movidas de lugar, restaurar o icone/hints da coluna
        this.changes = changes;

        this.getHintTarget().removeClass('senior-status-attention');
        this.getHintTarget().removeClass('senior-status-attention-error');
        if (!changes) {
            if (this.objTooltip) {
                this.objTooltip.disable();
            }
            this.hints = null;
            return;
        }
        this.getHintTarget().addClass('senior-statusColumn-header');

        //Hints de alteraes pendentes para aplicar na grid. 
        this.hints = [ {
            icon : 'resources/images/grid/new_record.png',
            text : String.format(changes.inserted > 1 ? '{0} registros inseridos' : '{0} registro inserido', changes.inserted)
        }, {
            icon : 'resources/images/grid/deleted_record.png',
            text : String.format(changes.removed > 1 ? '{0} registros removidos' : '{0} registro removido', changes.removed)
        }, {
            icon : 'resources/images/grid/changed_record.png',
            text : String.format(changes.modified > 1 ? '{0} registros alterados' : '{0} registro alterado', changes.modified)
        }, {
            icon : 'resources/images/shared/error.png',
            text : String.format(changes.error > 1 ? '{0} registros com erro' : '{0} registro com erro', changes.error)
        } ];

        this.getHintTarget().addClass(changes.error == 0 ? 'senior-status-attention' : 'senior-status-attention-error');
        //Destri o atual objeto de hints da coluna de status da grid antes de recri-lo com as novas alteraes
        this.destroyTooltipObject();

        if (this.rendered) {
            this.objTooltip = TooltipHelper.createHintsHtml(this.hints, this.getHintTarget(), false, this.showHintsFunction);
        }
    },

    /**
     * Funo para apresentar os hints de alteraes pendentes para aplicar na grid
     */
    showHintsFunction : function() {
        if (this.anchorTarget && this.anchorTarget.isVisible()) {
            Ext.ToolTip.prototype.show.apply(this, arguments);
        }
    },

    /**
     * Retorna nulo para que no seja adicionado um Tooltip no header da coluna de status do registro
     * 
     * @override DefaultColumn#getHeaderTooltip
     */
    getHeaderTooltip : function() {
        return null;
    },

    /**
     * Destri o objeto Ext.Tooltip da coluna de status
     */
    destroyTooltipObject : function() {
        if (this.objTooltip != null) {/* Se no houver hints para criar e existir o objeto de hints, destri o objeto */
            this.objTooltip.destroy();
            this.objTooltip = null;
        }
    }

});

/**
 * @static
 */
Ext.ux.senior.grid.column.StatusColumn.template = new Ext.Template("<div class='{cls}' style='{style}'>&#160;</div>");

/**
 * @static
 */
Ext.ux.senior.grid.column.StatusColumn.headerTemplate = new Ext.Template("<div id='{id}'>&nbsp;</div>");

/**
 * @static
 */
Ext.ux.senior.grid.column.StatusColumn.cls = "senior-statusColumn";

Ext.reg('statuscolumn', Ext.ux.senior.grid.column.StatusColumn);
Ext.grid.Column.types['statuscolumn'] = Ext.ux.senior.grid.column.StatusColumn;