Ext.ns('Ext.ux.senior.grid.column');

/**
 * @author Jean.Kirchner
 */
Ext.ux.senior.grid.column.DeleteColumn = Ext.extend(Ext.ux.senior.grid.column.DefaultColumn, {

    width : 22,
    header : "",
    resizable : false,
    menuDisabled : true,
    fixed : true,
    grid : null,

    dataIndex : 0, /* Essa coluna no utiliza, no entanto quanto existem stores os renderizadores precisam que esta coluna tenha um dataIndex */

    /**
     * Mtodo de inializao de plugins
     * 
     * @template
     */
    init : function(grid) {
        /* Monta um id nico para as linhas de delete desta grid */
        this.elId = grid.getId() + "delete-column-";

        this.grid = grid;
        this.grid.on('rowmouseover', this.showDelete, this);
        this.grid.on('rowmouseout', this.hideDelete, this);
        this.grid.on('rowmousedown', this.completeEditor, this);
        this.grid.on('rowclick', this.processDelete, this);

    },

    /**
     * Gera o html necessrio para a renderizao desta coluna
     * 
     * @override Ext.grid.Column#renderer
     */
    renderer : function(value, metadata, record, rowIndex, colIndex, store) {
        var rowId = this.elId + record.id;
        return Ext.ux.senior.grid.column.DeleteColumn.template.apply( {
            id : rowId
        });
    },

    /**
     * Pega os elementos das linhas
     * 
     * @private
     */
    el : function(rowIndex) {
        var recId = this.grid.getStore().getAt(rowIndex).id;
        return Ext.get(this.elId + recId);
    },

    /**
     * @event rowmouseover
     * @private
     */
    showDelete : function(grid, rowIndex, evt) {
        /* Limpa o estilo das linhas pois eles sero setados novamente logo abaixo. 
         * E quando a grid altera o readOnly sem que o usurio tire o ponteiro do mouse de cima da linha a imagem do "X" tem que ser trocada sem passar no hide*/
        var xEl = this.el(rowIndex);
        xEl.removeClass(Ext.ux.senior.grid.column.DeleteColumn.css);
        xEl.removeClass(Ext.ux.senior.grid.column.DeleteColumn.css_disabled);
        if (this.grid.isAllowDelete() && !this.grid.isReadOnly()) {
            xEl.addClass(Ext.ux.senior.grid.column.DeleteColumn.css);
        } else {
            xEl.addClass(Ext.ux.senior.grid.column.DeleteColumn.css_disabled);
        }
        return true;
    },

    /**
     * @event rowmouseout
     * @private
     */
    hideDelete : function(grid, rowIndex, evt) {
        this.el(rowIndex).removeClass(Ext.ux.senior.grid.column.DeleteColumn.css);
        this.el(rowIndex).removeClass(Ext.ux.senior.grid.column.DeleteColumn.css_disabled);
        return true;
    },

    /**
     * @event rowmousedown
     * @private
     */
    completeEditor : function(grid, rowIndex, evt) {
        if (grid.activeEditor) {
            grid.activeEditor.completeEdit();
        }
    },

    /**
     * @event rowclick
     * @private
     */
    processDelete : function(grid, rowIndex, evt) {
        if (this.grid.isAllowDelete() && !this.grid.isReadOnly()) {
            /* Se o click for no elemento de delete da linha dispara o evento */
            if (Ext.get(evt.target).is('div.' + Ext.ux.senior.grid.column.DeleteColumn.css)) {
                /*var selectionModel = grid.getSelectionModel();
                if(selectionModel.reqObj){
                    selectionModel.reqObj = null;
                }*/
                grid.fireEvent('deleteRow', rowIndex);
                return false;
            }
        }
        return true;
    },

    /**
     * Retorna se as clulas desta coluna podem ser selecionadas ao navegar ou clicar.
     */
    isSelectable : function() {
        return false;
    }

});

/**
 * @static
 */
Ext.ux.senior.grid.column.DeleteColumn.template = new Ext.Template("<div id='{id}'>&#160;</div>");

/**
 * @static
 */
Ext.ux.senior.grid.column.DeleteColumn.css = "x-senior-deleteColumn";

/**
 * @static
 */
Ext.ux.senior.grid.column.DeleteColumn.css_disabled = "x-senior-deleteColumn-disabled";

Ext.reg('deletecolumn', Ext.ux.senior.grid.column.DeleteColumn);
Ext.grid.Column.types['deletecolumn'] = Ext.ux.senior.grid.column.DeleteColumn;