Ext.ns('Ext.ux.senior.grid');
/**
 * View responsvel por manipular colunas fixas da grid.<br>
 * 
 * Este arquivo tem vrios mtodos que foram sobrescritos pois a estrutura da grid mudou bastante e o GridView do ext no  to flexvel.<br>
 * Tambm faz uma pequena otimizao quando no h colunas fixas, onde ele apenas chama mtodos da superclass, evitando assim possveis problemas com
 * as funes que foram sobrescritas.
 * 
 * Extende a GridView da senior para no perder as funcionalidades de scroll e seleo.<br>
 * Apesar da coluna fixa ser padro das grids da senior, o seu cdigo foi separado em outra GridView para organizao e facilidade na leitura.
 * 
 * Para maiores detalhes sobre documentao dos mtodos  s consultar o GridView do ExtJs.
 * 
 * @author Patrick.Nascimento
 */
Ext.ux.senior.grid.FixedColumnView = Ext.extend(Ext.ux.senior.grid.GridView, {
    
    constructor : function(config) {
        this.sclass = Ext.ux.senior.grid.FixedColumnView.superclass;
        this.sclass.constructor.call(this, config);
    },

    lockText : 'Lock',
    unlockText : 'Unlock',

    rowBorderWidth : 1,
    lockedBorderWidth : 1,

    syncHeights : true,

    /**
     * O template principal da grid foi alterado para permitir que existam colunas fixas.<br>
     * Resumindo, existem duas 'grids' dentro de uma, onde uma delas  fixa e a outra tem scroll.
     * 
     * @override
     * @private
     */
    initTemplates : function() {
        this.sclass = Ext.ux.senior.grid.FixedColumnView.superclass;

        var ts = this.templates || {};

        
          if (!ts.master) { 
              ts.master = new Ext.Template(
                '<div class="x-grid3" style="height : 100%; width : 100%" hidefocus="true">',
                    '<div class="ux-grid3-fixedcolumn ux-grid3-fixedcolumn-separator">',
                        '<div class="x-grid3-header"><div class="x-grid3-header-inner"><div class="x-grid3-header-offset" style="{ostyle}">{lockedHeader}</div></div><div class="x-clear"></div></div>',
                        '<div class="x-grid3-scroller"><div class="x-grid3-body" style="{bstyle}">{lockedBody}</div><div class="x-grid3-scrollarea"style="height:17px"></div><a href="#" class="x-grid3-focus" tabIndex="-1"></a></div>',
                    '</div>',
                    '<div class="x-grid3-viewport ux-grid3-unfixedcolumn">',
                        '<div class="x-grid3-header"><div class="x-grid3-header-inner"><div class="x-grid3-header-offset" style="{ostyle}">{header}</div></div><div class="x-clear"></div></div>',
                        '<div class="x-grid3-scroller"><div class="x-grid3-body" style="{bstyle}">{body}</div><a href="#" class="x-grid3-focus" tabIndex="-1"></a></div>',
                    '</div>',
                  '<div class="x-grid3-resize-marker">&#160;</div>',
                  '<div class="x-grid3-resize-proxy">&#160;</div>',
              '</div>');
          }
         

        this.templates = ts;
        this.sclass.initTemplates.call(this);
    },

    getEditorParent : function(ed) {
        return this.el.dom;
    },

    /**
     * Como o template mudou, temos que inicializar os elementos pertencentes  coluna fixa.<br>
     * No chama a superclass para os outros elementos porque ela no sabe utilizar o nosso template.
     * 
     * @override
     * @private
     */
    initElements : function() {
        var E = Ext.Element,
            el = Ext.get(this.grid.getGridEl().dom.firstChild), cs = el.dom.childNodes;

        this.el = new E(el);
        this.lockedWrap = new E(cs[0]);
        this.lockedHd = new E(this.lockedWrap.dom.firstChild);
        this.lockedInnerHd = this.lockedHd.dom.firstChild;
        this.lockedScroller = new E(this.lockedWrap.dom.childNodes[1]);
        this.lockedBody = new E(this.lockedScroller.dom.firstChild);
        this.lockedScrollArea = new E(this.lockedScroller.dom.childNodes[1]);
        this.lockedScrollArea.setVisibilityMode(Ext.Element.DISPLAY);
        
        this.mainWrap = new E(cs[1]);
        this.mainHd = new E(this.mainWrap.dom.firstChild);

        if (this.grid.hideHeaders) {
            this.lockedHd.setDisplayed(false);
            this.mainHd.setDisplayed(false);
        }

        this.innerHd = this.mainHd.dom.firstChild;
        this.scroller = new E(this.mainWrap.dom.childNodes[1]);

        if (this.forceFit) {
            this.scroller.setStyle('overflow-x', 'hidden');
        }

        this.mainBody = new E(this.scroller.dom.firstChild);
        this.focusEl = new E(this.scroller.dom.childNodes[1]);
        this.resizeMarker = new E(cs[2]);
        this.resizeProxy = new E(cs[3]);

        this.focusEl.swallowEvent('click', true);
    },

    /**
     * Retorna um array com as linhas das colunas fixas.
     * 
     * @private
     */
    getLockedRows : function() {
        return this.hasRows() ? this.lockedBody.dom.childNodes : [];
    },

    /**
     * Retorna uma linha da coluna fixa, de acordo com o ndice.
     * 
     * @paramn {Integer) row ndice da linha.
     * 
     * @private
     */
    getLockedRow : function(row) {
        return this.getLockedRows()[row];
    },
    
    hasFixedColumns : function(){
        return true; // this.cm && this.cm.getLockedCount() > 0;
    },

    /**
     * Sobrescrito pois esta clula pode estar em uma coluna fixa.
     * 
     * @override
     * @private
     */
    getCell : function(row, col) { 
        /**
         * Se no houver linhas no tenta pegar a celula
         * 
         * Quando  adicionado uma nova linha no Store, e a linha antiga esta em edio, o evento de add, primeiro cancela o editor. A ao de
         * cancelar o editor tenta recuperar a celula da linha que no existe mais.
         */
        if(this.getRows().length == 0) {
            return null;
        }
        
        if(!this.hasFixedColumns()){
            return this.sclass.getCell.call(this, row, col);
        }
        
        var llen = this.cm.getLockedCount();
        if (col < llen) {
            return this.getLockedRow(row).getElementsByTagName('td')[col];
        }
        
        return this.sclass.getCell.call(this, row, col - llen);
    },

    /**
     * Sobrescrito pois essa clula do cabealho pode estar em uma coluna fixa.
     * 
     * @override
     * @private
     */
    getHeaderCell : function(index) {
        if(!this.hasFixedColumns()){
            return this.sclass.getHeaderCell.call(this, index);
        }
        
        var llen = this.cm.getLockedCount();
        if (index < llen) {
            return this.lockedHd.dom.getElementsByTagName('td')[index];
        }
        return this.sclass.getHeaderCell.call(this, index - llen);
    },

    /**
     * Sobrescrito pois pode haver coluna fixa, e as linhas da coluna fixa tambm devem receber o estilo.
     * 
     * @override
     * @private
     */
    addRowClass : function(row, cls) {
        if(!this.hasFixedColumns()){
            this.sclass.addRowClass.call(this, row, cls);
            return;
        }
        var r = this.getLockedRow(row);
        if (r) {
            this.fly(r).addClass(cls);
        }
        this.sclass.addRowClass.call(this, row, cls);
    },

    /**
     * Sobrescrito pois pode haver coluna fixa, e as estilos das linhas da coluna fixa tambm devem ser removidos.
     * 
     * @override
     * @private
     */
    removeRowClass : function(row, cls, ignoreCustomStyle) {
       if(row > this.getLockedRows().length || row < 0){
            if(!this.hasFixedColumns()){
                Ext.ux.senior.grid.FixedColumnView.superclass.removeRowClass.call(this, row, cls, ignoreCustomStyle);
            }
            return;
        }
        
        var r = this.getLockedRow(row);
        if (r) {
            this.fly(r).removeClass(cls);
        }
        this.sclass.removeRowClass.call(this, row, cls, ignoreCustomStyle);
    },

    /**
     * Remove a linha da coluna fixa e delega o resto para superclass.
     * 
     * @override
     * @private
     */
    removeRow : function(row) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.removeRow.call(this, row);
            return;
        }
        Ext.removeNode(this.getLockedRow(row));
        this.sclass.removeRow.call(this, row);
    },

    /**
     * Remove as linhas da coluna fixa e delega o resto para superclass.
     * 
     * @override
     * @private
     */
    removeRows : function(firstRow, lastRow) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.removeRows.call(this, firstRow, lastRow);
            return;
        }
        var bd = this.lockedBody.dom;
        for ( var rowIndex = firstRow; rowIndex <= lastRow; rowIndex++) {
            Ext.removeNode(bd.childNodes[firstRow]);
        }
        this.sclass.removeRows.call(this, firstRow, lastRow);
    },

    /**
     * Ajusta o scrollTop do container da coluna fixa e delega o resto para superclass.
     * 
     * @override
     * @private
     */
    syncScroll : function(e) {
        var mb = this.scroller.dom;
        this.lockedScroller.dom.scrollTop = mb.scrollTop;
        this.sclass.syncScroll.call(this, e);
    },

    /**
     * Caso pertencer  coluna fixa, atualiza, seno delega  superclass, com ndice certo.
     * 
     * @override
     * @private
     */
    updateSortIcon : function(col, dir) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.updateSortIcon.call(this, col, dir);
            return;
        }
        var llen = this.cm.getLockedCount();
        if (col < llen) {
            var sc = this.sortClasses;
            var lhds = this.lockedHd.select('td').removeClass(sc);
            lhds.item(col).addClass(sc[dir == 'DESC' ? 1 : 0]);
        } else {
            this.sclass.updateSortIcon.call(this, col - llen, dir);
        }
    },
    
    /**
     * 
     * @override
     */
    verifyNeedShowScroll : function() {
        var width = this.grid.getEl().child('.x-grid3').getWidth();
        var lw = this.cm.getTotalLockedWidth();
        if (this.isVerticalScrollVisible() && !this.grid.autoHeight) {
            this.scroller.setWidth(width - this.getScrollOffset() - lw);
            this.scrollWrap.setStyle("display", "");
        } else {
            this.scroller.setWidth(width - lw);
            this.scrollWrap.setStyle("display", "none");
        }
    },

    /**
     * Sobrescrito pois no tem como fazer o cdigo do Ext ignorar as colunas fixas.
     * 
     * @override
     * @private
     */
    updateAllColumnWidths : function() {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.updateAllColumnWidths.call(this);
            return;
        }
        var tw = this.getTotalWidth(), clen = this.cm.getColumnCount(), lw = this.getLockedWidth(), llen = this.cm.getLockedCount(), ws = [], len, i;
        this.updateLockedWidth();
        for (i = 0; i < clen; i++) {
            ws[i] = this.getColumnWidth(i);
            var hd = this.getHeaderCell(i);
            hd.style.width = ws[i];
        }
        var lns = this.getLockedRows(), ns = this.getRows(), row, trow, j;
        for (i = 0, len = ns.length; i < len; i++) {
            row = lns[i];
            row.style.width = lw;
            if (row.firstChild) {
                row.firstChild.style.width = lw;
                trow = row.firstChild.rows[0];
                for (j = 0; j < llen; j++) {
                    trow.childNodes[j].style.width = ws[j];
                }
            }
            row = ns[i];
            row.style.width = tw;
            if (row.firstChild) {
                row.firstChild.style.width = tw;
                trow = row.firstChild.rows[0];
                for (j = llen; j < clen; j++) {
                    trow.childNodes[j - llen].style.width = ws[j];
                }
            }
        }
        this.onAllColumnWidthsUpdated(ws, tw);
        this.syncHeaderHeight();
    },

    updateColumnWidth : function(col, width) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.updateColumnWidth.call(this, col, width);
            return;
        }
        var w = this.getColumnWidth(col), llen = this.cm.getLockedCount(), ns, rw, c, row;
        this.updateLockedWidth();
        if (col < llen) {
            ns = this.getLockedRows();
            rw = this.getLockedWidth();
            c = col;
        } else {
            ns = this.getRows();
            rw = this.getTotalWidth();
            c = col - llen;
        }
        var hd = this.getHeaderCell(col);
        hd.style.width = w;
        for ( var i = 0, len = ns.length; i < len; i++) {
            row = ns[i];
            row.style.width = rw;
            if (row.firstChild) {
                row.firstChild.style.width = rw;
                row.firstChild.rows[0].childNodes[c].style.width = w;
            }
        }
        this.onColumnWidthUpdated(col, w, this.getTotalWidth());
        this.syncHeaderHeight();
    },

    /**
     * Atualiza uma coluna fixa.
     */
    updateColumnHidden : function(col, hidden) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.updateColumnHidden.call(this, col, hidden);
            return;
        }
        
        var llen = this.cm.getLockedCount(), ns, rw, c, row, display = hidden ? 'none' : '';
        this.updateLockedWidth();
        if (col < llen) {
            ns = this.getLockedRows();
            rw = this.getLockedWidth();
            c = col;
        } else {
            ns = this.getRows();
            rw = this.getTotalWidth();
            c = col - llen;
        }
        var hd = this.getHeaderCell(col);
        hd.style.display = display;
        for ( var i = 0, len = ns.length; i < len; i++) {
            row = ns[i];
            row.style.width = rw;
            if (row.firstChild) {
                row.firstChild.style.width = rw;
                row.firstChild.rows[0].childNodes[c].style.display = display;
            }
        }
        this.onColumnHiddenUpdated(col, hidden, this.getTotalWidth());
        delete this.lastViewWidth;
        this.layout();
    },

    
    /**
     * Renderiza as linhas da Grid
     */
    doRender : function(columns, records, store, startRow, colCount, stripe) {
        if(!this.hasFixedColumns()){
            return Ext.ux.senior.grid.FixedColumnView.superclass.doRender.call(this, columns, records, store, startRow, colCount, stripe);
        }
        
        var templates = this.templates, templatesCell = templates.cell, templatesRow = templates.row, last = colCount - 1, tstyle = 'width:' + this.getTotalWidth() + ';';
        var lstyle = 'width:' + this.getLockedWidth() + ';', buf = [], lbuf = [], cb, lcb, column, colProp = {}, rowProp = {}, row;
        for ( var j = 0, len = records.length; j < len; j++) {
            row = records[j];
            cb = [];
            lcb = [];
            var rowIndex = (j + startRow);
            for ( var i = 0; i < colCount; i++) {
            	column = columns[i];
                colProp.id = column.id;
                colProp.css = (i === 0 ? 'x-grid3-cell-first ' : (i == last ? 'x-grid3-cell-last ' : ''))
                        + (this.cm.config[i].cellCls ? ' ' + this.cm.config[i].cellCls : '');
                colProp.attr = colProp.cellAttr = '';
                colProp.value = column.renderer.call(column.scope, row.data[column.name], colProp, row, rowIndex, i, store);
                colProp.style = column.style;
                if (Ext.isEmpty(colProp.value)) {
                	colProp.value = '&#160;';
                }
                if (this.markDirty && row.dirty && Ext.isDefined(row.modified[column.name])) {
                    colProp.css += ' x-grid3-dirty-cell';
                }
                if (column.locked) {
                    lcb[lcb.length] = templatesCell.apply(colProp);
                } else {
                    cb[cb.length] = templatesCell.apply(colProp);
                }
            }
            var alt = [];
            if (stripe && ((rowIndex + 1) % 2 === 0)) {
                alt[0] = 'x-grid3-row-alt';
            }
            if (row.dirty) {
                alt[1] = ' x-grid3-dirty-row';
            }
            rowProp.cols = colCount;
            if (this.getRowClass) {
                alt[2] = this.getRowClass(row, rowIndex, rowProp, store);
            }
            rowProp.alt = alt.join(' ');
            rowProp.cells = cb.join('');
            rowProp.tstyle = tstyle;
            buf[buf.length] = templatesRow.apply(rowProp);
            rowProp.cells = lcb.join('');
            rowProp.tstyle = lstyle;
            lbuf[lbuf.length] = templatesRow.apply(rowProp);
        }
        this.syncFocusEl(this.scroller.getXY());
        this.addRemoveFixedColumnSeparator();
        return [ buf.join(''), lbuf.join('') ];
    },

    /**
     * Processa as linhas da coluna fixa e delega o resto para a superclass.
     * 
     * @override
     * @private
     */
    processRows : function(startRow, skipStripe) {
        if (!this.ds || this.ds.getCount() < 1) {
            return;
        }
        var rows = this.getLockedRows(), row;
        skipStripe = skipStripe || !this.grid.stripeRows;
        startRow = startRow || 0;
        var otherRows = this.getRows();

        for ( var i = 0, len = rows.length; i < len; ++i) {
            row = rows[i];
            row.rowIndex = i;
            if (!skipStripe) {
                row.className = row.className.replace(this.rowClsRe, ' ');
                if ((i + 1) % 2 === 0) {
                    row.className += ' x-grid3-row-alt';
                }
            }

            if (this.syncHeights) {
                var el1 = Ext.get(row), el2 = Ext.get(otherRows[i]), h1 = el1.getHeight(), h2 = el2.getHeight();

                if (h1 > h2) {
                    el2.setHeight(h1);
                } else if (h2 > h1) {
                    el1.setHeight(h2);
                }
            }
        }
        if (startRow === 0) {
            Ext.fly(rows[0]).addClass(this.firstRowCls);
        }
        Ext.fly(rows[rows.length - 1]).addClass(this.lastRowCls);
        this.sclass.processRows.call(this, startRow, skipStripe);
    },

    /**
     * Sobrescrito pois o renderRows retorna um array e o ext no sabe tratar isto.
     * 
     * @override
     * @private
     */
    afterRender : function() {
        if(!this.hasFixedColumns()){
            this.lockedBody.dom.innerHTML = '&#160;';
            Ext.ux.senior.grid.FixedColumnView.superclass.afterRender.call(this);
            return;
        }
        
        if (!this.ds || !this.cm) {
            return;
        }
        var bd = this.renderRows() || [ '&#160;', '&#160;' ];
        this.mainBody.dom.innerHTML = bd[0];
        this.lockedBody.dom.innerHTML = bd[1];
        this.processRows(0, true);
        if (this.deferEmptyText !== true) {
            this.applyEmptyText();
        }

        if (this.grid.border === false) {
            /* de acordo com analista e seus requisitos, sem borda deixa header transparente. */
            this.lockedHd.addClass("ux-grid-transparent-header");
        }

        this.grid.fireEvent('viewready', this.grid);
    },

    /**
     * Sobrescrito pois o template mudou, ento o html gerado para ser definido no innerHtml da grid deve ser um s, alm de ser definido uma unica
     * vez.
     */
    renderUI : function() {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.renderUI.call(this);
            return;
        }
        
        var header = this.renderHeaders();
        var body = this.templates.body.apply( { rows : '&#160;'} );
        return this.templates.master.apply( {
            body : body,
            header : header[0],
            ostyle : 'width:' + this.getOffsetWidth() + ';',
            bstyle : 'width:' + this.getTotalWidth() + ';',
            lockedBody : body,
            lockedHeader : header[1],
            lstyle : 'width:' + this.getLockedWidth() + ';'
        });
    },
    
    afterRenderUI : function() {
        var g = this.grid;
        this.initElements();

        Ext.fly(this.innerHd).on('click', this.handleHdDown, this);
        Ext.fly(this.lockedInnerHd).on('click', this.handleHdDown, this);

        this.mainHd.on({scope : this, mouseover : this.handleHdOver, mouseout : this.handleHdOut, mousemove : this.handleHdMove });
        this.lockedHd.on({scope : this, mouseover : this.handleHdOver, mouseout : this.handleHdOut, mousemove : this.handleHdMove });

        this.scroller.on('scroll', this.syncScroll, this);

        if (g.enableColumnResize !== false) {
            this.splitZone = new Ext.grid.GridView.SplitDragZone(g, this.mainHd.dom);
            this.splitZone.setOuterHandleElId(Ext.id(this.lockedHd.dom));
            this.splitZone.setOuterHandleElId(Ext.id(this.mainHd.dom));
        }

        if (g.enableColumnMove) {
            this.columnDrag = new Ext.grid.GridView.ColumnDragZone(g, this.innerHd);
            this.columnDrag.setOuterHandleElId(Ext.id(this.lockedInnerHd));
            this.columnDrag.setOuterHandleElId(Ext.id(this.innerHd));
            this.columnDrop = new Ext.ux.senior.grid.FixedColumnView.HeaderDropZone(g, this.mainHd.dom);
        }

        if (g.enableHdMenu !== false) {
            this.hmenu = new Ext.menu.Menu( { id : g.id + '-hctx' } );
            this.hmenu.add( { itemId : 'asc', text : this.sortAscText, cls : 'xg-hmenu-sort-asc' },
                            { itemId : 'desc', text : this.sortDescText, cls : 'xg-hmenu-sort-desc'} );
            
            if (this.grid.enableColLock !== false) {
                this.hmenu.add('-', {itemId : 'lock', text : this.lockText, cls : 'xg-hmenu-lock'},
                                    {itemId : 'unlock', text : this.unlockText, cls : 'xg-hmenu-unlock'} ); 
            }
            if (g.enableColumnHide !== false) {
                this.colMenu = new Ext.menu.Menu( { id : g.id + '-hcols-menu'} );
                this.colMenu.on( { scope : this, beforeshow : this.beforeColMenuShow, itemclick : this.handleHdMenuClick} );
                this.hmenu.add('-', { itemId : 'columns', hideOnClick : false, text : this.columnsText, menu : this.colMenu, iconCls : 'x-cols-icon'} );
            }
            this.hmenu.on('itemclick', this.handleHdMenuClick, this);
        }
        if (g.trackMouseOver) {
            this.mainBody.on({ scope : this, mouseover : this.onRowOver, mouseout : this.onRowOut });
            this.lockedBody.on({ scope : this, mouseover : this.onRowOver, mouseout : this.onRowOut });
        }

        if (g.enableDragDrop || g.enableDrag) {
            this.dragZone = new Ext.grid.GridDragZone(g, { ddGroup : g.ddGroup || 'GridDD' });
        }
        this.updateHeaderSortState();
    },

    layout : function() {
        if (!this.mainBody) {
            return;
        }
        var g = this.grid;
        var c = g.getGridEl();
        var csize = c.getSize(true);
        var vw = csize.width;
        if ((vw < 20 || csize.height < 20)) {
            return;
        }
        this.syncHeaderHeight();
        if (g.autoHeight) {
            this.scroller.dom.style.overflow = 'visible';
            this.lockedScroller.dom.style.overflow = 'visible';
            if (Ext.isWebKit) {
                this.scroller.dom.style.position = 'static';
                this.lockedScroller.dom.style.position = 'static';
            }
        } else {
            this.el.setSize(csize.width, csize.height);
            var hdHeight = this.getGridHeight(true);
            hdHeight -= this.mainHd.getHeight();
        }
        this.updateLockedWidth();
        if (this.forceFit) {
            if (this.lastViewWidth != vw) {
                this.fitColumns(false, false);
                this.lastViewWidth = vw;
            }
        } else {
            this.autoExpand();
            this.syncHeaderScroll();
        }
        this.onLayout(vw, hdHeight);
        this.fireEvent('viewupdated', this);
    },
    
    /**
     * Retorna a altura da grid desta view.
     * 
     * @param contentHeight (optional) true para obter a altura menos as bordas e padding 
     * @returns altura da grid deste view
     */
    getGridHeight : function(contentHeight) {
        /* Obtem altura da grid */
        var height = this.grid.height;

        /* Se for autoHeight ignora a altura definida, ou se no tiver altura definida, pede pelo mtodo para calcular. */
        if (this.grid.autoHeight || !height) {
            height = this.grid.getHeight();
        }

        if (contentHeight) {
            /* Desconsidera bordas/padding do body grid */
            height -= this.grid.body.getBorderWidth('tb') - this.grid.body.getPadding('tb');
            /* Desconsidera bordas/padding dos filhos do body */
            var child = this.grid.body.first();
            while (child) {
                height -= child.getBorderWidth('tb') - child.getPadding('tb');
                child = this.grid.body.next();
            }
        }
        return height;
    },
    
    /**
     * Retorna a largura da grid desconsiderando a largura das colunas fixas e considerando a scroll.
     */
    getOffsetWidth : function() {
        if(!this.hasFixedColumns()){
            return Ext.ux.senior.grid.FixedColumnView.superclass.getOffsetWidth.call(this);
        }
        return (this.cm.getTotalWidth() - this.cm.getTotalLockedWidth() + this.getScrollOffset()) + 'px';
    },
    
    /**
     * @override
     */
    renderHeaders : function() {
        if(!this.hasFixedColumns()){
            return Ext.ux.senior.grid.FixedColumnView.superclass.renderHeaders.call(this);
        }
        
        var cellBody = [],
            lockedCellBody = [];
        
        for ( var i = 0; i < this.cm.getColumnCount(); i++) {
            if (this.cm.isLocked(i)) {
                lockedCellBody[lockedCellBody.length] = this.createColumnHeader(i);
            } else {
                cellBody[cellBody.length] = this.createColumnHeader(i);
            }
        }
        return [ this.templates.header.apply( {cells : cellBody.join(''),tstyle : 'width:' + this.getTotalWidth() + ';'} ), 
                 this.templates.header.apply( {cells : lockedCellBody.join(''),tstyle : 'width:' + this.getLockedWidth() + ';'} ) ];
    },
    
    /**
     * @override
     */
    getColumnCss : function(columnId){
        var css = Ext.ux.senior.grid.FixedColumnView.superclass.renderHeaders.call(this);
        return css + (this.cm.config[i].headerCls ? ' ' + this.cm.config[i].headerCls : '');
    },
    
    /**
     * Atualiza o cabealho da grid.
     */
    updateHeaders : function() {
        if(!this.hasFixedColumns()){
            this.lockedInnerHd.firstChild.innerHTML = "&#160;";
            Ext.ux.senior.grid.FixedColumnView.superclass.updateHeaders.call(this);
            return;
        }
        
        var hd = this.renderHeaders();
        this.innerHd.firstChild.innerHTML = hd[0];
        this.innerHd.firstChild.style.width = this.getOffsetWidth();
        this.innerHd.firstChild.firstChild.style.width = this.getTotalWidth();

        this.lockedInnerHd.firstChild.innerHTML = hd[1];
        var lw = this.getLockedWidth();
        this.lockedInnerHd.firstChild.style.width = lw;
        this.lockedInnerHd.firstChild.firstChild.style.width = lw;
        
        if(this.renderSortIcons){
            this.renderSortIcons();
        }
    },

    getResolvedXY : function(resolved) {
        if(!this.hasFixedColumns()){
            return Ext.ux.senior.grid.FixedColumnView.superclass.getResolvedXY.call(this, resolved);
        }
        
        if (!resolved) {
            return null;
        }
        var c = resolved.cell, r = resolved.row;
        return c ? Ext.fly(c).getXY() : [ this.scroller.getX(), Ext.fly(r).getY() ];
    },

    syncFocusEl : function(row, col, hscroll) {
        this.sclass.syncFocusEl.call(this, row, col, col < this.cm.getLockedCount() ? false : hscroll);
    },

    ensureVisible : function(row, col, hscroll) {
        return this.sclass.ensureVisible.call(this, row, col, col < this.cm.getLockedCount() ? false : hscroll);
    },

    insertRows : function(dm, firstRow, lastRow, isUpdate) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.insertRows.call(this, dm, firstRow, lastRow, isUpdate);
            return;
        }
        
        var last = dm.getCount() - 1;
        if (!isUpdate && firstRow === 0 && lastRow >= last) {
            this.refresh();
        } else {
            if (!isUpdate) {
                this.fireEvent('beforerowsinserted', this, firstRow, lastRow);
            }
            var html = this.renderRows(firstRow, lastRow), before = this.getRow(firstRow);
            if (before) {
                if (firstRow === 0) {
                    this.removeRowClass(0, this.firstRowCls);
                }
                Ext.DomHelper.insertHtml('beforeBegin', before, html[0]);
                before = this.getLockedRow(firstRow);
                Ext.DomHelper.insertHtml('beforeBegin', before, html[1]);
            } else {
                this.removeRowClass(last - 1, this.lastRowCls);
                Ext.DomHelper.insertHtml('beforeEnd', this.mainBody.dom, html[0]);
                Ext.DomHelper.insertHtml('beforeEnd', this.lockedBody.dom, html[1]);
            }
            if (!isUpdate) {
                this.fireEvent('rowsinserted', this, firstRow, lastRow);
                this.processRows(firstRow);
            } else if (firstRow === 0 || firstRow >= last) {
                this.addRowClass(firstRow, firstRow === 0 ? this.firstRowCls : this.lastRowCls);
            }
        }
        this.syncFocusEl(firstRow);
    },

    /**
     * Recupera o estilo da coluna
     * 
     * @param col
     *            coluna
     * @param isHeader
     *            se  cabealho
     * @returns estilo da coluna
     */
    getColumnStyle : function(col, isHeader) {
        
        var style = !isHeader ? this.cm.config[col].cellStyle || this.cm.config[col].css || '' : this.cm.config[col].headerStyle || '';
        style += 'width:' + this.getColumnWidth(col) + ';';
        if (this.cm.isHidden(col)) {
            style += 'display:none;';
        }
        var align = !isHeader ? this.cm.config[col].align : "left";
        if (align) {
            style += 'text-align:' + align + ';';
        }
        return style;
    },

    /**
     * Retorna a soma da largura das colunas fixas.
     */
    getLockedWidth : function() {
        return this.cm.getTotalLockedWidth()+'px';
    },

    /**
     * Retorna a largura da grid desconsiderando a largura das colunas fixas.
     */
    getTotalWidth : function() {
        if(!this.hasFixedColumns()){
            return Ext.ux.senior.grid.FixedColumnView.superclass.getTotalWidth.call(this);
        }
        
        return (this.cm.getTotalWidth() - this.cm.getTotalLockedWidth()) + 'px';
    },

    /**
     * Retorna os dados de todas as colunas.
     */
    getColumnData : function() {
        if(!this.hasFixedColumns()){
            return  Ext.ux.senior.grid.FixedColumnView.superclass.getColumnData.call(this);
        }
        
        var cs = [], cm = this.cm, colCount = cm.getColumnCount();
        for ( var i = 0; i < colCount; i++) {
            var name = cm.getDataIndex(i);
            cs[i] = {
                name : (!Ext.isDefined(name) ? this.ds.fields.get(i).name : name),
                renderer : cm.getRenderer(i),
                id : cm.getColumnId(i),
                style : this.getColumnStyle(i),
                locked : cm.isLocked(i),
                scope : cm.getRendererScope(i)
            };
        }
        return cs;
    },
    
    

    /**
     * Renderiza o corpo da grid. Retorna um array com 2 posies, onde a primeira representa os dados da coluna fixa, e a segunda os outros dados.
     * 
     * @override
     */
    renderBody : function() {
        if(!this.hasFixedColumns()){
            return Ext.ux.senior.grid.FixedColumnView.superclass.renderBody.call(this);
        }
        
        var markup = this.renderRows() || [ '&#160;', '&#160;' ];
        return [ this.templates.body.apply( {
            rows : markup[0]
        }), this.templates.body.apply( {
            rows : markup[1]
        }) ];
    },
    
    /**
     * Atualiza um registro.
     */
    refreshRow : function(record) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.refreshRow.call(this, record);
            return;
        }                
        var store = this.ds, 
        colCount = this.cm.getColumnCount(), 
        columns = this.getColumnData(), 
        last = colCount - 1, 
        cls = ['x-grid3-row'], 
        rowParams = {
            tstyle: String.format("width: {0};", this.getTotalWidth())
        }, 
        lockedRowParams = {
            tstyle: String.format("width: {0};", this.getLockedWidth())
        }, 
        colBuffer = [], 
        lockedColBuffer = [], 
        cellTpl = this.templates.cell, 
        rowIndex, 
        row, 
        lockedRow, 
        column, 
        meta, 
        css, 
        i;
    
        if (Ext.isNumber(record)) {
            rowIndex = record;
            record = store.getAt(rowIndex);
        } else {
            rowIndex = store.indexOf(record);
        }
        
        if (!record || rowIndex < 0) {
            return;
        }
        
        for (i = 0; i < colCount; i++) {
            column = columns[i];
            
            if (i == 0) {
                css = 'x-grid3-cell-first';
            } else {
                css = (i == last) ? 'x-grid3-cell-last ' : '';
            }
            
            meta = {
                id: column.id,
                style: column.style,
                css: css,
                attr: "",
                cellAttr: ""
            };
            
            meta.value = column.renderer.call(column.scope, record.data[column.name], meta, record, rowIndex, i, store);
            
            if (Ext.isEmpty(meta.value)) {
                meta.value = ' ';
            }
            
            if (this.markDirty && record.dirty && typeof record.modified[column.name] != 'undefined') {
                meta.css += ' x-grid3-dirty-cell';
            }
            
            if (column.locked) {
                lockedColBuffer[i] = cellTpl.apply(meta);
            } else {
                colBuffer[i] = cellTpl.apply(meta);
            }
        }
        
        row = this.getRow(rowIndex);
        row.className = '';
        lockedRow = this.getLockedRow(rowIndex);
        lockedRow.className = '';
        
        if (this.grid.stripeRows && ((rowIndex + 1) % 2 === 0)) {
            cls.push('x-grid3-row-alt');
        }
        
        if (this.getRowClass) {
            rowParams.cols = colCount;
            cls.push(this.getRowClass(record, rowIndex, rowParams, store));
        }
        
        // Unlocked rows
        this.fly(row).addClass(cls).setStyle(rowParams.tstyle);
        rowParams.cells = colBuffer.join("");
        row.innerHTML = this.templates.rowInner.apply(rowParams);
        
        // Locked rows
        this.fly(lockedRow).addClass(cls).setStyle(lockedRowParams.tstyle);
        lockedRowParams.cells = lockedColBuffer.join("");
        lockedRow.innerHTML = this.templates.rowInner.apply(lockedRowParams);
        lockedRow.rowIndex = rowIndex;
        this.syncHeaderHeight();  
        this.fireEvent('rowupdated', this, rowIndex, record);
             
    },
    
    /**
     * Redesenha a grid toda.
     * 
     * @param headersToo
     *            true para atualizar os headers tambm.
     */
    refresh : function(headersToo) {
        if(!this.hasFixedColumns()){
            Ext.ux.senior.grid.FixedColumnView.superclass.refresh.call(this, headersToo);
            this.lockedBody.update('&#160;').setWidth(this.getLockedWidth());
            return;
        }
        
        this.fireEvent('beforerefresh', this);
        this.grid.stopEditing(true);
        var result = this.renderBody();
        this.mainBody.update(result[0]).setWidth(this.getTotalWidth());
        this.lockedBody.update(result[1]).setWidth(this.getLockedWidth());
        if (headersToo === true) {
            this.updateHeaders();
            this.updateHeaderSortState();
        }
        this.processRows(0, true);
        this.layout();
        this.applyEmptyText();
        this.fireEvent('refresh', this);
    },

    initData : function(ds, cm) {
        this.sclass.initData.call(this, ds, cm);
        if (this.cm) {
            this.cm.on('columnChangePosition', this.onColumnChangePosition, this);
            this.grid.on('viewready', this.addRemoveFixedColumnSeparator, this);
        }
    },
    
    addRemoveFixedColumnSeparator : function(){
        if(this.cm && this.cm.getLockedCount() > 0){
            this.lockedWrap.addClass('ux-grid3-fixedcolumn-separator');
        }else{
            this.lockedWrap.removeClass('ux-grid3-fixedcolumn-separator');
        }
        
        this.refreshScroll();
    },
    
    onColumnChangePosition : function(dataIndex, newIndex) {
        this.grid.fireEvent("columnChangePosition", dataIndex, newIndex);
    },
    
    /**
     * Processa os eventos de fixar/desafixar e delega o resto  superclass.
     * 
     * @override
     */
    handleHdMenuClick : function(item) {
        var index = this.hdCtxIndex, cm = this.cm, id = item.getItemId(), llen = cm.getLockedCount();
        var dataIndex =  this.cm.getDataIndex(index);
        
        switch (id) {
            case 'lock':
                this.grid.fireEvent("columnFixed", dataIndex, true);
                break;
            case 'unlock':
                this.grid.fireEvent("columnFixed", dataIndex, false);
                break;
                
            default:
                return this.sclass.handleHdMenuClick.call(this, item);
        }
        
        return true;
    },

    handleHdDown : function(e, t) {        
        this.sclass.handleHdDown.call(this, e, t);
        
        if (this.grid.enableColLock !== false) {
            if (Ext.fly(t).hasClass('x-grid3-hd-btn')) {
                var hd = this.findHeaderCell(t), index = this.getCellIndex(hd), ms = this.hmenu.items, cm = this.cm;
                ms.get('lock').setDisabled(cm.isLocked(index));
                ms.get('unlock').setDisabled(!cm.isLocked(index));
            }
        }
    },

    /**
     * Sincroniza a altura dos headers das colunas fixas com as colunas no fixas.
     */
    syncHeaderHeight : function() {
        if(!this.hasFixedColumns()){
            return;
        }
        
        this.innerHd.firstChild.firstChild.style.height = 'auto';
        this.lockedInnerHd.firstChild.firstChild.style.height = 'auto';
    },

    /**
     * Atualiza a largura das colunas fixas.
     */
    updateLockedWidth : function() {
        var lw = this.cm.getTotalLockedWidth(), tw = this.cm.getTotalWidth() - lw, csize = this.grid.getGridEl().getSize(true);
        var lp = Ext.isBorderBox ? 0 : this.lockedBorderWidth, rp = Ext.isBorderBox ? 0 : this.rowBorderWidth;
        var vw = Math.max(csize.width - lw - lp - rp, 0) + 'px', so = this.getScrollOffset();

        if (!this.grid.autoHeight) {
            var vlh = Math.max(this.getGridHeight(true) - this.mainHd.getHeight(), 0) + 'px';
            var vh = Math.max(csize.height - this.mainHd.getHeight() - this.grid.getGridEl().getBorderWidth('tb'), 0) + 'px';
            this.lockedScroller.dom.style.height = vlh;
            this.scroller.dom.style.height = vh;
        }
     
        this.lockedWrap.dom.style.width = (lw + rp) + 'px';  
        this.scroller.dom.style.width = vw; 
        this.mainWrap.dom.style.left = (lw + lp + rp) +  'px';
        
      	if (this.lockedInnerHd) { 
            this.lockedInnerHd.firstChild.style.width = lw + 'px'; 
        }
        
        if (this.innerHd) { 
            this.innerHd.style.width = vw; 
            this.innerHd.firstChild.style.width = (tw + rp + so) + 'px';
            this.innerHd.firstChild.firstChild.style.width = tw + 'px';
        }

        if (this.mainBody) {
            this.lockedBody.dom.style.width = (lw + rp) + 'px';
            this.mainBody.dom.style.width = (tw + rp) + 'px';
        }
    },
    
    /**
     * Esconde ou mostra o div que  responsvel por ocupar a rea do tamanho da scroll na grid no fixa.
     */
    adjustScrollerHeight : function(height){
        this.sclass.adjustScrollerHeight.call(this, height);
        this.lockedScrollArea.setVisible(this.isHorizontalScrollVisible());
    }
});

/*
 * Classe PRIVADA responsvel por colocar os cones de DD ao arrastar as colunas de uma grid. A classe Ext.grid.HeaderDropZone  privada e encontra-se
 * dentro do src/widgets/grid/ColumnDD.js.
 */
Ext.ux.senior.grid.FixedColumnView.HeaderDropZone = Ext.extend(Ext.grid.HeaderDropZone, {
   
    constructor : function(grid, hd, hd2){
        Ext.ux.senior.grid.FixedColumnView.HeaderDropZone.superclass.constructor.call(this, grid, hd, hd2);
    },
    
    onNodeOver : function(n, dd, e, data){
        /*
         * se for uma coluna especial (status, delete ou seleo) deve mostrar o icone de no permitido fazer DD. obs: este mtodo apenas trata o
         * cone, para bloquear a movimentao das colunas  no FixedColumnModel.moveColumn
         */
        var SPECIAL_TYPES = ['statuscolumn', 'deletecolumn', 'checker'];
        for(var i = 0; i < SPECIAL_TYPES.length; i++){
            if(dd.dragData.header.className.search(SPECIAL_TYPES[i]) > -1){
                return this.dropNotAllowed;
            }
        }
            
        return Ext.ux.senior.grid.FixedColumnView.HeaderDropZone.superclass.onNodeOver.call(this, n, dd, e, data);
    }

});