/**
 * Model responsvel por manipular colunas fixas. <br>
 * Garante que as configuraes de colunas sempre estaro organizadas, com as colunas fixas sempre antes das outras. <br>
 * Tambm prov funes para fixar e desafixar colunas.
 * 
 * @author Patrick.Nascimento
 */
Ext.ux.senior.grid.FixedColumnModel = Ext.extend(Ext.ux.senior.grid.ColumnModel, {

    /**
     * Retorna se determinada coluna est fixa.
     * 
     * @param {Number}
     *            colIndex o ndice da coluna.
     * @return {Boolean} true caso a coluna esteja fixa.
     * 
     * @public
     */
    isLocked : function(colIndex) {
        return this.config[colIndex].fixedColumn === true;
    },

    /**
     * Fixa ou desafixa uma coluna.
     * 
     * @param {Number}
     *            colIndex o ndice da coluna.
     * @param {Boolean}
     *            value true para fixar, false para desafixar.
     * @public
     */
    setLocked : function(colIndex, value) {
        if (this.isLocked(colIndex) == value) {
            return;
        }
        this.config[colIndex].fixedColumn = value;
    },

    /**
     * Retorna quantas colunas fixas a grid est mostrando
     * 
     * @return {Number} a quantidade de colunas fixas.
     * 
     * @public
     */
    getLockedCount : function() {
        var len = 0;

        for ( var i = 0; i < this.config.length; i++) {
            if (this.isLocked(i)) {
                len++;
            }
        }
        return len;
    },

    /**
     * Fixa ou desafixa as colunas especiais da grid.
     * 
     * @param {Boolean}
     *          fixed true para fixar todas.
     *          
     * @public
     */
    setSpecialColumnsFixed : function(isFixed) {
        for ( var i = 0; i < this.specialColumns.length; i++) {
            var index = this.getIndexById(this.specialColumns[i]);
            if (index > -1) {
                this.config[index].fixedColumn = isFixed;
            }
        }
    }
});
