/**
 * Model responsvel por manipular colunas da grid. Todos os "models" criados
 * para a grid devem utilizar esse model como base.
 * 
 * @author Ramon Fernando Weiss.
 */
Ext.ux.senior.grid.ColumnModel = Ext.extend(Ext.grid.ColumnModel, {

	/**
	 * Representa o id das colunas que devem ter um tratamento diferente na
	 * grid.
	 */
	specialColumns : [ "deletecolumn", "statuscolumn", "checker" ],
	
	/**
	 * Armazena o estado do checkbox do header da coluna. 
	 */
	headerCheckBoxChecked : false,

	constructor : function(config) {
		Ext.ux.senior.grid.ColumnModel.superclass.constructor.apply(this,
				arguments);
	},

	/**
	 * Captura o config do model e modifica o sortable, fazendo com que o menu
	 * da coluna da grid seja atualizado aps sua abertura.
	 * 
	 * @param {Number}
	 *            index - Indice da coluna da grid.
	 * @param {Boolean}
	 *            value - Descreve o estado da propriedade "sortable" da coluna.
	 * 
	 * @public
	 */
	setSortable : function(index, value) {
		this.config[index].sortable = value;
	},

	/**
	 * Atribui o valor do checkBox do header da coluna.
	 * @param index o indice da coluna que vai receber o check
	 * @param value true para checado e false para no checado
	 */
	setHeaderCheckBoxChecked : function(index, value){
        var id = this.getColumnId(index);
        var check = Ext.get(id+"_checkbox");
        check.dom.checked = value;
        this.config[index].headerChecked = value;
        this.fireEvent('headerChange', this, index, this.header);
	},

	/**
	 * Retorna o valor do estado checkbox do header da coluna;
	 * @returns
	 */
	getHeaderCheckBoxChecked : function(index){
        return  this.config[index].headerChecked; 
	},
	
	  
    /**
     * Define se a coluna da grid vai ser  redimensionavel ou no;
     * @param field campo da grid que ser atribuido onovo valor
     * @param value true se pode ser  redimensionavel e false caso no pode 
     * @returns
     */
	setResizable : function(index, value) {
	    this.config[index].resizable = value;
	},

	/**
	 * Evento de movimentao das colunas.
	 * 
	 * @private
	 */
	onColumnMoved : function(columnModel, oldIndex, newIndex) {
		// a coluna status sempre ser a de ndice 0 (zero), o que pode
		// acontecer  ela estar invisivel
		this.config[0].refreshStatus();
	},

	/**
	 * Retorna a soma da largura das colunas fixas.
	 * 
	 * @return {Number} a largura total das colunas fixas.
	 * 
	 * @public
	 */
	getTotalLockedWidth : function() {
		var totalWidth = 0;
		for ( var i = 0, len = this.config.length; i < len; i++) {
			if (this.isLocked(i) && !this.isHidden(i)) {
				totalWidth += this.getColumnWidth(i);
			}
		}
		return totalWidth;
	},

	/**
	 * Move uma coluna de uma posio para outra
	 * 
	 * @param {Number}
	 *            oldIndex o ndice da coluna a ser movida.
	 * @param {Number}
	 *            newIndex o ndice de destino desta coluna.
	 * @public
	 */
	moveColumn : function(oldIndex, newIndex) {
		if (!(this.isSpecialColumn(this.config[oldIndex]) || this.isSpecialColumn(this.config[newIndex])) && oldIndex != newIndex) {
			// Quando manda ndice de linha tem que desconsiderar colunas
			// "escondidas", pois no server elas no so consideradas
			for ( var index = newIndex; index >= 0; index--) {
				var col = this.getColumnAt(index);
				if (col.hidden != null && col.hidden == true) {
					newIndex--;
				}
			}
			this.fireEvent("columnChangePosition", this.getColumnAt(oldIndex).name, newIndex);
		}

	},

	/**
	 * Retorna se esta coluna  coluna de Deletar, Status ou Checkbox.<br>
	 * <br>
	 * Quando no h colunas fixas, estas colunas especiais tambm no deve ser
	 * fixas, e vice-versa.<br>
	 * Isto  necessrio para estas colunas sempre ficarem na esquerda, sem
	 * perder sua ordem
	 * 
	 * @private
	 */
	isSpecialColumn : function(cg) {
		for ( var i = 0; i < this.specialColumns.length; i++) {
			if (cg.id == this.specialColumns[i]) {
				return true;
			}
		}
		return false;
	},

	/**
	 * Define se uma coluna da grid ir ficar visvel ou invisvel. Permite
	 * apenas setar visibilidade de uma coluna que j exista no column model,
	 * mesmo estando invisvel.
	 * 
	 * @param {Integer}
	 *            ndice da coluna do column model
	 * @param {Boolean}
	 *            true para esconder a coluna e false para exibir
	 * 
	 * @public
	 * @override
	 */
	setHidden : function(colIndex, hidden) {
		if (colIndex > -1 && colIndex < this.getColumnCount(false)) {// considera
			// colunas invisveis tambem
			Ext.ux.senior.grid.ColumnModel.superclass.setHidden.call(this,
					colIndex, hidden);
		}
	}

});
