SimpleList.prototype = {

    firstNode : null,

    currentNode : null,

    construtor : SimpleList,

    add : function(component, order) {
        var node = new FocusNode(component, order);
        var prev = null;
        var current = this.firstNode;

        /* percorre a lista at que o n a ser inserido seja maior ou igual ao atual. */
        while (current != null && current.getComponent().getFocusOrder() < order) {
            prev = current;
            current = current.getNext();
        }

        /* se o anterior for nulo significa que no h ns na lista ou que o n a ser inserido pode ir para o incio. */
        if (prev == null) {
            node.setNext(this.firstNode);
            this.firstNode = node;
        } else {
            node.setNext(prev.getNext());
            prev.setNext(node);
        }

        /* se o n onde o caminhamento parou no for nulo ele recebe uma referncia do n que est sendo adicionado. */
        if (current != null) {
            current.setPrev(node);
        }
        node.setPrev(prev);

    },

    getCurrentNode : function() {
        return this.currentNode;
    },

    setCurrentNode : function(node) {
        this.currentNode = node;
    },

    getNode : function(component) {
        var node = this.firstNode;
        if (node != null) {
            do {
                if (component === node.getComponent()) {
                    return node;
                }
                node = node.getNext();
            } while (node !== this.firstNode && node != null);
        }
        return null;
    },
    
    containsComponent : function(component){
        return this.getNode(component) != null;
    },

    getFirst : function() {
        return this.firstNode;
    },

    removeNode : function(node) {
        var next = node.getNext();
        var prev = node.getPrev();

        if (node === this.firstNode) {
            this.firstNode = next;
            if (next != null) {
                next.setPrev(prev);
            }
        } else {
            if (next != null) {
                next.setPrev(prev);
            }
            prev.setNext(next);
        }

        node.release();
    },

    release : function() {
        var node = this.firstNode, next;

        do {
            next = node.getNext();

            node.release();
            delete node;

            node = next;
        } while (node != null);
        /* TODO remover os keyNav dos componentes */
    },

    toString : function() {
        var string = "[";
        var node = this.firstNode;
        if (node == null) {
            return "[]";
        }
        do {
            var focusOrder = node.getComponent().getFocusOrder();
            string += (focusOrder + ",");
        } while ((node = node.getNext()) != this.firstNode && node != null);
        return this.id + " > " + string + "]";
    }

};

function SimpleList(id) {
    this.id = id;
};