/**
 * @author Patrick.Nascimento
 */
Ext.namespace('Ext.ux.senior.focuscontrol');

Ext.ux.senior.focuscontrol.FocusControlPlugin = Ext.extend(Object, {

    /**
     * Inicializao do plugin de foco.
     */
    init : function(component) {

        component.toString = function() {
            var format = "{0} - [{1}|{2}]   order:{3}   group:{4}";
            return String.format(format, component.id, component.xtype || component.type, component.name, component.focusOrder, component.focusGroup);
        };
        
        if (component.isXType("button") || component.isXType("seniorlink") || component.type == "button" || component.isXType("seniorradio")) {
            component.on("click", this.focus, this);

            /* boto no dispara evento de foco. */
            component.focus = component.focus.createSequence(function(selectText, delay) {
                FocusManager.onComponentFocus(component);
            });
        } else if (Ext.isSafari && component.isXType("seniorcheckbox")) {
            /* O Safari 5.1 no suporta evento de foco, quando  utilizado o mouse para focar, 
             * por isto o evento de foco  chamado no evento de check. 
             * Ateno: Caso comece a disparar dois eventos  bom analisar para ver se o Safari passou a chamar evento de foco
             */
            component.on("check", this.focus, this);

            /* boto no dispara evento de foco. */
            component.focus = component.focus.createSequence(function(selectText, delay) {
                FocusManager.onComponentFocus(component);
            });
        } else {
            component.on("focus", this.focus, this);
        }

        component.on("render", this.render, this);
        component.on("destroy", this.destroy, this);

        component.on("beforeHide", this.onFocusNextComponent, component);
        component.on("disable", this.onFocusNextComponent, component);

        /* retorna o grupo de foco deste componente */
        component.getFocusGroup = function() {
            return component.focusGroup;
        };

        /* retorna a ordem de foco deste componente */
        component.getFocusOrder = function() {
            return component.focusOrder;
        };

        /* seta o grupo de foco deste componente */
        component.setFocusGroup = function(group) {
            component.focusGroup = group;
            FocusManager.setPendingReorganization(true);
        };
        
        /* seta a ordem de foco deste componente */
        component.setFocusOrder = function(order) {
            component.focusOrder = order;
             FocusManager.setPendingReorganization(true);
            if(order > 0){
                FocusManager.registerComponent(component, component.getFocusGroup(), component.getFocusOrder());
            }
        };
        
        component.isPanelDeactivate = function() {
            return component.panelDeactivated;
        };

        component.setPanelDeactivate = function(deactivate) {
            component.panelDeactivated = deactivate;
        };

        /* para saber que o componente tem este plugin. */
        component.focableComponent = true;

        /* necessrio para saber se o componente est dentro de uma panel fechado. */
        component.setPanelDeactivate(false);
    },

    render : function(component) {
        /* caso no tenha focus order, no vai para o focusmanager. */
        if (component.getFocusOrder() && component.getFocusGroup() != null) {
            FocusManager.registerComponent(component, component.getFocusGroup(), component.getFocusOrder());
        }
        
    },

    focus : function(component) {
        /* ao receber foco manualmente, avisa o focusmanager. */
        FocusManager.onComponentFocus(component);
    },

    onFocusNextComponent : function(component) {
        /*Sempre que um componente que est com  o foco ficar desabilitado ou for escondido, o foco vai para o proximo componente.*/
        if (FocusManager.isFocusedComponent(component)) {
            FocusManager.focusNextComponent(component);
        }
    },

    destroy : function(component) {
        FocusManager.removeComponent(component);
    }

});

Ext.preg('componentfocusplugin', Ext.ux.senior.focuscontrol.FocusControlPlugin);