/**
 * @author Patrick.Nascimento
 */
Ext.namespace('Ext.ux.senior.focuscontrol');

Ext.ux.senior.focuscontrol.ContainerFocusPlugin = Ext.extend(Object, {

    /**
     * @param Ext.Container
     */
    init : function(container) {
        var xtype = container.getXType();

        /* Apenas injeta se no existir */
        Ext.applyIf(container, this.ownerOverrides);

        switch (xtype) {
        case "seniorgroupbox":
        case "seniorpanel":
            var layout = container.getLayout();

            if (layout === "senioraccordion") {
                this.initAccordion(container);
            } else {
                this.initPanel(container);
            }
            break;

        case "seniortabpanel":
            this.initTabPanel(container);
            break;
        }

        /* retorna o grupo de foco deste componente */
        container.getFocusGroup = function() {
            return container.focusGroup;
        };

        /* retorna a ordem de foco deste componente */
        container.getFocusOrder = function() {
            return container.focusOrder;
        };

        /* seta o grupo de foco deste componente */
        container.setFocusGroup = function(group) {
            container.focusGroup = group;
        };

        /* seta a ordem de foco deste componente */
        container.setFocusOrder = function(order) {
            container.focusOrder = order;
        };

    },

    initTabPanel : function(tabpanel) {
        tabpanel.on("render", function() {
            this.initFocusableChildren(false);
            tabpanel.items.each(function(item, index) {
                if (item.initFocusableChildren) {
                    item.initFocusableChildren(true);
                }
            });

            tabpanel.strip.on('mousedown', function() {
                FocusManager.onComponentFocus(this);
            }, tabpanel);

            this.on("beforetabchange", function(tabPanel, newSheet, oldSheet) {
                if (tabPanel.initFocusableChildren) {
                    tabPanel.initFocusableChildren(true);
                }
                if (oldSheet) {
                    oldSheet.initFocusableChildren(true);
                }
                if (newSheet) {
                    newSheet.initFocusableChildren(false);
                }
            }, this);
        }, tabpanel);

    },

    initPanel : function(panel) {
        if (panel.collapsible === true) {
            panel.updateFocusableChildren(undefined, panel.startCollapsed || panel.collapsed);
        }

        panel.on('afterrender', function(c) {
            c.initFocusableChildren(undefined, this.hidden || this.disabled, true);
            this.addPanelEvents(c);
        }, this);

    },

    initAccordion : function(accordion) {
        accordion.on("render", function(ct) {
            ct.initFocusableChildren(true);
            var items = ct.items;
            if (items) {
                items.each(function(item) {
                    item.initFocusableChildren(true);
                    this.addPanelEvents(item);
                }, this);
            }
        }, this);

    },

    addPanelEvents : function(panel) {
        panel.on("beforecollapse", function() {
            this.initFocusableChildren(true);
            FocusManager.collapsePanel(this);
        }, panel);

        panel.on("expand", function() {
            this.initFocusableChildren(false);
        }, panel);
        panel.on("add", function(container, component, number) {
            this.addFocusableChildren(component);
        }, panel);

        panel.on("remove", function(container, component) {
            this.addFocusableChildren(component);
        }, panel);

        panel.on("beforeShow", this.activatePanel, panel);
        panel.on("beforeHide", this.deactivatePanel, panel);

        panel.on("enable", this.activatePanel, panel);
        panel.on("disable", this.deactivatePanel, panel);
    },

    activatePanel : function(panel) {
        panel.initFocusableChildren(false);
    },

    deactivatePanel : function(panel) {
        panel.initFocusableChildren(true);
    },

    /**
     * @template
     */
    ownerOverrides : {

        allFocusableChildren : new Array(),

        addFocusableChildren : function(component, deactivate, onRender) {
            if (component.focableComponent) {
                this.allFocusableChildren.push(component);
                component.setPanelDeactivate(deactivate || this.disabled || (!!onRender && component.panelDeactivated));
            }
        },

        removeFocusableChildren : function(component) {
            if (component.focableComponent) {
                var index = this.allFocusableChildren.indexOf(component);
                this.allFocusableChildren.splice(index, 1);

            }
        },

        initFocusableChildren : function(deactivate, onRender) {
            var find = function(component, parent) {
                if (component.focableComponent) {
                    return true;
                }
                return false;
            };

            var children = this.findBy(find);
            this.allFocusableChildren = new Array();
            for ( var index = 0; index < children.length; index++) {
                this.addFocusableChildren(children[index], deactivate, onRender);
            }
        },

        updateFocusableChildren : function(deactivate, onRender) {
            if (this.allFocusableChildren > 0) {
                for ( var index = 0; index < this.allFocusableChildren.length; index++) {
                    this.addFocusableChildren[index].setPanelDeactivate(deactivate || this.disabled || (!!onRender && component.panelDeactivated));
                }
            }
        },

        updateVisibleChildren : function() {
            for ( var index = 0; index < this.allFocusableChildren.length; index++) {
                this.allFocusableChildren[index].setVisible(this.isVisible());
            }
        }
    }

});
Ext.preg('containerfocusplugin', Ext.ux.senior.focuscontrol.ContainerFocusPlugin);