CircleList.prototype = {

    firstNode : null,

    currentNode : null,

    count : 0,

    construtor : CircleList,

    add : function(component, order) {
    
        var node = new FocusNode(component, order);
        
        if (this.firstNode === null) {
            this.firstNode = node;
            node.setPrev(node);
            node.setNext(node);
        }

        var prev = this.getPrevByIndex(node, order);
        var next = prev.getNext();

        node.setNext(next);
        next.setPrev(node);

        node.setPrev(prev);
        prev.setNext(node);
        this.count++;
        if (node.getOrder() < this.firstNode.getOrder()) {
            this.firstNode = node;
        }
    },

       getPrevByIndex : function(curNode, order) {
        var node = this.firstNode;
        var prevNode = null;
        var position = null;

        var prevIndex = node.getOrder();
        position = 0;
        if (order == prevIndex) {
            while (order == prevIndex && position < this.count) {
                node = node.getNext();
                prevIndex = node.getOrder();
                position++;
            }
            prevNode = node.getPrev();
        } else if (order < prevIndex) {
            position = this.count - 1;
            prevNode = node.getPrev();
            prevIndex = prevNode.getOrder();
            while (order < prevIndex) {
                prevNode = prevNode.getPrev();
                prevIndex = prevNode.getOrder();
                position--;
                if (position < 0) {
                    break;
                }
            }
        } else {
            position = 0;
            while (order >= prevIndex) {
                node = node.getNext();
                prevIndex = node.getOrder();
                position++;
                if (position == this.count) {
                    break;
                }
            }
            prevNode = node.getPrev();
        }
        return prevNode;
    },
    
    containsComponent : function(component) {
        if (this.firstNode) {
            var node = this.firstNode;
            var last = false;
            while (!last) {
                if (node.getComponent() == component) {
                    return true;
                }
                node = node.getNext();
                last = node == this.firstNode;
            }
        }
        return false;

    },

    getCurrentNode : function() {
        return this.currentNode;
    },

    setCurrentNode : function(node) {
        this.currentNode = node;
    },

    getNode : function(component) {
        var node = this.firstNode;
        if (node != null) {
            do {
                if (component === node.getComponent()) {
                    return node;
                }
                node = node.getNext();
            } while (node !== this.firstNode);
        }
        return null;
    },

    getFirst : function() {
        return this.firstNode;
    },

    removeNode : function(node) {
        var next = node.getNext();
        var prev = node.getPrev();

        if (node === this.firstNode) {
            if (this.firstNode == next) {
                this.firstNode = null;
                prev = null;
                next = null;
                this.setCurrentNode(null);
            } else {
                this.firstNode = next;
                if (this.firstNode == prev) {
                    this.firstNode.setPrev(this.firstNode);
                    this.firstNode.setNext(this.firstNode);
                } else {
                    this.firstNode.setPrev(prev);
                    prev.setNext(this.firstNode);
                }
            }
        } else {
            next.setPrev(prev);
            prev.setNext(next);
        }

        node.release();
        this.count--;
    },

    release : function() {
    },

    toString : function() {
        var string = "[";
        var node = this.firstNode;
        if (node == null) {
            return "[]";
        }
        do {
            var focusOrder = node.getOrder();
            string += (focusOrder + ",");
        } while ((node = node.getNext()) != this.firstNode && node != null);
        return this.id + " > " + string + "]";
    },

    sortByOrder : function() {
        if(this.count == 0){
            return;
        }
        var currentNode = this.firstNode;
        var foundNode;
        var searchNode;

        do {
            foundNode = currentNode;
            searchNode = currentNode;
            while (searchNode.getNext() != this.firstNode) {
                searchNode = searchNode.getNext();
                if (searchNode.getOrder() < foundNode.getOrder()) {
                    foundNode = searchNode;
                }
            }
            if (currentNode != foundNode) {
                this.swapNodes(currentNode, foundNode);
                if (currentNode == this.firstNode) {
                    this.firstNode = foundNode;
                }
                currentNode = foundNode;
            }
            currentNode = currentNode.getNext();
            
           
        } while (currentNode != this.firstNode);
    },

    swapNodes : function(node1, node2) {
        var next1 = node1.getNext();
        var prev1 = node1.getPrev();
        var next2 = node2.getNext();
        var prev2 = node2.getPrev();

        if (next1 == node2) {
            node1.setPrev(node2);
            node2.setNext(node1);
        } else {
            node1.setPrev(prev2);
            node2.setNext(next1);
        }

        node1.setNext(next2);
        node1.getNext().setPrev(node1);
        node1.getPrev().setNext(node1);

        node2.getNext().setPrev(node2);
        node2.setPrev(prev1);
        node2.getPrev().setNext(node2);
    }

};

function CircleList(id) {
    this.id = id;
}
