/**
 * @class Ext.ux.form.ColorField
 * @extends Ext.form.TriggerField This class makes Ext.ux.ColorPicker available
 *          as a form field.
 * @author: Robert B. Williams (extjs id: vtswingkid)
 * @author: Tobias Uhlig (extjs id: tobiu)
 * @constructor Creates a new ColorField
 * @param {Object}
 *            config Configuration options
 * @version 1.1.2
 * license: BSD
 */

Ext.namespace("Ext.ux.menu", "Ext.ux.form");

Ext.ux.menu.ColorMenu = Ext.extend(Ext.menu.Menu, {

	enableScrolling : false,

	initComponent : function() {
		Ext.apply(this, {
			plain : true,
			showSeparator : false,
			items : this.picker = new Ext.ux.ColorPicker( {
				width : 350,
				id : this.id + "_cp"
			})
		});
		Ext.ux.menu.ColorMenu.superclass.initComponent.call(this);
		this.relayEvents(this.picker, [ 'select' ]);
		this.on('select', this.menuHide, this);
		if (this.handler) {
			this.on('select', this.handler, this.scope || this);
		}
	},
	
	menuHide : function() {
		this.hide(true);
	}
});

Ext.ux.form.ColorField = Ext.extend(Ext.form.TriggerField, {
	
	 eventMapping : function() {
    	return {
    		corselect : this.onColorSelect
    	};
	},
	
	onColorSelect: function() {
		return {
			type : 'changed',
			value : this.getValue()
		};
	},

	initComponent : function() {
		Ext.ux.form.ColorField.superclass.initComponent.call(this);
		this.menu = new Ext.ux.menu.ColorMenu( {
			id : this.id + '_menu',
			listeners : {
				select : function(m, c) {
					this.focus.defer(10, this);
				},
				hide : function() {
					this.fireEvent('corselect');	
				},
				scope : this
			},
			width : 350
		});
		this.menu.picker.on('colorchanged', function(color) {
			this.setValue(color);
		}, this);
	},
	setValue : function(v) {
		Ext.ux.form.ColorField.superclass.setValue.apply(this, arguments);
		if (/^#[0-9a-fA-F]{6}$/.test(v)) {
			var i = ColorUtils.rgbToHex(ColorUtils.invert(ColorUtils
					.hexToRgb(v)));
			this.el.applyStyles('background: ' + v + '; color:' + i + ';');
		} else {
			this.el.applyStyles('background: #ffffff; color: #000000;');
		}
	},

	onDestroy : function() {
		if (this.menu) {
			this.menu.destroy();
		}
		if (this.wrap) {
			this.wrap.remove();
		}
		Ext.ux.form.ColorField.superclass.onDestroy.call(this);
	},

	onTriggerClick : function() {
		if (!this.disabled) {
			this.menu.show(this.el, "tl-bl?");
			this.menu.picker.setColor(this.getValue());
		}
	}
});
Ext.reg("seniorcolorfield", Ext.ux.form.ColorField);