Ext.namespace('Ext.ux.senior.form');

Ext.override(Ext.form.TriggerField, {
    
    readOnlyClass : 'x-senior-item-readOnly',
    
    /**
     * Sobrescrito para adicionar classe CSS quando o field for readOnly
     * Tarefa: 404559.
     */
    updateEditState: function() {
        if(this.rendered){
            if (this.readOnly) {
                this.el.dom.readOnly = true;
                this.el.addClass('x-trigger-noedit');
                this.mun(this.el, 'click', this.onTriggerClick, this);
            } else {
                if (!this.editable) {
                    this.el.dom.readOnly = true;
                    this.el.addClass('x-trigger-noedit');
                    this.mon(this.el, 'click', this.onTriggerClick, this);
                } else {
                    this.el.dom.readOnly = false;
                    this.el.removeClass('x-trigger-noedit');
                    this.mun(this.el, 'click', this.onTriggerClick, this);
                }
            }
            this.trigger.setDisplayed(!this.hideTrigger);
            this.onResize(this.width || this.wrap.getWidth());
        }
        this.updateReadOnlyStyle();
    },

    updateReadOnlyStyle: function() {
      if(this.rendered){
          if (this.readOnly && !this.disabled) {
              this.el.addClass(this.readOnlyClass);
              if (this.trigger) {
                  this.trigger.addClass(this.disabledClass);
              }
          } else {
              this.el.removeClass(this.readOnlyClass);
              if (this.trigger) {
                  this.trigger.removeClass(this.disabledClass);
              }
          }
      }
    },
    
    /**
     * Adapta��o da fun��o do Ext para n�o ocultar o trigger quando o editbox est� read only.
     * Tarefa 417751
     * @override
     */
    getTriggerWidth: function(){
        var tw = this.trigger.getWidth();
        if (!this.hideTrigger && tw === 0) {
            tw = this.defaultTriggerWidth;
        }
        return tw;
    }
    
});

Ext.ux.senior.form.TriggerField = Ext.extend(Ext.form.TriggerField, {

    /*� um comportamento necess�rio, n�o remover */
    selectOnFocus : true,
    // n�o utilizamos valida��o do Ext, passando false otimiza por n�o gerar chamadas na classe base    
    validationEvent : false,
    
    isTriggerListening : true,

    initComponent : function() {
        Ext.ux.senior.form.TriggerField.superclass.initComponent.call(this, arguments);
        this.on('enable', this._onEnable, this);
        this.on('disable', this._onDisable, this);
    },

    /**
     * Ligado ao evento de redimensionamento
     * 
     * @param width a nova largura
     * @param height a nova altura
     */
    onResize : function(width, height) {
        Ext.ux.senior.form.TriggerField.superclass.onResize.call(this, width, height);

        this.wrap.setWidth(width);
        if (Ext.isNumber(width)) {
        	var triggerWidth = this.getTriggerWidth();
        	var lwidth = width - triggerWidth;
            this.el.setWidth(lwidth);
            this.trigger.setWidth(triggerWidth);
            if (this.customTrigger) {
                this.customTrigger.setWidth(triggerWidth);
            }
            // MNTTEC-505 inicio
            // quando usa-se menos de 100% de zoom, podemos ter padding e borda do input com tamanhos fracionários (tipo 0.9863876) que são desconsiderados pelo EXT
            // O código abaixo ajusta o tamanho input para não ficar o input e o trigger (botão) em linha diferentes. 
            var inputTop = this.el.getTop();
            var triggerTop = this.trigger.getTop();
            // A condição do While abaixo irá diminuir a largura do edit para fazer com que o botão e o edit caiba na largura da div (Deixando assim ambos alinhados). 
            // Porem estamos somando Esse "+ 3" na posição top do edit pois em alguns casos de zoom a posição do botão pode estar com até 3 pixels abaixo (Isso por algum motivo do Ext).
            // Essa soma de "+3" na condição serve como um range para validar que o edit esteja alinhado com o botão e evitar que o Edit tenha a sua largura reduzida a zero no while.
            while (triggerTop > inputTop + 3){
            	lwidth = lwidth - 1;
            	if (!lwidth){
            		break;
            	}
                this.el.setWidth(lwidth);
                triggerTop = this.trigger.getTop();
            }
            // MNTTEC-505 fim
        }
    },

    onKeyEvent : function(keyCode, evt) {
        // Atualiza o valor inicial do edit, para que com isso n�o seja enviado um "change"
        // para o server sem ter alterado o valor do edit.
        if (this.startValue != this.getValue()) {
            this.startValue = this.getValue();
            this.fireEvent('change');
        }

        return {
            type : "keypressed"
        };
    },

    _onEnable : function() {
        if (this.rendered) {
            this.updateTriggerIcon();
            this.trigger.dom.disabled = false;
            this.trigger.removeClass('x-item-disabled');
        }
    },

    _onDisable : function() {
        if (this.rendered) {
            this.updateTriggerIcon();
            this.trigger.dom.disabled = true;
            this.trigger.addClass('x-item-disabled');
            if (this.hasFocus) {
                Ext.form.TriggerField.superclass.onBlur.call(this);
            }
        }
    },

    onRender : function(ct, position) {
        Ext.ux.senior.form.TriggerField.superclass.onRender.call(this, ct, position);
        /* guarda a imagem "default"*/
        this.defaultTriggerImage = this.trigger.dom.src;
        this.updateTriggerIcon();
    },

    /**
     * Atualiza o �cone do bot�o de a��o do editbox, com base no seu estado (habilitado/delabilitado).
     *@private
     */
    updateTriggerIcon : function() {
        if (this.disabled) {
            if (this.disabledIcon) {
                this.buildCustomTrigger(this.disabledIcon);
            } else if(this.enabledIcon) {
                this.buildCustomTrigger(this.enabledIcon);
            }
        } else {
            if (this.enabledIcon) {
                this.buildCustomTrigger(this.enabledIcon);
            } else if (this.disabledIcon) {
                this.buildDefaultTrigger();
            }
        }
    },

    /**
     * Constr�i e aplica um div com a imagem do icone customizado no edit.
     * @param icon url do �cone.
     */
    buildCustomTrigger : function(icon) {
        if (!this.customTrigger) {
            var temp = new Ext.Template('<div class="x-form-trigger x-trigger-td-div" style="position:relative; width: {2}" id="{1}"></div>');
            temp.compile();
            var tempArgs = [ this.defaultTriggerWidth + 'px', Ext.id() ];

            this.customTrigger = temp.append(this.wrap, tempArgs, true);
            this.customTrigger.addClassOnOver('x-form-trigger-over');
            this.customTrigger.addClassOnClick('x-form-trigger-click');
            this.mon(this.customTrigger, 'click', this.onTriggerClick, this, {
                preventDefault : true
            });

            // configura a img corretamente
            this.image = this.trigger;
            this.image.removeClass('x-form-trigger');
            this.image.addClass('x-trigger-img');
            this.image.addClassOnClick('x-trigger-img-click');
            this.mun(this.image, 'click', this.onTriggerClick, this);

            this.customTrigger.appendChild(this.image);

            this.trigger = this.customTrigger;
        }
        //troca a imagem
        this.image.dom.src = icon;
    },

    /**
     * Altera o �cone para default.
     */
    buildDefaultTrigger : function() {
        if (this.image) {
            this.wrap.insertFirst(this.el);

            // remover o customTrigger e colocar o default novamente
            this.image.removeClass('x-trigger-img');
            this.image.removeClass('x-trigger-img-click');
            this.image.addClass('x-form-trigger');
            this.image.dom.src = this.defaultTriggerImage;
            this.image.setWidth(this.defaultTriggerWidth);
            this.mon(this.image, 'click', this.onTriggerClick, this, {
                preventDefault : true
            });

            this.image.replace(this.customTrigger);
            this.trigger = this.image;

            this.image = undefined;
            this.customTrigger = undefined;
        }
    },

    /**
     * @override
     */
    onTriggerClick : function() {
        if (this.disabled || this.readOnly) {
            return;
        }
        this.fireEvent('triggerClick');
    },

    /**
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            triggerClick : this.prepareClickEventData,
            change : this.prepareChangeEventData
        };
    },

    /**
     * @private
     */
    prepareChangeEventData : function() {
        var value = this.getValue();
        return {
            type : 'changed',
            value : value
        };
    },

    /**
     * @private
     */
    prepareClickEventData : function() {
        if (!this.disabled) {
            if (this.getValue() != this.startValue) {
                this.fireEvent('change');
            }
            return {
                type : 'clicked',
                value : this.triggerID
            };
        }
    },

    setValue : function(value) {
        Ext.ux.senior.form.TriggerField.superclass.setValue.call(this, value);
        this.startValue = value;
    },

    onFocus : function() {
        Ext.ux.senior.form.TriggerField.superclass.onFocus.call(this);

        // remove os 10ms da simula��o do blur deste componente ao click no documento
        if (this.mimicing) {
            this.doc.un('mousedown', this.mimicBlur, this);
            this.doc.on('mousedown', this.mimicBlur, this);
        }
    },

    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    }

});

Ext.reg('seniortrigger', Ext.ux.senior.form.TriggerField);
