/**
 * @author Rafael.Adriano
 */
Ext.ux.senior.form.TriggerBox = Ext.extend(Ext.form.ComboBox, {

    /**
     * Propriedades para Combobox
     */
    mode : 'local',
    displayField : "value",
    listEmptyText : 'Nenhum resultado encontrado',
    minChars : 1,
    lazyInit : false,
    resizable : true,
    autoSelect : false,
    multiSelect : false,
    selectOnFocus : true,
    validationEvent : false,
    DEFAUTL_FIELD_WIDTH : 126,
    currentCtx : null,
    handleHeight : 0,

    maxHeight : 20, // vai calcular 1/3 da tela. 
    minHeight : 20, // m�nimo para mostrar um registro

    showRefine : false,
    refineText : "Refine sua busca",

    searchType : "LOOKUP", // LOOKUP ou ARROW

    /**
     * Propriedades de controle
     */
    backupMatch : "",
    showingSearchForm : false,

    // utiliza as fun��es do TwinTriggerField para adicionar 2 triggers ao componente.
    getTrigger : Ext.form.TwinTriggerField.prototype.getTrigger,
    initTrigger : Ext.form.TwinTriggerField.prototype.initTrigger,

    /**
     * Teclas de atalho tratadas por este componente
     * 
     * @plugin EventManagerPlugin
     */
    keyMapping : [ Ext.EventObject.F3 ],

    // #############################################################
    // ### M�todos de inicializa��o e configura��o do componente ###
    // #############################################################

    /**
     * @override
     */
    initComponent : function() {
        Ext.ux.senior.form.TriggerBox.superclass.initComponent.call(this);

        this.initTriggersConfig();
        
        this.on({
            "afterrender" : this.onAfterRender,
            "blur" : this.notifyValueChanged,
            "keyup" : this.onKeyRelease,
            "beforeselect" : this.onBeforeSelect,
            "collapse" : this.onCollapse,
            "beforequery" : this.doQueryFilter,
            "disable" : this.onDisableEvent,
            "expand" : this.attachWindowResizeListener,
            "destroy" : this.dettachWindowResizeListener,
            scope : this
        });
    },
    
    /**
     * Alinha a lista de itens com o input.
     * 
     * @private
     */
    alignList : function(e) {
        if (this.isExpanded()) {
            this.list.alignTo(this.el, this.listAlign);
        }
    },
    
    /**
     * Registra um listener que alinha a lista de itens ao redimensionar o navegador.
     * 
     * @private
     */
    attachWindowResizeListener : function() {
        Ext.EventManager.onWindowResize(this.alignList, this);
    },
    
    /**
     * Remove o listener que alinha a lista de itens ao redimensionar o navegador.
     * 
     * @private
     */
    dettachWindowResizeListener : function() {
        Ext.EventManager.removeResizeListener(this.alignList, this);
    },
    
    /**
     * Atualiza e retorna o valor contexto de match corrent.
     * 
     * @private
     */
    newCtx : function() {
	
        this.currentCtx = Date.now();
        return this.currentCtx; 
    },    

    // configura��o dos dois triggers.
    initTriggersConfig : function() {
        this.triggerConfig = {
            tag : 'span',
            cls : 'x-form-twin-triggers',
            cn : [ {
                tag : "img",
                src : Ext.BLANK_IMAGE_URL,
                alt : "",
                cls : "x-form-trigger x-form-arrow-trigger"
            } ]
        };

        if (this.searchType === "LOOKUP") {
            this.triggerConfig.cn[1] = {
                tag : "img",
                src : Ext.BLANK_IMAGE_URL,
                alt : "",
                cls : "x-form-trigger x-form-search-trigger"
            };
        }
    },

    /**
     * @override
     */
    initEvents : function() {
        //combobox n�o aceita queryDelay 0, temos que fazer backup e restaurar pois o combo muda o valor se for 0.
        var tmp = this.queryDelay;
        Ext.ux.senior.form.TriggerBox.superclass.initEvents.call(this);
        this.queryDelay = tmp;
        this.keyNav.esc = false;
        this.keyNav.enter = false;

        new Ext.KeyNav(this.getEl(), {
            esc : this.onCancelEdit,
            enter : this.onEnterKey,
            pageDown : this.onPageDownKey,
            pageUp : this.onPageUpKey,
            scope : this
        });

        // Para que o backspace n�o volte a p�gina quando b2 esta como readonly
        this.selectedItemKeyMap = new Ext.KeyMap(this.getEl(), {
            key : [ Ext.EventObject.BACKSPACE ],
            fn : function() {
            },
            scope : this
        });

        this.selectedItemKeyMap.stopEvent = this.readOnly;

        /*
         * trecho copiado do ComboBox.js da vers�o 3.4 do Ext
         * Necess�rio devido a bug ao pressionar TAB em um b2 em edi��o na grid.
         */
        this.keyNav.doRelay = function(e, h, hname) {
            if (hname == 'down' || this.scope.isExpanded()) {
                // this MUST be called before ComboBox#fireKey()
                var relay = Ext.KeyNav.prototype.doRelay.apply(this, arguments);
                if (((Senior.isSupportedIE() && Ext.isStrict) || !Ext.isIE) && Ext.EventManager.useKeydown) {
                    // call Combo#fireKey() for browsers which use keydown event (except IE)
                    this.scope.fireKey(e);
                }
                return relay;
            }
            return true;
        };
    },

    // #################################
    // ### M�todos ligados a eventos ###
    // #################################
    
    /**
     * Ligado ao evento disable
     */
    onDisableEvent : function() {
        if (this.rendered && this.hasFocus) {
            Ext.form.TriggerField.superclass.onBlur.call(this);
        }
    },  
    
    /** clique na lupa, vai abrir a modal para pesquisa */
    onTrigger2Click : function() {
        /* Desconsidera o DOWN, que � padr�o de combobox, n�o h� requisitos para considerar o DOWN */
        if (Ext.EventObject.getKey() == Ext.EventObject.DOWN) {
            return;
        }

        if (this.disabled || this.readOnly) {
            return;
        }

        // somente leitura recebe foco
        FocusManager.focusComponent(this);

        if (!this.readOnly) {
            /* Se for estilo modal, sempre fecha se estiver expandido e abre o modal */
            if (this.isExpanded()) {
                this.collapse();
            }
            this.fireEvent('requestLookupModal');
        }
    },
    /** clique na flexa do combo, vai abrir a lista */
    onTrigger1Click : function() {
        /* Desconsidera o DOWN, que � padr�o de combobox, n�o h� requisitos para considerar o DOWN */
        if (Ext.EventObject.getKey() == Ext.EventObject.DOWN) {
            return;
        }

        if (this.disabled || this.readOnly) {
            return;
        }

        // somente leitura recebe foco
        FocusManager.focusComponent(this);

        if (!this.readOnly) {
            /* Se for estilo combo, fecha se estiver expandido e expande se estiver fechado */
            if (this.isExpanded()) {
                this.collapse();
            } else {
                /* simplesmente pesquisa por '' */
                this.doQueryFilter({
                    query : '',
                    forceAll : true
                });
            }
        }
    },

    /**
     * Ligado ao evento afterRender.
     */
    onAfterRender : function() {

        // Ajusta a largura de um componente trigger quando estiver em painel collapsado.
        // bug: http://www.sencha.com/forum/showthread.php?146819-Trigger-in-collapsed-panel
        // Verifica se o componente ou o elemento tem tamanho, se n�o tiver, adiciona o tamanho padr�o. 
        if (this.width == undefined || this.width == 0) {
            this.setWidth(this.DEFAUTL_FIELD_WIDTH);
            this.wrap.setWidth(this.DEFAUTL_FIELD_WIDTH);
        } else {
            var newWidth = 0;
            // Se o elemento existir, ent�o ajusta o tamanho baseado no elemento (somando o tamanho dos triggers)
            if (this.el.getWidth() > 0) {
                newWidth = this.el.getWidth() + this.getTriggerWidth();
            } else {
                newWidth = this.width; // se n�o, seta o tamanho definido
            }
            this.setWidth(newWidth);
        }

        // Para n�o deixar o ext remover o bot�o de trigger quando readonly
        if (this.readOnly) {
            this.el.removeClass('x-trigger-noedit');
            this.trigger.setDisplayed(true);
        }

        // Se estiver em um editor, se liga nos eventos dele para ajustar o comportamento do TriggerBox.
        if (this.inEditor) {
            var editor = Ext.getCmp(this.container.id);
            editor.on("startedit", this.onStartEdit, this);
            editor.on("canceledit", this.onCancelEdit, this);
        }

    },

    /**
     * Ligado ao evento de redimensionamento
     * 
     * @param width a nova largura
     * @param height a nova altura
     */
    onResize : function(width, height) {
        Ext.ux.senior.form.TriggerBox.superclass.onResize.call(this, width, height);

        var triggerWidth = this.getTriggerWidth();
        if (Ext.isNumber(width)) {
            this.el.setWidth(width - triggerWidth);
            this.trigger.setWidth(triggerWidth);
            if (this.customTrigger) {
                this.customTrigger.setWidth(triggerWidth);
            }
        }
        this.wrap.setWidth(width);
    },

    /**
     * Atualiza a altura m�xima da lista, calculando 1/3 da altura do browser.
     * @private
     */
    refreshListMaxHeight : function() {
        this.maxHeight = Math.max(this.minHeight, Math.round(Ext.getBody().getViewSize().height / 3));  
    },

    /**
     * Ligado ao evento blur.
     */
    notifyValueChanged : function() {
        this.dqTask.cancel();

        if (Ext.EventObject.getKey() === 9) {
            if (this.selectedIndex >= 0) {
                this.onViewClick();
                return;
            }
        }

        // se o valor mudou, notifica o servidor para aplicar
        if (this.getValue() != this.backupMatch) {
            if (this.getValue() == '') {
                this.fireEvent('requestRemoveMatch');
            } else {
                this.fireEvent('requestApplyMatchFilter');
            }
            this.setMatch(this.getValue());
        }
    },

    /**
     * Ligado ao evento keyup.
     */
    onKeyRelease : function(cmp, event) {
        if (this.editable !== false && this.readOnly !== true) {
            var keyCode = event.getKey();

            if (keyCode == event.DELETE || keyCode == event.BACKSPACE || keyCode == event.SPACE || !this.isSpecialKey(event)) {
                this.lastKey = keyCode;
                // Invoca doQuery depois do delay
                this.dqTask.delay(this.queryDelay);
            }
        }
    },

    /**
     * Ligado ao evento beforeselect.
     */
    onBeforeSelect : function(combo, record, index) {
        // Envia para o servidor o item selecionado
        this.fireEvent('requestApplyMatchSelect', index);
        this.collapse();
        this.fireEvent('select', this, record, index);
        return false;
    },

    /**
     * Ligado ao evento de pressionar ENTER.
     *  
     * Caso um item da lista estiver selecionado, aplica este item. 
     * Caso n�o h� item selecionado, aplica o valor que esta digitado.
     */
    onEnterKey : function(e) {
        if (this.selectedIndex >= 0) {
            this.onViewClick();
        } else {
            this.notifyValueChanged();
            Ext.ux.senior.form.TriggerBox.superclass.fireKey.call(this, Ext.EventObject);
            this.collapse();
        }
    },

    /**
     * Ligado aos eventos de pressionar ESC e canceledit da grid.
     */
    onCancelEdit : function(e) {
        this.currentCtx = null;
        if (this.isExpanded()) {
            this.collapse();
        } else {
            this.setMatch(this.backupMatch);
            Ext.ux.senior.form.TriggerBox.superclass.fireKey.call(this, Ext.EventObject);
        }
    },

    /**
     * Obtem a quantidade de itens que aparece no viewport da lista do comboBox
     */
    getVisibleRows : function() {
            var listHeight = this.view.getHeight();
            return Math.round(listHeight / this.view.getNode(0).offsetHeight);
    },

    /**
     * Ligando evento de pageDown
     * 
     */
    onPageDownKey : function(e) {
        if (this.isExpanded()) {
            e.stopEvent();

            var firstItem = Math.round(this.innerList.dom.scrollTop / this.view.getNode(0).offsetHeight);
            var visibleItems = this.getVisibleRows();
            var lastItem = this.view.getNodes(0).length - 1;
            
           if (this.selectedIndex < lastItem) {
                //Para que o ultimo item anterior seja o primeiro a aparecer
                var newSelectedIndex = firstItem + ((visibleItems - 1) * 2);
                if (newSelectedIndex >= lastItem) {
                    newSelectedIndex = lastItem;
                }
                this.innerList.scrollChildIntoView(this.view.getNode(newSelectedIndex));
                this.select(newSelectedIndex);
            }
        }
    },

    /**
     * Ligando evento de pageUp
     * 
     */
    onPageUpKey : function(e) {
        if (this.isExpanded()) {
            e.stopEvent();

            var firstItem = Math.round(this.innerList.dom.scrollTop / this.view.getNode(0).offsetHeight);
            var visibleItems = this.getVisibleRows();
            
            if (this.selectedIndex > 0) {
                //Para que o ultimo item anterior seja o primeiro a aparecer
                var newSelectedIndex = firstItem - (visibleItems - 1);
                if (newSelectedIndex <= 0) {
                    newSelectedIndex = 0;
                }
                this.innerList.scrollChildIntoView(this.view.getNode(newSelectedIndex));
                this.select(newSelectedIndex);
            }
        }
    },

    /**
     * Ligado ao evento de startedit da grid.
     */
    onStartEdit : function(boundEl, value) {
        this.currentCtx = null;
        if (value == '') {
            //Se o valor vier vazio, consulta o server para saber se � um registro novo ou se o registro realmente est� vazio
            this.fireEvent('requestGetMatch');
        } else {
            this.setMatch(value);
        }
    },

    /**
     * Ligado ao evento de pressionar a tecla F3.
     * 
     * @plugin EventManagerPlugin
     */
    onKeyEvent : function(key, evt) {
        if (this.searchType === "LOOKUP") {
            this.onTrigger2Click();
        } else {
            this.onTrigger1Click();
        }
    },

    /**
     * Ligado ao evento collapse.
     * 
     * Remove o �ndice do item que estava selecionado quando a caixa de itens for fechada, dessa forma quando 
     * esta for aberta novamente, o item n�o estar� selecionado.
     */
    onCollapse : function() {
        this.selectedIndex = -1;
        this.dettachWindowResizeListener();
    },

    /**
     * Ligado ao evento de beforeQuery.
     * 
     * Este doQueryFilter para filtrar o conte�do da pesquisa do B2
     */
    doQueryFilter : function(info) {
        if (/*this.actionType == 'LOOKUP' && */(this.queryDelay == 0 || this.showingSearchForm)) {
            return false;
        }

        if ((info.forceAll == undefined || !info.forceAll) && info.query.length < this.minChars) {
            this.collapse();
            return false;
        }

        // Se a lista sem filtro n�o esta carregada, faz a sua carga, sen�o somente expande
        this.queryData(info.query);
        this.expand.defer(1, this); // O defer � feito para que o foco no componente seja processado antes do expand().

        return false;
    },

    // ##############################################
    // ### M�todo sobreescritos do componente pai ###
    // ##############################################

    /**
     * @override
     */
    setValue : function(value) {
        if (!this.showingSearchForm) {
            Ext.ux.senior.form.TriggerBox.superclass.setValue.call(this, value);
        }
    },

    /**
     * @override
     */
    onKeyUp : function(event) {
        this.fireEvent('keyup', this, event);
    },

    /**
     * Cria o store com os campos necess�rios e cria o template da grid da pesquisa r�pida.
     * @override
     */
    onRender : function(ct, position) {
        this.createJsonStore();
        this.createTemplate();
        Ext.ux.senior.form.TriggerBox.superclass.onRender.call(this, ct, position);
    },

    /**
     * Valida se determinado evento de click pode disparar o blur deste field.
     *
     * @override
     */
    validateBlur : function(evt) {
        if (this.list && this.list.isVisible()) {
            if (this.selectedIndex >= 0 && this.list.contains(evt.target)) {
                return false;
            }
        }

        return !this.showingSearchForm;
    },

    createTemplate : function() {
        this.tpl = new Ext.XTemplate('<tpl for=".">' + //
        '<div  class="{[xindex % 2 === 0 ? "x-combo-list-item" : "x-combo-list-item x-combo-list-item-striped"]}">{' //
                + this.displayField + '}</div>' + '</tpl>'); //
    },

    initList : function() {
        //this.createTemplate();
        Ext.ux.senior.form.TriggerBox.superclass.initList.call(this);

        this.footer = this.list.createChild({
            cls : 'x-combo-list-ft x-senior-combo-list-ft'
        });
        this.footer.dom.innerHTML = '<div class="x-senior-combo-list-ft-inner" id=' + this.id + '-refine>' + this.refineText + '</div>';

        this.footer.setHeight("18px");
        this.footer.on('click', this.onTrigger2Click, this);

        this.footer.setVisible(this.showRefine);

        if (this.resizable) {
            this['innerList'].setStyle('margin-bottom', '0px');
            this[this.showRefine ? 'footer' : 'innerList'].setStyle('margin-bottom', this.handleHeight + 'px');
        }
    },

    expand : function() {
        if (this.showingSearchForm !== true) {
            this.refreshListMaxHeight();
            Ext.ux.senior.form.TriggerBox.superclass.expand.call(this);
            this.assetHeight = this.showRefine ? this.footer.getHeight() : 0;
        }
    },

    getTriggerWidth : function() {
        var tw = 0;
        Ext.each(this.triggers, function(t, index) {
            var triggerIndex = 'Trigger' + (index + 1), w = t.getWidth();
            if (w === 0 && !this['hidden' + triggerIndex]) {
                tw += this.defaultTriggerWidth;
            } else {
                tw += w;
            }
        }, this);
        return tw;
    },

    restrictHeight : function() {
        this.innerList.dom.style.height = '';
        var inner = this.innerList.dom, //
        pad = this.list.getFrameWidth('tb') + (this.resizable ? this.handleHeight : 0) + this.assetHeight, //
        h = Math.max(inner.clientHeight, inner.offsetHeight, inner.scrollHeight), //
        ha = this.getPosition()[1] - Ext.getBody().getScroll().top, //
        hb = Ext.lib.Dom.getViewHeight() - ha - this.getSize().height, //
        space = Math.max(ha, hb, this.minHeight || 0) - this.list.shadowOffset - pad - 5;

        h = Math.max(this.minHeight, Math.min(h, space, this.maxHeight));

        this.innerList.setHeight(h);
        this.list.beginUpdate();
        this.list.setHeight(h + pad);
        this.list.alignTo.apply(this.list, [ this.el ].concat(this.listAlign));
        this.list.endUpdate();
    },

    /**
     * @override
     */
    getStyleEl : function(scope) {
        var property = scope.split('$');

        if (property[0] == 'label') {
            return this.label;
        }

        return Ext.ux.senior.form.TriggerBox.superclass.getStyleEl.call(this, scope);
    },

    /**
     * @override
     */
    onFocus : function() {
        Ext.ux.senior.form.TriggerField.superclass.onFocus.call(this);

        //remove os 10ms da simula��o do blur deste componente ao click no documento
        if (this.mimicing) {
            this.doc.un('mousedown', this.mimicBlur, this);
            this.doc.on('mousedown', this.mimicBlur, this);
        }
    },

    /**
     * @plugin EventManagerPlugin.js
     */
    eventMapping : function() {
        return {
            requestOptions : this.requestOptions,
            requestApplyMatchSelect : this.requestApplyMatchSelect,
            requestRemoveMatch : this.requestRemoveMatch,
            requestApplyMatchFilter : this.requestApplyMatchFilter,
            requestLookupModal : this.requestLookupModal,
            requestGetMatch : this.requestGetMatch
        };
    },

    // #######################################
    // ### M�todos invocados pelo servidor ###
    // #######################################
    
    /**
     * @override
     */
    setReadOnly: function(readOnly){
        Ext.ux.senior.form.TriggerBox.superclass.setReadOnly.call(this, readOnly);
        if (this.selectedItemKeyMap) {
            this.selectedItemKeyMap.stopEvent = readOnly;
        }
    },

    setMatch : function(value, ctx) {
        this.backupMatch = value;
        if (this.inEditor) {
            if (ctx !== undefined && ctx != this.currentCtx) {
                return;
            }
        }

        if (this.getValue() != value) {
            this.setValue(value);
        }
    },

    loadOptions : function(data) {
        this.store.removeAll();
        this.store.loadData(data);
        this.expand();

        if (this.store.getCount() > 0) {
            this.select(0);
        }
    },

    /**
     * Sinaliza se a modal de pesquisa est� aberto ou n�o.
     */
    setShowingSearchForm : function(b) {
        this.showingSearchForm = b;
    },

    setShowRefine : function(isShowRefine) {
        if (this.showRefine != isShowRefine) {
            this.showRefine = isShowRefine;

            this.footer.setVisible(this.showRefine);
            this.assetHeight = this.showRefine ? this.footer.getHeight() : 0;
            this.restrictHeight();
        }
    },

    // ####################################
    // ### M�todos internos de controle ###
    // ####################################

    isSpecialKey : function(event) {
        var keyCode = event.normalizeKey(event.keyCode);
        return event.ctrlKey || event.isNavKeyPress() || //
        (keyCode >= 16 && keyCode <= 20) || // Shift, Ctrl, Alt, Pause, Caps Lock
        (keyCode >= 44 && keyCode <= 46); // Print Screen, Insert, Delete
    },

    /**
     * Verifica se o componente passado como par�metro est� inserido dentro de uma Window
     * 
     * @private
     * @param {Ext.Component}
     *            cmp componente que se deseja verificar
     * @return {Boolean} true caso esteja em uma Window, false caso contr�rio.
     */
    isWindowChild : function(cmp) {
        if (!cmp.ownerCt) {
            return false;
        }
        return cmp instanceof Ext.Window || this.isWindowChild(cmp.ownerCt);
    },

    /**
     * Faz requisi��o para o servidor de um pesquisa
     * 
     * @private
     */
    queryData : function(query) {
        query = Ext.isEmpty(query) ? '' : query;
        this.fireEvent('requestOptions', query);
    },

    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    /**
     * Cria o store do combobox, para preencher os dados do template quando for aberto
     * 
     * @private
     */
    createJsonStore : function() {
        this.store = new Ext.data.ArrayStore({
            fields : [ 'value' ]
        });
    },

    // ###############################################
    // ### M�todos que montam o json das requi��es ###
    // ###############################################
    /**
     * Evento para mostrar tela de pesquisa
     * 
     * @event requestLookupModal
     */
    requestLookupModal : function() {
        return {
            type : 'pluginEvent',
            pluginId : 'LOOKUP',
            pluginEventType : 'ACTION_PERFORMED',
            action_name : 'LOOKUP',
            context : this.newCtx()
        };
    },

    requestGetMatch : function() {
        return {
            type : 'pluginEvent',
            pluginId : 'LOOKUP',
            pluginEventType : 'GET_MATCH',
            context : this.newCtx()
        };
    },

    /**
     * Evento para carregar dados para uma nova pesquisa no store
     * 
     * @event requestOptions
     */
    requestOptions : function(query) {
        return {
            type : 'pluginEvent',
            pluginId : 'LOOKUP',
            pluginEventType : 'GET_OPTIONS',
            value : query,
            context : this.newCtx()	
        };
    },

    /**
     * Evento para selecionar uma op��o da pesquisa
     * 
     * @event requestApplyMatchSelect
     */
    requestApplyMatchSelect : function(key) {
        return {
            type : 'pluginEvent',
            pluginId : 'LOOKUP',
            pluginEventType : 'APPLY_MATCH',
            index : key,
            context : this.newCtx()
        };
    },

    /**
     * Evento para selecionar um registro de acordo com o selectedItem resultante do filtro
     * 
     * Pode ser que n�o h� selectedItem, ent�o o servidor ir� responder um wrong selectedItem para este item
     * 
     * @event requestApplyMatchFilter
     */
    requestApplyMatchFilter : function() {
        return {
            type : 'pluginEvent',
            pluginId : 'LOOKUP',
            pluginEventType : 'APPLY_MATCH',
            value : this.getValue(),
            context : this.newCtx()
        };
    },

    /**
     * Evento para remover um selectedItem no sevidor
     * 
     * @event requestRemoveMatch
     */
    requestRemoveMatch : function() {
        return {
            type : 'pluginEvent',
            pluginId : 'LOOKUP',
            pluginEventType : 'REMOVE_MATCH',
            context : this.newCtx()        
        };
    }

});

Ext.reg('seniortriggerbox', Ext.ux.senior.form.TriggerBox);