Ext.namespace('Ext.ux.senior.form');

Ext.ux.senior.form.Line = Ext.extend(Ext.BoxComponent, {
	
    horizontal : true,
    thickness : "5px",
    //template de linha horizontal
	horTmpl : new Ext.Template('<tr>' + 
										'<td>' +
											'<div id="{id}" style="width:100%; height:100%">{text}</div>' +
											'</td>' +
										'<td style="height: {thickness}; width:100%">' +											'<div class="img-horizontal-background" style="' +
											'background-position: center center; width: 100%; height :100%;"></div>' +
										'</td>' +
									'</tr>'),
	//template de linha vertical							
    verTmpl : new Ext.Template('<tr>' +
    								'<td style="width:100%">' +
										'<div id="{id}" style="width:100%; height:100%">{text}</div>' +
									'</td>'+
								'</tr>' + 
								'<tr>' +
									'<td style="width: {thickness}; height:100%;">' +
										'<div class="img-vertical-background" style="' +
										'background-position: center center; width: 100%; height :100%;"></div>' +
									'</td>' +
								'</tr>'),
	
	onRender : function() {
		Ext.ux.senior.form.Line.superclass.onRender.apply(this, arguments);
		this.autoEl = Ext.apply({}, this.initialConfig, this.autoEl);
		var tmpl = this.horizontal ? this.horTmpl : this.verTmpl; 
		tmpl.compile();
		var table = this.el.createChild({
			tag : 'table',
			style : {
				height : this.horizontal ? this.thickness : "100%",
				width : this.horizontal ? "100%" : this.thickness
			}
		});
		var textId = this.id + '-text';
		tmpl.append(table, {
			text : this.text,
			id : textId,
			thickness : this.thickness
		});
		this.textEl = Ext.get(textId);
		this.textEl.addClass('x-form-field');
	},
	
	getText : function() {
	    return this.text;
	},
	
	setText : function(text) {
	    this.text = text && text != 'null' ? text : ' ';
	    this.textEl.update(this.text);
	}

});

Ext.reg('seniorline', Ext.ux.senior.form.Line);