Ext.namespace('Ext.ux.senior.form');

/**
 * UC-FRC-0055 - Operar Label.xucs REQ0001 - ok REQ0002 - ok REQ0003 - ok
 * 
 * @author Jean.Kirchner/ Daniel.Pereira
 */
Ext.ux.senior.form.Label = Ext.extend(Ext.form.Label, {

    /**
     * @override
     */
    initComponent : function() {
        Ext.ux.senior.form.Label.superclass.initComponent.call(this, arguments);
    },

    /**
     * 
     * Sobrescrito pois agora o template do label  composto por um div que o encapsula.
     * 
     * @override
     */
    onRender : function() {

        if (!this.el) {
            this.el = document.createElement('div');
            this.label = this.el.appendChild(document.createElement('label'));
            this.el.appendChild(this.label);

            this.el.id = this.getId();
            this.label.innerHTML = this.text ? Ext.util.Format.htmlEncode(this.text) : (this.html || '');
            if (this.forId) {
                this.label.setAttribute('for', this.forId);
            }
        }

        Ext.ux.senior.form.Label.superclass.onRender.apply(this, arguments);
        this.el.addClass('x-senior-align-text');
    },

    /**
     * Updates the label's innerHTML with the specified string.
     * 
     * @param {String}
     *            text The new label text
     * @param {Boolean}
     *            encode (optional) False to skip HTML-encoding the text when rendering it to the label (defaults to true which encodes the value). This might be useful if you want to include tags in
     *            the label's innerHTML rather than rendering them as string literals per the default logic.
     * @return {Label} this
     * 
     * @override innerHTML tem que ser feito no label, e no no el.
     */
    setText : function(t, encode) {
        var e = encode === false;
        this[!e ? 'text' : 'html'] = t;
        delete this[e ? 'text' : 'html'];
        if (this.rendered) {
            this.label.innerHTML = encode !== false ? Ext.util.Format.htmlEncode(t) : t;
        }
        return this;
    },

    /**
     * Mtodo utilizado para setar o estilo na label, para que assim possamos 
     * obter a funcionalidade de quebra de linha.
     * 
     * @param isTextWrap "true" caso o componente deva quebrar de linha com o excesso de texto, seno "false".
     */
    setTextWrap : function(isTextWrap) {
        if (isTextWrap) {
            this.el.setStyle('white-space', 'normal');
        } else {
            this.el.setStyle('white-space', 'nowrap');
        }
    },

    /**
     * Sobrescrito pois o label apica o estilo nele mesmo e no seu field label (se houver).
     * @override 
     */
    getElementsForDynamicStyle : function(scope){
        var elements = [];
        if (this.fieldLabel) {
            var labelElement = Ext.get(this.container.dom.parentElement).child('label.x-form-item-label');
            if(!!labelElement){
                elements = elements.concat(labelElement);
            }
        }
        return elements.concat(this.getEl());
    },
    
    /**
     * Obtm o texto do label (no existe no ExtJS).
     * 
     * @returns texto do label
     */
    getText : function() {
        return this.text;
    },
    
    /**
     * Define o texto do label (sobrescrito para atribuir o valor no atributo text).
     */
    setText : function(text, encode) {
        Ext.ux.senior.form.Label.superclass.setText.call(this, text, encode);
        this.text = text;
    }
    
});

Ext.reg('seniorlabel', Ext.ux.senior.form.Label);
