Ext.namespace('Ext.ux.senior.form');

/**
 * @author Anderson Borba
 */
Ext.ux.senior.form.Frame = Ext.extend(Ext.BoxComponent, {

    /**
     * Ext config option.
     * 
     * @private
     */
    autoEl : {
        tag : 'iframe',
        frameBorder : 0
    },

    /**
     * @overide
     */
    initComponent : function() {
        Ext.ux.senior.form.Frame.superclass.initComponent.call(this, arguments);
        this.on('render', this.myOnRender, this);
    },

    /**
     * Funco chamada durante o render do componente para refletir as mudanas da url e da largura da borda.
     * 
     * @private
     */
    myOnRender : function() {
        this.addClass('x-senior-frame');

        if (this.url) {
            this.setUrl(this.url);
        }
        if (this.borderWidth) {
            this.setBorderWidth(this.borderWidth);
        }
    },

    /**
     * Define a url que o iframe ira exibir.
     * 
     * @public
     * @param {String}
     *            iframeurl url do iframe
     */
    setUrl : function(iframeurl) {
        this.getEl().set( {
            src : iframeurl
        });
    },

    /**
     * Define a largura da borda do iframe.
     * 
     * @public
     * @param {String}
     *            iframeborder largura da borda
     */
    setBorderWidth : function(iframeborder) {
        this.getEl().setStyle('borderWidth', iframeborder);
    }

});

Ext.reg('seniorframe', Ext.ux.senior.form.Frame);
