/*
 * Created on 19/09/2011
 * 
 * Copyright 2011 Senior Sistemas Ltda. All rights reserved.
 */

/**
 * Classe utilizada para agrupar funes utilitrias para clculos de tamanho de elementos.
 * 
 * @author Andr Hildinger
 */
ElementMetrics = {

    /**
     * Calcula a largura correta de um elemento quando est contido em um container invisvel.
     * 
     * @param el Elemento a se obter a largura
     * @returns A largura correta do elemento
     */
    getElementWidth : function(el) {
        var newEl = el.cloneNode(true);
        
        // Copia todos os estilos que afetam o elemento em browsers diferentes de IE
        if (!Ext.isIE) {
            newEl.style.cssText = window.getComputedStyle(el, null).cssText;
        }
        
        // Posiciona o elemento fora da tela para no ficar visvel para o usurio
        newEl.style.position = "absolute";
        newEl.style.left = "-1000px";
        newEl.style.top = "-1000px";
        
        document.body.appendChild(newEl);
        
        // Copia todos os estilos que afetam o elemento no IE
        if (Ext.isIE) {
            for (var attribute in el.currentStyle) {
                // Os atributos relacionados a kashida do erro ao serem copiados
                if (attribute.toLowerCase().indexOf('kashida') == -1) {
                    newEl.style[attribute] = el.currentStyle[attribute]; 
                }
            }
        }
        
        var width = newEl.offsetWidth;
        
        document.body.removeChild(newEl);
        
        return width;
    }

};