Ext.override(Ext.Element, {
    
    /**
     * Adicionando mtodo novo.
     * Retorna o valor decimal da largura do elemento.
     */
    adjustDirect2DWidth : function() {
        var me = this,
            dom = me.dom;

        var str = window.getComputedStyle(dom,null).width;
        str = str.substring(0, str.indexOf('px'));
        return str - Math.floor(str);
    },
                
    /**
     * Sobreescrevendo mtodo para corrigir problema da tarefa "382186 - Hint com quebra de linha no IE11"
     * Parte do cdigo copiado dos fontes do Ext 4.2.3: http://docs.sencha.com/extjs/4.2.3/source/Element_style.html mtodo [getWidth]  
     */
    getWidth : function(contentWidth){
        var me = this,
            dom = me.dom,
            hidden = me.isStyle('display', 'none'),
            width, floating;
             
        if (hidden) {
            return 0;
        }

        width = dom.offsetWidth;
        // IE9/10 Direct2D dimension rounding bug: https://sencha.jira.com/browse/EXTJSIV-603
        // there is no need make adjustments for this bug when the element is vertically
        // rotated because the width of a vertical element is its rotated height
        if (Ext.isString(document.body.style.msTransformOrigin) && Ext.isIE10p && !me.vertical) {
            // get the fractional portion of the sub-pixel precision width of the element's text contents
            floating = me.adjustDirect2DWidth();

            // IE9 also measures fonts with sub-pixel precision, but unlike Gecko, instead of rounding the offsetWidth down,
            // it rounds to the nearest integer. This means that in order to ensure that the width includes the full
            // width of the text contents we need to increment the width by 1 only if the fractional portion is less than 0.5
            if (floating > 0 && floating < 0.5) {
                width++;
            }
        }

        if (contentWidth) {
            width -= me.getBorderWidth("lr") + me.getPadding("lr");
        }

        return (width < 0) ? 0 : width;
    }
    
});