Ext.namespace('Ext.ux.senior.form');

/**
 * Componente CheckBox, com funcionalidades estendidas em relao ao CheckBox do
 * Ext 3.2.1.
 * 
 * @class Ext.ux.senior.form.Checkbox
 * @extends Ext.form.Checkbox
 */
Ext.ux.senior.form.Checkbox = Ext.extend(Ext.form.Checkbox, {

    initComponent : function() {
        if (this.boxLabel == '&#160;') {
            this.boxLabel = '';
        }
        Ext.ux.senior.form.Checkbox.superclass.initComponent.call(this, arguments);
    },

    /**
     * @override
     */
    render : function(ct, position) {
        Ext.ux.senior.form.Checkbox.superclass.render.call(this, ct, position);
        /* quando no existir a descrio do checkbox, no exibir a tag label que contm a descrio. */
        var description = this.container.select('label').elements[0];
        if (description != null && description.innerHTML === "&nbsp;") {
            description.style.display = 'none';
        }
        var divEl = Ext.get(this.el.findParent('.x-form-check-wrap'));
        divEl.addClass('ux-checkbox-dirty-position');
    },

    eventMapping : function() {
        return {
            check : this.prepareChangedEventData
        };
    },

    /**
     * Dados para serem envidados para servidor no evento check do checkbox
     */
    prepareChangedEventData : function() {
        return {
            type : 'changed',
            value : this.checked
        };
    },

    /**
     * Sobrescreve o onClick para prevenir que o valor do checkbox seja editado
     * quando ele est readOnly.
     * 
     * @override
     */
    onClick : function() {
        if (this.readOnly) {
            this.el.dom.checked = this.checked;
        } else {
            Ext.ux.senior.form.Checkbox.superclass.onClick.call(this);
        }
    },

    /* set ao valor no CheckBox sem disparar o check (previne uma nova notificao ao servidor sem necessidade) */
    internalSetValue : function(v) {
        var checked = this.checked;
        this.checked = (v === true || v === 'true' || v == '1' || String(v).toLowerCase() == 'on');
        if (this.rendered) {
            this.el.dom.checked = this.checked;
            this.el.dom.defaultChecked = this.checked;
        }
        if (checked != this.checked) {
            if (this.handler) {
                this.handler.call(this.scope || this, this, this.checked);
            }
        }
        return this;
    },

    /**
     * atribui um label para este CheckBox
     */
    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    /**
     * Retorna o elemento que possui o estilo desejado.
     * @param scope o escopo e a propriedade separados por um '$', ex: checkbox$font-color.
     * @returns o elemento que possui o estilo passado no escopo.
     * @override
     */
    getStyleEl : function(scope) {
        var split = scope.split('$');
        var styleScope = split[0];
        var property = split[1];

        if (styleScope == 'checkbox' && property.indexOf('border') > -1) {
            return this.getEl();
        } else if (styleScope == 'label') {
            return this.label;
        }

        return Ext.get(this.getEl().parent('div'));
    },

    markInvalid : function() {
        var textEl = this.container.child('label');
        if (textEl) {
            textEl.addClass('invalid-field');
        }
    },

    onResize : function() {
        if (!this.cellCls || this.cellCls.indexOf("gridlayout") == -1) {
            Ext.ux.senior.form.Checkbox.superclass.onResize.call(this, arguments);
        }
    },

    clearInvalid : function() {
        var textEl = this.container.child('label');
        if (textEl) {
            textEl.removeClass('invalid-field');
        }
    }
});

Ext.reg('seniorcheckbox', Ext.ux.senior.form.Checkbox);
