
/**
 * Aqui esto documentadas os anotations que a Tecnologia Senior utiliza no JavaScript.
 * Foi tomada como base os anotations utilizados no projeto OpenSource JSDoc Toolkit, que  o que melhor atende as nossas necessidades.
 * Referncia: http://code.google.com/p/jsdoc-toolkit/wiki/TagReference
 * 
 * Abaixo estaro listadas os Annotations utilizados, cada um em um JSDoc diferente, inclusive os utilizados pelo projeto opensource.
 * 
 * Portanto devem ser considerados os Annotations deste fonte para tal.
 *
 * @author Jean.Kirchner
 */

/**
 * @author author.name (obrigatrio em classe)
 * Permite documentar o autor do cdigo para uma classe, metodo ou propriedade.
 */

/**
 * @class description (opcional)
 * Identifica que  uma classe
 */

/**
 * @constant description (opcional)
 * Indica que o identificador  uma constante.
 * 
 * Pode ser utilizado, mas  melhor utilizar constantes do javascript que j diz que  constante:
 * 
 * const blah = 1;
 * blah = 2;
 * 
 * alert(blah); //alerts 1
 * 
 */

/**
 * @constructor description (opcional)
 * Indica que  uma funo  um construtor 
 */

/**
 * @default value (obrigatrio)
 * 
 * Quando um valor  default para algum objeto, este deve ser documentado com @default
 */

/**
 * @event (obrigatrio)
 * Indica que  um evento que pode ser disparado, ou um mtodo que pode ser chamado quando um evento de mesmo nome ocorrer.
 *  
 */

/**
 * {@link Simbol} (opcional)
 * Permite criar links na documentao para outros smbolos. 
 */

/**
 * @param {paramType} paramName paramDescription (opcional para primitivos, obrigatrio para complexos)
 * 
 * Se for um tipo complexo, deve ser documentado a sintaxe deste tipo:
 * 
 * Ex:
 * 
 * @param {json} blah faz blah
 *      {
 *        blah1: {String},
 *        blah2: {Number},
 *        blah3: {Boolean}
 *      }
 * @param {function} callback chama em algum momento
 *        function ( {String} param1, {Number} param2, {Boolean} param3) {
 *        }
 *
 * @param {MinhaClasse} inst instncia de MinhaClasse:
 *      Apenas para saber a que classe se refere
 */

/**
 * @private (opcional)
 *      Indica uso interno da classe, e das classes auxiliares. Indica baixo impacto de alterao, a no ser que 
 *      outras classes auxiliares utilizarem, neste caso,  recomendado que se documente estes usos.
 */

/**
 * @public (obrigatrio)
 *      Qualquer um pode utilizar, significa que pode haver grandes impactos ao mexer nestes mtodos.
 * 
 */

/**
 * @requires description (opcional)
 * 
 * Indica o requerimento de alguma condio para o uso, ou de algum tipo de recurso.
 * 
 * Ex:
 * 
 * @requires document loaded
 * function writeDocument() {
 * }
 * 
 * @requires {@link ColorPicker}
 * function chooseColor() {
 * }
 * 
 */

/**
 * @returns {type} description (opcional para primitivos, obrigatrio para complexos)
 * 
 * Verificar @param, o uso deve ser o mesmo, a no ser que  para especificar o valor de retorno
 */

/**
 * @see description (opcional)
 * 
 * Indica um recurso relacionado, ou algo que  bom ser verificado.
 */

/**
 * @since version/state/condition/event (opcional)
 * 
 * Descreve que o recurso existe desde algum momento, no necessriamente uma verso, pode ser alguma implementao, ou branch ou enfim.
 */

/**
 * @static (obrigatrio)
 * Indica que  esttico
 */

/**
 * @throws {exceptionType} (Obrigatrio)
 * Indica que vai lanar uma exceo 
 */

/**
 * @cfg {type} required/optional (obrgatrio)
 * 
 * Se um construtor, ou mtodo de inicializao recebe um objeto de configurao para sua construo, 
 * as propriedades deste objeto devem ser documentadas com @cfg
 * 
 */
