function SeniorLogger() {
    this.emptyfn = function() {
    };
    this.log = this.emptyfn;
    this.trace = this.emptyfn;
    this.debug = this.emptyfn;
    this.info = this.emptyfn;
    this.warn = this.emptyfn;
    this.error = this.emptyfn;
    this.fatal = this.emptyfn;

    this.setEnabled = function(enabled, debugLevel) {

        if (debugLevel > 0 && enabled === true) {
            this.logger = log4javascript.getLogger("senior");
            var popUpAppender = new log4javascript.PopUpAppender();
            var layout = new log4javascript.PatternLayout("[%d{HH:mm:ss,SSS}] [%-5p] %m");
            popUpAppender.setLayout(layout);
            this.logger.addAppender(popUpAppender);

            switch (debugLevel) {
            case 5:
                this.trace = function() {
                    this.logger.log(log4javascript.Level.TRACE, arguments);
                };
                this.debug = function() {
                    this.logger.log(log4javascript.Level.DEBUG, arguments);
                };

            case 4:
                this.info = function() {
                    this.logger.log(log4javascript.Level.INFO, arguments);
                };
                this.log = function() {
                    this.logger.log(log4javascript.Level.INFO, arguments);
                };

            case 3:
                this.warn = function() {
                    this.logger.log(log4javascript.Level.WARN, arguments);
                };

            case 2:
                this.fatal = function() {
                    this.logger.log(log4javascript.Level.FATAL, arguments);
                };
                this.error = function() {
                    this.logger.log(log4javascript.Level.ERROR, arguments);
                };
            }

        } else {
            this.logger = null;
            this.log = this.emptyfn;
            this.trace = this.emptyfn;
            this.debug = this.emptyfn;
            this.info = this.emptyfn;
            this.warn = this.emptyfn;
            this.error = this.emptyfn;
            this.fatal = this.emptyfn;
        }
    };

    this.time = function(name) {
        var now = new Date();
        this[name] = new Array();
        this[name][0] = now;
    };

    this.pause = function(name) {
        var now = new Date();
        var len = this[name].length;
        this[name][len] = now;
    };

    this.step = function(name) {
        var now = new Date();
        var len = this[name].length;
        this[name][len] = now;
    };

    this.timeEnd = function(name) {
        now = new Date();
        times = this[name];
        if (times) {
            var len = times.length;
            if ((len % 2) > 0) {
                times[times.length] = now;
            }
            var milis = 0;
            var start = null;
            for (i = 0; i < times.length; i++) {
                if (start === null) {
                    start = times[i];
                } else {
                    var stop = times[i];
                    milis = milis + (stop.getTime() - start.getTime());
                    start = null;
                    stop = null;
                }
            }
            this.debug("SeniorLogger.timeEnd('", name, "') [", milis, "milis]");
            delete this[name];
        } else {
            this.error("SeniorLogger.timeEnd('", name, "') [time not found]");
        }
    };
}
SLogger = new SeniorLogger();

Stack = new function() {
    this.getStackTrace = function() {
        var trace = [];
        var current = arguments.callee.caller;
        while (current) {
            var signature = this.getSignature(current);
            trace.push(signature);
            current = current.caller;
        }
        return trace;
    };
    this.getSignature = function(fn) {
        var signature = {
            name : this.getName(fn),
            boddy : fn.toString(),
            toString : function() {
                return this.name;
            }
        };
        return signature;
    };
    this.getName = function(fn) {
        if (fn.name) {
            return fn.name;
        }
        var definition = fn.toString();
        definition = definition.replace(/\n/g, '');
        definition = definition.replace(/\r/g, '');
        definition = definition.replace(/\f/g, '');
        definition = definition.replace(/\t/g, '');
        var index = definition.indexOf("{");
        if (index > -1) {
            return definition.substr(0, index);
        }
        return "anonymous";
    };
};

Error.prototype.getStackTrace = function() {
    return Stack.getStackTrace();
};