/**
 * Classe para responder as solicitaes do selenium quanto ao componente label associado ao label no FormLayout.
 * 
 * @author Janana Mendona
 */

SLabelAssociatedLabel = {
    name : "SLabelAssociatedLabel helper",
    toString : function() {
        return this.name;
    }
};

Ext.apply(SLabelAssociatedLabel, {

    /**
     * Obtm o texto do label associado
     * @param id o id do label associado
     * @returns o texto do label associado
     */
    getText : function(id) {
        var cmp = Ext.get(id);
        var text = "";
        if (cmp) {
            if (Ext.isIE) {
                text = cmp.dom.innerHTML;
            } else {
                text = cmp.dom.textContent;
            }
        }
        return text == null ? "" : text;
    },

    /**
     * Sobrescrito, pois o label associado ao label tem uma forma diferente de pegar o elemento HTML dele. 
     * @override
     */
    getStyle : function(id, scope, property) {

        var componentEl = Ext.get(id);

        if (componentEl == SComponent.INVALID_ELEMENT || !componentEl) {
            return null;
        }

        if (!SComponent.validateProperty(componentEl, property, scope)) {
            return null;
        }

        var realProperty = SComponent.getCssPropertyName(scope, property);
        if (property == "font-style") {
            return SComponent.getFontStyle(componentEl);
        }
        return componentEl.getStyle(realProperty);
    }

}, SLabel);