Ext.namespace('Ext.ux.senior.plugins');

/**
 * @author Thiago Gesser
 * @author Ramon Weiss
 */
Ext.ux.senior.plugins.PanelToolbarPlugin = function (components) {
    this.components = components;
};

/**
 * Constante que aponta para a funo padro para obter o collapsedEl.
 */
Ext.ux.senior.plugins.PanelToolbarPlugin.getCollapsedElDefaultFn = Ext.layout.BorderLayout.Region.prototype.getCollapsedEl;

/**
 * Constante para a margem deixada na barra de collapse em relao ao tamanho que o maior boto ocupa.
 */
Ext.ux.senior.plugins.PanelToolbarPlugin.sizeMargin = 4;

/**
 * Constante que define uma funo que para o evento de um click de um boto.
 */
Ext.ux.senior.plugins.PanelToolbarPlugin.stopPropagationFn = function (btn, evt) {
    evt.stopPropagation();
};

Ext.ux.senior.plugins.PanelToolbarPlugin.prototype = {

    init : function (panel) {

        if (!this.components) {
            return;
        }

        //Garante que  um panel que est usando o plugin.
        if (!( panel instanceof Ext.ux.senior.Panel)) {
            throw "The component must be a Ext.ux.senior.Panel to use this plugin. Panel: " + panel.getId();
        }

        //Garante que o panel est dentro de um owner com BorderLayout.
        var ownerCt = panel.ownerCt;
        if (!ownerCt || (ownerCt.layout != 'border' && ownerCt.layout != 'seniorborder' && !(ownerCt.layout instanceof Ext.layout.BorderLayout))) {
            throw "The layout of the owner must be Ext.layout.BorderLayout to use this plugin. Panel: " + panel.getId();
        }

        //Garante que o panel no est no centro.
        if (panel.region == 'center') {
            throw "The region of the panel cannot be 'center' to use this plugin. Panel: " + panel.getId();
        }

        // Verifica aonde os componentes deve ser renderizados.
        // ON_EXPANDED - Somente no header do panel.
        // ON_COLLAPSED - Somente no elemento de collapse do panel.
        // ALWAYS - Nos dois lugares citados acima.
        if (panel.componentAttachmentTarget == 'ON_EXPANDED') {
            this.activeHeader(panel);

        } else if (panel.componentAttachmentTarget == 'ON_COLLAPSED') {
            this.activeCollapsedBar(panel, this.components);

        } else if (panel.componentAttachmentTarget == 'ALWAYS') {
            // Verifica se o panel est collapsed, para que com isso renderize o componente somente no lugar correto.
            this.activeCollapsedBar(panel, this.components);

            if (!panel.collapsed) {
                this.activeHeader(panel);
            }

        }

        // Devido a otimizao, o browser no renderiza a altura
        // do header do panel, quando o panel inicia collapsed.
        // Ento setamos a altura padro do header.
        panel.on('afterrender', function (panel) {
            panel.header.setStyle('height', '15px');
            panel.on('collapse', this.insertElements, this, panel);
            panel.on('expand', this.insertElements, this, panel);
        }, this, panel);
    },

    insertElements : function (panel) {
        if (panel.componentAttachmentTarget != 'ALWAYS') {
            return;
        }

        if (panel.collapsed) {
            for (var i = 0; i < this.components.length; i++) {
                var cmp = this.components[i];

                panel.collapsedEl.insertFirst(cmp.getEl());

                if (cmp.xtype == 'seniorlabel') {
                    cmp.getEl().replaceClass('x-label-header-margin', 'x-label-collapse-margin');

                } else if (cmp.xtype == 'seniorbutton') {
                    cmp.getEl().replaceClass('x-btn-header-margin', 'x-btn-collapse-margin');

                } else {

                    cmp.getEl().addClass('x-collapse-margin');
                }
            }

        } else {
            // Faz o backup da altura do header, pois quando  adicionado um componente no header,
            // ele utiliza a altura do maior componente adicionado para se ajustar.
            var bkpHeight = panel.header.getHeight();

            for (var i = 0; i < this.components.length; i++) {
                var cmp = this.components[i];

                panel.header.insertFirst(cmp.getEl());

                if (cmp.xtype == 'seniorlabel') {
                    cmp.getEl().replaceClass('x-label-collapse-margin', 'x-label-header-margin');

                } else if (cmp.xtype == 'seniorbutton') {
                    cmp.getEl().replaceClass('x-btn-collapse-margin', 'x-btn-header-margin');

                } else {
                    cmp.getEl().removeClass('x-collapse-margin');
                }
            }

            // Seta a altura armazenada anteriormente.
            panel.header.setHeight(bkpHeight);
        }

    },

    createHeaderEl : function (panel) {
        var bkpHeight = panel.header.getHeight();
        //Renderiza os componentes no header do panel.
        for (var i = 0; i < this.components.length; i++) {
            var cmp = this.createComponent(this.components[i]);

            if (cmp.alignment == 'LEFT') {
                lastLeftCmp = cmp;
            }

            this.components[i] = cmp;
            cmp.render(panel.header);
        }

        // Adiciona o titulo novamente para que no acabe desalinhando os componentes.
        if (panel.headerAsText) {
            var select = panel.header.child('.x-panel-header-text');
            panel.header.appendChild(select);
            select.addClass('x-label-title');
            select.addClass('x-senior-collapsed-title');
        }

        // Seta a altura armazenada anteriormente.
        panel.header.setHeight(bkpHeight);

    },

    createComponent : function (config) {
        var cmp = Ext.create(config);
        var alignmentCls = 'x-collapse-left';

        if (cmp.alignment == 'RIGHT') {
            alignmentCls = 'x-collapse-right';

        } else if (cmp.alignment == 'CENTER') {
            alignmentCls = 'x-collapse-center';

        }

        if (cmp.xtype == 'seniorlabel') {
            cmp.addClass('x-label-title');
            cmp.addClass('x-senior-collapsed-title');
        }

        cmp.addClass(alignmentCls);

        return cmp;
    },

    createCollapsedEl : function (cmps, originalFn, panel) {
        //Gera o collapsedEl original.
        var collapsedEl = originalFn.call(this);

        //Armazena a altura e a largura mxima dos botes renderizados para posteriormente ajustar o tamanho do collapsedEl.
        var maxHeight = -1;
        var maxWidth = -1;

        //Renderiza os botes no collapsedEl
        for (var i = 0; i < cmps.length; i++) {
            var cmp = Ext.create(cmps[i]);
            var alignmentCls = 'x-collapse-left';

            if (cmp.alignment == 'RIGHT') {
                alignmentCls = 'x-collapse-right';

            } else if (cmp.alignment == 'CENTER') {
                alignmentCls = 'x-collapse-center';
            }

            cmp.addClass(alignmentCls);
            cmps[i] = cmp;

            //Coloca um sequence no handler para parar o evento de click, evitando que ele chegue na barra de collapse e ative o fast view.
            if (cmp.handler) {
                cmp.handler = cmp.handler.createSequence(Ext.ux.senior.plugins.PanelToolbarPlugin.stopPropagationFn);
            } else {
                //Se no houver handler, coloca diretamente a funo que para a propagao do evento de click.
                cmp.handler = Ext.ux.senior.plugins.PanelToolbarPlugin.stopPropagationFn;
            }

            if (cmp.xtype == 'seniorlabel') {
                cmp.addClass('x-label-title');
                cmp.addClass('x-senior-collapsed-title');
            }

            cmp.render(collapsedEl);

            if (cmp.getHeight() > maxHeight) {
                maxHeight = cmp.getHeight();
            }
            if (cmp.getWidth() > maxWidth) {
                maxWidth = cmp.getWidth();
            }
        }

        //Classe css para os itens do boto
        if (this.position == 'east' || this.position == 'west') {
            //Ajusta o tamanho do collapsedEl de acordo com a maior largura dos botes.
            collapsedEl.setWidth(maxWidth + Ext.ux.senior.plugins.PanelToolbarPlugin.sizeMargin);

        } else if (this.region == 'north' || this.region == 'south') {
            //Ajusta o tamanho do collapsedEl de acordo com a maior altura dos botes.
            collapsedEl.setHeight(maxHeight + Ext.ux.senior.plugins.PanelToolbarPlugin.sizeMargin);
        }

        //Aplica o estilo nos elementos do collapsedEl
        this.expandToolEl.addClass('collapsed-panel-expand-btn');

        //Depois de gerar o collapsedEl, no h mais necessidade de passar por esta funo. Por isto, passa a chamar
        //a funo original.
        this.getCollapsedEl = originalFn;
        panel.collapsedEl = collapsedEl;

        return collapsedEl;
    },

    activeCollapsedBar : function (panel, cmps) {
        /*
         * O BorderLayout replica todas as propriedades do panel nas Regions. Desta forma  possvel sobrescrever a funo
         * "getCollapsedEl" (que cria o elemento collpasado) para customiz-lo.
         */

        var originalFn = Ext.ux.senior.plugins.PanelToolbarPlugin.getCollapsedElDefaultFn;

        //Cria uma chamada para a funo "createcollapsedEl" especfica para os buttons e a originalFn e sobrescreve
        //a funo getCollapsedEl.
        var createCollapsedElFn = this.createCollapsedEl;
        panel.initialConfig.getCollapsedEl = function () {
            return createCollapsedElFn.call(this, cmps, originalFn, panel);
        };
    },

    activeHeader : function (panel) {
        panel.on('afterrender', this.createHeaderEl, this, panel);
    }
};

Ext.preg('collapsedpaneltoolbar', Ext.ux.senior.plugins.PanelToolbarPlugin); 