Ext.namespace('Ext.ux.senior.form.plugins');
/**
 * Plugin para o DateField apresentar apenas a seleo de ms e ano quando a mscara for MM/YYYY ou MM/YY
 * 
 * @author Janana Mendona
 */
Ext.ux.senior.form.plugins.MonthPickerPlugin = Ext.extend(Object, {
    
    oldDateDefaults: null,
    dateField : null, 
    
    init : function(dateField) {
        dateField.onTriggerClick = dateField.onTriggerClick.createSequence(this.onClick, this);
        dateField.getValue = dateField.getValue.createInterceptor(this.setDefaultMonthDay, this).createSequence(this.restoreDefaultMonthDay, this);
        dateField.beforeBlur = dateField.beforeBlur.createInterceptor(this.setDefaultMonthDay, this).createSequence(this.restoreDefaultMonthDay, this);
        this.dateField = dateField;
    },

    setDefaultMonthDay : function() {
        this.oldDateDefaults = Date.defaults.d;
        Date.defaults.d = 1;
        return true;
    },

    restoreDefaultMonthDay : function(ret) {
        Date.defaults.d = this.oldDateDefaults;
        return ret;
    },

    onClick : function(e, el, opt) {
        var picker = this.dateField.menu.picker;
        picker.activeDate = picker.activeDate.getFirstDateOfMonth();
        if (picker.value) {
            picker.value = picker.value.getFirstDateOfMonth();
        }

        picker.showMonthPicker();

        if (!picker.disabled) {
            picker.monthPicker.stopFx();
            picker.monthPicker.show();

            picker.mun(picker.monthPicker, 'click', picker.onMonthClick, picker);
            picker.mun(picker.monthPicker, 'dblclick', picker.onMonthDblClick, picker);
            picker.onMonthClick = picker.onMonthClick.createSequence(this.onMonthClick, this);
            picker.onMonthDblClick = picker.onMonthDblClick.createSequence(this.onMonthDoubleClick, this);
            picker.keyNav.enter = picker.keyNav.enter.createSequence(this.onEnter, this);
            picker.mon(picker.monthPicker, 'click', picker.onMonthClick, picker);
            picker.mon(picker.monthPicker, 'dblclick', picker.onMonthDblClick, picker);
        }
    },

     onMonthClick : function(e, t) {
        var el = new Ext.Element(t);
        if (el.is('button.x-date-mp-cancel')) {
            this.dateField.menu.hide();
        } else if (el.is('button.x-date-mp-ok')) {
            var picker = this.dateField.menu.picker;
            picker.setValue(picker.activeDate);
            picker.fireEvent('select', picker, picker.value);
        }
    },

    onMonthDoubleClick : function(e, t) {
        var el = new Ext.Element(t);
        if (el.parent() && (el.parent().is('td.x-date-mp-month') || el.parent().is('td.x-date-mp-year'))) {

            var picker = this.dateField.menu.picker;
            picker.setValue(picker.activeDate);
            picker.fireEvent('select', picker, picker.value);
        }
    },
    
    onEnter : function(){
        var picker = this.dateField.menu.picker;
        picker.setValue(picker.activeDate);
        picker.fireEvent('select', picker, picker.value);
    }
    
});

Ext.preg('monthPickerPlugin', Ext.ux.senior.form.plugins.MonthPickerPlugin);