Ext.namespace('Ext.ux.senior.plugins');
/**
 * Cria um wrapper em um Field e adiciona uma classe de estilo para permitir
 * customizao do componente. As classes criadas so:<br>
 * 
 * <code>text-field</code> para EditBox.
 * <code>combo-field</code> para ComboBox.
 * <code>text-area-field</code> para TextArea.
 * <code>checkbox-field</code> para CheckBox.
 * <code>radio-field</code> para RadioButton.
 * <code>calendar-field</code> para Calendrio.
 * 
 */
Ext.ux.senior.plugins.FieldStylePlugin = Ext.extend(Object, {

    init : function(owner) {

        /* 
         * O checkbox da grid no possui ownerCt, por isso foi necessrio verificar se o owner  um checkbox da grid
         * para no adicionar o plugin de estilo.
         */

        if (owner.ownerCt && owner.ownerCt.layout != "seniorflowlayout") {
            owner.ctCls = this.getWrapperClass(owner);
        } else {
            if (owner.xtype === 'seniorcheckbox' && owner.gridId) {
                return;
            }
            owner.on("render", this.onComponentRender, this);
        }

    },

    onComponentRender : function(owner) {
        var el = owner.getResizeEl();
        var wrapperClass = this.getWrapperClass(owner);
        el.wrap({
            tag : "div",
            cls : wrapperClass
        });
    },

    getWrapperClass : function(owner) {
        if (owner.getXType() == "seniortextfield") {
            return "text-field";
        }
        if (owner.getXType() == "seniorcombo") {
            return "combo-field";
        }
        if (owner.getXType() == "seniortrigger") {
            return "text-field";
        }
        if (owner.getXType() == "seniortriggerbox") {
            return "text-field";
        }
        if (owner.getXType() == "seniordatefield") {
            return "text-field";
        }
        if (owner.getXType() == "seniortextarea" || owner.getXType() == "textarea") {
            return "text-area-field";
        }
        if (owner.getXType() == "seniorcheckbox") {
            return "checkbox-field";
        }
        if (owner.getXType() == "seniorradio") {
            return "radio-field";
        }
        if (owner.getXType() == "seniordatepicker") {
            return "calendar-field";
        }

    }

});

Ext.preg('fieldstyle', Ext.ux.senior.plugins.FieldStylePlugin);
