Ext.namespace('Ext.ux.senior.form.plugins');

Ext.ux.senior.form.plugins.DescriptionPlugin = function(config) {
    Ext.apply(this, config);
};

Ext.extend(Ext.ux.senior.form.plugins.DescriptionPlugin, Ext.util.Observable, {

    init : function(comp) {
        comp.onRender = comp.onRender.createSequence(function() {
            /* para no criar uma novo description a cada vez que renderiza */
            if (!this.wrapDesc) {
                var el = this.getEl();
                var wrap;
                var style = "";
                var cls = "";
                this.wrapDesc = el.wrap( {
                    tag : "span"
                });
                if (this.trigger) {
               		wrap = this.wrapDesc;
                    this.wrapDesc.appendChild(this.trigger);
                    cls = "description-trigger-margin";
                } else if (this.xtype == "seniorcheckbox") {
                    wrap = this.wrap;
                    style = "margin: 1px 0px 0px 5px;";
                    cls = "x-form-cb-label";
                } else{
                	if(this.xtype == "seniortextarea"){
                	/*Esse estilo  necessrio, pois quando o textarea no est visvel, ao 
                	 * adicionar o doritos o browser assume que a posio do textarea  zero, 
                	 * adicionado o doritos nesta posio. Ento quando o textarea fica visvel, 
                	 * acaba no sincronizando o doritos com a sua real posio.*/
                		this.wrapDesc.dom.style.position = "relative";
                		this.wrapDesc.dom.style.display = "block";
                	}
                    cls = "x-senior-align-text";
                    wrap = this.wrapDesc;
                }
                wrap.createChild( {
                    tag : "span",
                    html : this.description,
                    cls : cls,
                    style : style
                });
            }
        });

        /**
         * Recupera a descrio do componente.
         */
        comp.getDescription = function() {
            return comp.description;
        };

        /**
         * Adiciona descrio para o componente.
         */
        comp.setDescription = function(description) {
            comp.wrapDesc.html = description;
        };
    }

});

Ext.preg('descriptionplugin', Ext.ux.senior.form.plugins.DescriptionPlugin);
