Ext.namespace('Ext.ux.senior.plugins');

Ext.ux.senior.plugins.CheckBoxGridPlugin = Ext.extend(Object, {

    component : null,
    grid : null,

    /**
     * Inicializao do plugin de checkbox da grid.
     */
    init : function(component) {
        this.component = component;

        this.grid = Ext.getCmp(this.component.componentOwner);
        this.grid.on('keydown', this.onKeyDown, this);
        this.component.on('destroy', this.onComponentDestroy, this);
        this.component.on('afterrender', this.onRender, this);
    },
    
    /**
     * @private
     */
    onComponentDestroy : function(cmp) {
        Ext.getCmp(cmp.gridId).un('keydown', this.onKeyDown, this);
    },

    /**
     * @private 
     */
    stopPropagationFn : function(e) {
        e.stopPropagation();
    },
    
    onRender : function(ct, position) {
        var componentEl = this.component.getEl();
        
        // a ao no componente no deve alterar a seleo na grid
        componentEl.on('mousedown', this.stopPropagationFn);
    },

    /**
     * marca/desmarca o checkbox da grid quando a tecla SPACE for pressionada na clula.
     * @event onkeydown
     */
    onKeyDown : function(event) {
        var key = event.keyCode;

        var E = Ext.EventObject;
        switch (key) {
        case E.SPACE:
            var selection = Ext.getCmp(this.component.componentOwner).getSelectionModel().getSelectedCell();
            var row = this.grid.getStore().indexOfId(this.component.defaultParams.row);
            if (selection && selection[0] == row && selection[1] == this.component.col && !this.component.readOnly) {
                this.component.setValue(!this.component.getValue());
            }
            break;
        }
    }
});

Ext.preg('checkboxgridplugin', Ext.ux.senior.plugins.CheckBoxGridPlugin);