Ext.namespace('Ext.ux.senior.plugins');

Ext.ux.senior.plugins.ChangeStylePlugin = Ext.extend(Object, {
    text : "estilo",
    init : function(owner) {
        Ext.apply(owner, {
            onRender : owner.onRender.createSequence(function(ct, position) {
                owner.menu = new Ext.ux.senior.ChangeStyleMenu();
                owner.menu.prepareItems();
            })
        });
    }

});
 
Ext.namespace('Ext.ux.senior');
Ext.ux.senior.ChangeStyleMenu = Ext.extend(Ext.menu.Menu, {
    renderedItems : new Array(),
    prepareItems : function() {
        var i, a, links = document.getElementsByTagName("link"), len = links.length;
        var itemEnabled = null;
        for (i = 0; i < len; i++) {
            a = links[i];
            if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && a.getAttribute("title") != "default") {
                if (!this.containsItem(a.title)) {
                    this.renderedItems.push(a.title);
                    var it = new Ext.ux.senior.ChangeStyleItem( {
                        text : a.title
                    });
                    it.on("click", function() {
                        this.setStyle();
                    }, it);
                    this.addItem(it);
                    if (!a.disabled) {
                        itemEnabled = it;
                        it.fireEvent("click");
                    }
                }

            }
        }
    },

    containsItem : function(item) {
        for ( var i = 0; i < this.renderedItems.length; i++) {
            if (this.renderedItems[i] == item) {
                return true;
            }
        }
        return false;
    }
});

Ext.ux.senior.ChangeStyleItem = Ext.extend(Ext.menu.Item, {
    setStyle : function() {
        var i, a, links = document.getElementsByTagName("link"), len = links.length;
        for (i = 0; i < len; i++) {
            a = links[i];
            if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && a.getAttribute("title") != "default") {
                a.disabled = true;
                if (a.getAttribute("title") == this.text) {
                    a.disabled = false;
                }
            }
        }
    }
});

Ext.preg('changestyle', Ext.ux.senior.plugins.ChangeStylePlugin);