Ext.namespace('Ext.ux.senior.form.plugins');

/**
 * Plugin que avisa o usu�rio que o Caps Lock est� pressionado, atrav�s de um hint a direita do componente.
 * 
 * O plugin ir� ativar o hint apenas quando todas as condi��es abaixo estiverem sendo atentidas:
 * 
 * - usu�rio pressionar uma tecla correspondente a uma letra do alfabeto.
 * - Caps Lock estiver ligado
 * 
 * Caso o usu�rio insira um caractere que n�o seja uma letra, mesmo que o Caps Lock esteja ligado o hint ser� escondido.
 * O hint tamb�m � escondido quando o componente que recebeu o plugin perder o foco.
 * 
 * @author Daniel Pereira
 */
Ext.ux.senior.form.plugins.CapsLockPlugin = function(config) {
    Ext.apply(this, config);
};

Ext.extend(Ext.ux.senior.form.plugins.CapsLockPlugin, Ext.util.Observable, {

    /**
     * ToolTip que ser� exibido quando o usu�rio estiver com o Caps Lock pressionado
     */
    toolTip : null,
    
    /**
     * Mensagem que ser� exibida pelo usu�rio
     */
    message : 'Caps Lock is active.',

    /**
     * Campo que possui este plugin
     *  
     */
    
    /**
     * �cone exibido pelo hint de Caps Lock
     */
    icon : 'resources/images/login/SeverityWarning.gif',
    
    field : null,

    init : function(field) {
        Ext.apply(field, this.overrides);
        this.field = field;
        this.field.enableKeyEvents = true;
        this.field.on('keypress', function(field, evt) {
            if (this.isCapsLockPressed(evt)) {
                this.showToolTip();
            } else {
                this.hideToolTip();
            }
        }, this);

        this.field.on('blur', function() {
            this.hideToolTip();
        }, this);
        field.capsLockPlugin = this;
        var fn = function() {
            if(field.isCapsLockVisible()) {
                field.capsLockPlugin.showToolTip.defer(200, field.capsLockPlugin);
            }
        };
        if(Ext.isIE) {
            window.attachEvent('onresize', fn);
        } else {
            window.addEventListener('resize', fn);
        }
    },

    /**
     * Retorna se o Caps Lock est� pressionado. Este m�todo leva em considera��o apenas letras,
     * sendo que para caracteres que n�o estejam no alfabeto ser� retornado false.
     * 
     * @param evt evento de tecla pressionada
     * @returns {Boolean} true caso o usu�rio tenha pressionado uma tecla correspondente a uma letra e o Caps Lock esteja ativo,
     *                    false caso contr�rio
     */
    isCapsLockPressed : function(evt) {
        var charCode = evt.getCharCode();
        return (evt.shiftKey && charCode >= 97 && charCode <= 122) || (!evt.shiftKey && charCode >= 65 && charCode <= 90);
    },

    /**
     * Cria o hint para avisar o usu�rio que a tecla Caps Lock est� ativa
     */
    createToolTip : function() {
        this.toolTip = TooltipHelper.createHintsHtml([ {
            text : this.message,
            icon : this.icon
        } ], this.field.id, false, Ext.ux.senior.form.plugins.TooltipPlugin.showHintsFunction, {
            alignTo : 'br'
        });
        this.toolTip.show = TooltipHelper.createKeyAndClickInterceptor(this.toolTip.show);
        this.toolTip.hide = TooltipHelper.createKeyAndClickInterceptor(this.toolTip.hide);
    },

    /**
     * Esconde o hint que indica que o Caps Lock est� ativo
     */
    hideToolTip : function() {
        if (this.toolTip) {
            this.toolTip.hide(true);
        }
    },

    /**
     * Exibe o hint que indica que o Caps Lock est� ativo
     */
    showToolTip : function() {
        if (!this.toolTip) {
            this.createToolTip();
        }
        this.toolTip.show(true);
    },
    
    overrides : {
        /**
         * Retorna se o hint de Caps Lock est� sendo exibido
         * 
         * @returns {Boolean} true se o hint estiver sendo exibido, false caso contr�rio
         */
        isCapsLockVisible : function() {
            return this.capsLockPlugin.toolTip && this.capsLockPlugin.toolTip.isVisible();
        },
        
        /**
         * Retorna a mensagem exibida pelo hint que avisa que o Caps Lock est� ativado
         * 
         * @returns mensagem exibida pelo hint do Caps Lock
         */
        getCapsLockMessage : function() {
            return this.capsLockPlugin.message;
        },
        
        /**
         * Retorna o �cone exibido pelo hint que avisa que o Caps Lock est� ativado
         * 
         * @returns �cone exibido pelo hint do Caps Lock
         */
        getCapsLockIcon : function() {
            return this.capsLockPlugin.icon;
        }
    }

});

Ext.preg('capslockplugin', Ext.ux.senior.form.plugins.CapsLockPlugin);
