/**
 * DefaultRequestMessage representa o formato dos requests
 * 
 * Formato do request: <?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> <request perspectiveId="afsdfsdf"> <message target="fragmento que vai receber a mensagem">
 * <id>"id_do_componente_que_gerou_o_evento"</id> <type>"tipo_de _evento"</type> <properties> <!-- no valor da proprieade vamos usar o CDATA do xml e escape(valor), para tratamentos de caracteres
 * especiais --> <prop name="nome prop"/>"valor da propriedade"</prop> </properties> </message> </request>
 */
function DefaultRequestMessage(perspectiveId) {
    this.perspectiveId = perspectiveId;
    this.size = 0;
    this.request = new Array();
    this.messageListeners = null;
}

DefaultRequestMessage.prototype = {

    constructor : DefaultRequestMessage,
    
    blockInterface : false,

    setBlockInterface : function(block) {
        this.blockInterface = block;
    },

    isBlockInterface : function() {
        return this.blockInterface;
    },

    /**
     * @param {Object}
     *            obj O valor a ser concatenado
     * @return this para facilitar na programa��o
     */
    append : function(obj) {
        this.request.push(obj);
        return this;
    },

    /**
     * @param {Object}
     *            obj O valor a ser concatenado
     * @return this para facilitar na programa��o
     */
    appendProp : function(obj) {
        this.request.push(escape(obj));
        return this;
    },

    /**
     * Concatena, tratamentos para caracteres especiais
     * 
     * @param {Object}
     *            obj O valor a ser concatenado
     * @return this para facilitar na programa��o
     */
    appendValue : function(obj) {
        this.request.push("<![CDATA[");
        this.request.push(encodeURIComponent(obj));
        this.append("]]>");
        return this;
    },

    /**
     * Apenas faz verifica��es e lan�a um erro se necess�rio
     */
    check : function(msg) {
        /* come�a de 1, pois o msg n�o � necess�rio verificar */
        for ( var i = 1; i < arguments.length; i++) {
            /* tem que considerar "" portanto n�o utiliza-se !arguments[i]*/
            if (arguments[i] == null || arguments[i] == undefined) {
                /* Limpa quando da erro */
                this.clear();
                throw new Error(msg);
            }
        }
    },

    /**
     * Limpa o anterior para come�ar um novo, reaproveitando o objeto
     */
    newRequest : function() {
        this.clear();

        /* data= parametro para o request ser acess�vel no server */
        this.append("data=<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        this.append("<request perspectiveId = \"").appendProp(this.perspectiveId).append("\" >");
    },

    /**
     * Cria um novo message para o request
     */
    newMessage : function(target, id, type, messageListener) {
        this.check("Mensagem deve ter id, target e type", target, id, type);
        if (this.size > 0) {
            this.append("</properties></message>");
        }
        this.append("<message ").append(" target = \"").appendProp(target).append("\" >");
        this.append("<id>").appendValue(id).append("</id>");
        this.append("<type>").appendValue(type).append("</type>");
        this.append("<properties>");

        if (messageListener) {
            if (!this.messageListeners)
                this.messageListeners = new Array();
            this.messageListeners.push(messageListener);
        }

        this.size++;
    },

    /* Cria um novo property para o message */
    newProperty : function(name, value) {
        this.check("Propriedade deve ter name e value", name, value);
        this.append("<prop name=\"").appendProp(name).append("\">");
        this.appendValue(value);
        this.append("</prop>");
    },

    /**
     * Limpa os dados dessa mensagem, deixando-a pronta para ser reutilizada como se fosse uma nova mensagem.
     * 
     * @private
     */
    clear : function() {
        this.size = 0;
        this.request.splice(0, this.request.length);
        this.messageListeners = null;
    },

    getSize : function() {
        return this.size;
    },

    /* Retorna o valor do xml concatenado */
    toString : function() {
        if (this.size == 0) {
            return "";
        }

        /* Fecha a �ltima mensagem e request */
        this.append("</properties></message></request>");
        return this.request.join("");
    }

};

/**
 * Gerenciador da conex�o com o servidor. Ao mandar enviar uma mensagem, ela ser� guardada para ser enviada assim que o servidor estiver dispon�vel. Se mais mensagens foram requisitadas, elas ser�o
 * enviadas em um �nico request.
 * 
 * @param url
 *            recurso solicitado na url sem as /, ex.: start/, message/, destroy/?perspective....
 */
function DefaultConnection(url, perspectiveId) {
    this.reqMsg = new DefaultRequestMessage(perspectiveId);
    this.reqMsg.newRequest();

    this.url = url;
    this.isConnectionIdle = true;
    /*
    * Necess�rio duas listas, de forma que antes de vir a resposta de um
    * request, mais requests podem ter sido enfileirados Sendo assim necess�rio
    * salvar os estados dos listeners no qual foram chamados os beforeRequest
    * para chamar os afterRequests Sem chamar o after request dos listeners
    * para os requests que ainda n�o come�aram
    */
    this.listeners = new Array();
    this.afterListeners = null;

    /* se o servidor est� idle */
    this.serverIdle = true;
};

DefaultConnection.prototype = {

    constructor : DefaultConnection,

    release : function() {
        this.reqMsg = null;
        this.url = null;
    },

    /**
     * Para utilizar este metodo, o objeto obsComp deve ter no m�nimo um destes m�todos: beforeRequest, afterRequest
     * 
     * Antes de ser feito o request para o servidor ser� chamado o m�todo beforeRequest se houver. E ap�s o request 
     * ser� chamado afterRequest. Ap�s ler a resposta do servidor todos os listerners ser�o removidos
     * 
     * @param obsComp
     *            o listener para o request corrente
     */
    observe : function(obsComp) {
        this.listeners.push(obsComp);
    },

    sendRequest : function() {
        if (this.reqMsg.getSize() == 0) {
            /* Nada a processar */
            return;
        }
        if (!this.isConnectionIdle || !this.messageIsReady()) {
            this.checkRequests();
            return;
        }

        this.isConnectionIdle = false;
        this.serverIdle = false;

        var postData = this.reqMsg.toString();

        // Guardamos a mensagem que est� sendo processada porque ela possui
        // os listeners que ser�o disparados ap�s a execu��o da mensagem.
        this.processingMsg = this.reqMsg.messageListeners && this.reqMsg.messageListeners.slice();

        this.sendHttpXmlRequest(postData);
        if (this.reqMsg.isBlockInterface()) {
            ProcessManager.startProcess(true);
            this.reqMsg.setBlockInterface(false);
        }
        /* Ap�s enviar as mensagens pendentes come�a uma nova */
        this.reqMsg.newRequest();
    },

    /**
     * Retorna <code>true</code> caso todos os listeners da mensagem permitam a sua execu��o.
     * 
     * @returns {Boolean}
     */
    messageIsReady : function() {
        var messageListeners = this.reqMsg.messageListeners;
        if (messageListeners) {
            for ( var i = 0; i < messageListeners.length; i++) {
                var messageListener = messageListeners[i];
                if (messageListener.canSendRequest && messageListener.canSendRequest != undefined) {
                    if (!messageListener.canSendRequest()) {
                        return false;
                    }
                }
            }
        }
        return true;
    },

    notifyMessageListener : function(success) {
        var messageListeners = this.processingMsg;
        if (messageListeners) {
            for (var i = 0; i < messageListeners.length; i++) {
                var messageListener = messageListeners[i];
                if (messageListener.onComplete && messageListener.onComplete != undefined) {
                    messageListener.onComplete(!success);
                }
            }
        }
        this.processingMsg = null;
    },

    /**
     * Chamado antes de fazer o request Chama o evento beforeRequest dos listeners se existir
     */
    beforeRequest : function() {
        for ( var i = 0; i < this.listeners.length; i++) {
            if (this.listeners[i].beforeRequest && this.listeners[i].beforeRequest != undefined) {
                this.listeners[i].beforeRequest();
            }
        }
        /* Faz o backup dos listeners atuais para serem chamados posteriormente */
        /* quando vier a resposta do request */
        this.afterListeners = this.listeners;
        /* Cria um novo array para os novos listeners de novos requests */
        this.listeners = new Array();
    },

    /**
     * Chamado ap�s ser feito o request Chama o evento afterRequest dos listeners se existir TODO: verificar necessidade de passar um par�metro sucess (se o request foi efetuado com sucesso ou n�o)
     */
    afterRequest : function() {
        if (!this.afterListeners) {
            return;
        }
        for ( var i = 0; i < this.afterListeners.length; i++) {
            if (this.afterListeners[i].afterRequest && this.afterListeners[i].afterRequest != undefined) {
                this.afterListeners[i].afterRequest();
            }
        }
        this.afterListeners.splice(0, this.afterListeners.length - 1);
        /* Mata o afterListeners sendo que receber� listeners posteriormente */
        this.afterListeners = null;
    },

    /**
     * @see Ext.Ajax.request sucess function signature
     */
    onSuccess : function(response, options) {
        SLogger.time('fromServer');

        var block = SProfilerManager.start("Connection -> onSucess() -> eval()");

//        console.log('response.responseText >> ' + response.responseText);
        SProfilerManager.step(escape(response.responseText), block);
        try {
            eval(response.responseText);
        } catch (e) {
            this.handleError(response, e);
        }
        SProfilerManager.stop(block);

        SProfilerManager.flush();

        SLogger.timeEnd('fromServer');
        this.afterRequest();
        this.notifyMessageListener(true);
        this.isConnectionIdle = true;
    },

    /**
     * @see Ext.Ajax.request failure function signature
     */
    onFailure : function(response, options) {
        /* this.afterRequest(); */
        if (!window.perspectiveId) {
            Senior.abort();
        }
        this.notifyMessageListener(false);
        this.isConnectionIdle = true;
        //TODO TRATAR PARA CRIAR A TELA DE ERRO
        /* SLogger.error('Problemas ao fazer requisi��o para o servidor', */
        /* response.responseText, '', -1, null); */
    },

    /**
     * @private
     * Trata erro de conex�o, tratamentos: 
     *  - Quando vier a tela de login como request, recarrega a p�gina
     *  - Quando vier a tela de erro cr�tico como request, executa a fun��o que veio na tela  
     */
    handleError : function(response, exception) {
        if (response.responseText.indexOf("<!-- LOGIN PAGE -->") == 0) {
            if (LoginPage && !LoginPage.rendered) {
                this.desktopDestroy();
                var pattern = /Ext.apply\(LoginPage(.|\n|\r)*}\);/gi;
                eval(response.responseText.match(pattern)[0]);
                LoginPage.showSessionExpiredMsg();
            }
        } else if (response.responseText.indexOf("<!-- ERROR PAGE -->") == 0) {
            if (document.getElementById("criticalErrorPage") == null) {
                try {
                    //limpa a tela e desativa os timers agendados
                    this.desktopDestroy();

                    document.open();
                    document.write(response.responseText);
                    document.close();
                } catch (ex) {
                    throw ex;
                }
            }
        } else if (response.responseText.indexOf("<!-- SUBSTITUTE USER PAGE -->") == 0) {
            window.location.reload();
        } else {
            this.handleUnknowError(response, exception);
        }
        ProcessManager.finishProcess(true);
    },

    removeTags : function(value, tag) {
        var tagLength = tag.length;
        return value.substring(tagLength, value.length - (tagLength + 1));
    },

    handleUnknowError : function(response, exception) {
        throw exception;
    },

    desktopDestroy : function() {
        // aborta qualquer timer que esteja em execu��o
        Ext.TaskMgr.stopAll();
        
        // limpa indicativos de processamento e timeouts que colocariam esses indicativos
        ProcessManager.finishProcess(true);
        ScreenManager.unblockScreen(true);
        
        var seniorviewPort = Ext.ComponentMgr.all.filter("xtype", "seniorviewport");
        for ( var index = 0; index < seniorviewPort.getCount(); index++) {
            seniorviewPort.get(index).destroy();
        }

        for ( var index = 0; index < Ext.ComponentMgr.all.getCount(); index++) {
            Ext.ComponentMgr.all.get(index).destroy();
        }
    },

    sendHttpXmlRequest : function(postData) {
        this.beforeRequest();

        Ext.Ajax.request({
            method : 'POST',
            scope : this,
            url : this.url,
            success : this.onSuccess,
            failure : this.onFailure,
            timeout : 300000,
            headers : {
                'Pragma' : 'no-cache',
                'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF8'
            },
            xmlData : postData
        });
        ProcessManager.startProcess();
    },

    /**
     * Envia uma requisi��o HTTP para a URL cadastrada nesta conex�o, repassando os par�metros recebidos.
     * 
     * @param postData
     *            {Mapa} mapa <chave,valor> contendo os par�metros POST a serem passados adiante.
     */
    sendHttpRequest : function(postData) {
        this.beforeRequest();

        Ext.Ajax.request({
            method : 'POST',
            scope : this,
            url : this.url,
            success : this.onSuccess,
            failure : this.onFailure,
            timeout : 300000,
            headers : {
                'Pragma' : 'no-cache',
                'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF8'
            },
            params : postData
        });
        ProcessManager.startProcess();
    },

    /**
     * @param reqObj
     *            json no seguinte formato: 
     *            { 
     *              target: '', 
     *              id: '', 
     *              type: '', 
     *              eventParams: { estrutura do componente, com todas as propriedades na raiz, e podendo utilizar arrays }
     *            }
     */
    enqueueRequest : function(reqObj) {
        this.addMessage(reqObj);

        this.addUserActionControlMessage();

        if (this.isConnectionIdle) {
            /* indica que est� processando uma a��o do usu�rio */
            ConnectionManager.setUserActionProcessing();
            this.sendRequest();
        } else {
            this.checkRequests();
        }
    },

    addUserActionControlMessage : function() {
        var requestNumber = {
            target : "PerspectiveUserActionControlComponent",
            id : "null",
            type : "userActionControl",
            eventParams : {
                requestNumber : ConnectionManager.incrementAndGetLastMessageNumber()
            }
        };
        /* adiciona a mensagem de controle */
        this.addMessage(requestNumber);
    },

    isServerIdle : function() {
        return this.serverIdle;
    },

    setServerIdle : function() {
        this.serverIdle = true;
    },

    enqueueProtocolRequest : function(reqObj) {
        this.addMessage(reqObj);

        if (this.isConnectionIdle) {
            this.sendRequest();
        } else {
            this.checkRequests();
        }
    },

    addMessage : function(messageData) {
        this.reqMsg.newMessage(messageData.target, messageData.id, messageData.type, messageData.messageListener);
        var properties = messageData.eventParams || {};
        if (!this.reqMsg.isBlockInterface()) {
            this.reqMsg.setBlockInterface(properties.blockInterface);
        }
        delete properties.blockInterface;
        for (var name in properties) {
            var value = properties[name];
            this.reqMsg.newProperty(name, value);
        }
    },

    /**
     * Verifica se alguma requisi��o precisa ser enviada, chamando o sendRequest
     */
    checkRequests : function() {
        this.sendRequest.defer(1, this);
    },

    logoff : function() {
        this.reqMsg.newRequest();
    }
};
