Ext.namespace('Ext.ux.senior.tree');

Ext.ux.senior.tree.TreeLoader = Ext.extend(Ext.tree.TreeLoader, {
	
	preloadChildren: true,
	//precisa tem alguma coisa na variavel data url!
	dataUrl : "Go!",
	
	//Sobrescreve o mtodo requestData pois na verso 2 do Ext ainda no existe o "directFn".
	requestData : function(node, callback) {
		callback();
	},
	
	/**
	 * Adiciona os nodos na tree
	 */
	addNodes: function(parentNode, nodesAttrs) {
        this.addNodeAndChildren(parentNode, nodesAttrs);
	},
	
	/**
	 * separado em dois mtodos para o controle de update
	 */
	addNodeAndChildren : function(parentNode, nodesAttrs){
		parentNode.beginUpdate();
		for(var i = 0, len = nodesAttrs.length; i < len; i++){
            var n = this.createNode(nodesAttrs[i]);
            parentNode.appendChild(n);
            // Mesmo os atributos possuindo filhos no estava criado os filhos! 
            if(nodesAttrs[i].children != null && nodesAttrs[i].children.length > 0){
            	this.addNodeAndChildren(n, nodesAttrs[i].children);
            }
            
        }
		parentNode.endUpdate();
	},
	
	createNode : function(attr) {
		//define qual o tipo de node que ser criado
		attr.nodeType = 'seniorasync';
		var newNode = Ext.ux.senior.tree.TreeLoader.superclass.createNode.call(this, attr);
		return newNode;
	}
});


Ext.reg('seniortreeloader', Ext.ux.senior.tree.TreeLoader);
