Ext.namespace('Ext.ux.senior.layout');

Ext.ux.senior.layout.LayoutPlugin = function(config) {
    Ext.apply(this, config);
};

Ext.ux.senior.layout.LayoutPlugin.containerTypes = [ "seniorrepeater", "seniorpanel", "seniortabsheet", "seniorgroupbox", "seniorwindow", "seniorviewport"];

Ext.extend(Ext.ux.senior.layout.LayoutPlugin, Ext.util.Observable, {

    alwaysForce : false,

    init : function(comp) {
        comp.on("afterrender", this.checkLayout, this);
        comp.on("add", this.checkNewCompLayout, this);

        Ext.apply(comp, {
            needToLayout : function(changeType) {                
                if (this.alwaysForce) {
                    return true;
                }
                if (changeType == Ext.ux.senior.LayoutOrganizer.CHANGE_ITEM) {
                    return true;
                } else if (comp.initialConfig.layout == "seniorflowlayout") {
                    return true;
                } else if (comp.initialConfig.layout == "seniorhboxlayout") {
                    return true;
                } else if (comp.initialConfig.layout == "seniortable") {
                    return true;
                } else if (changeType == Ext.ux.senior.LayoutOrganizer.CHANGE_SIZE && comp.initialConfig.layout == "seniorborder") { 
                    return true;
                }
                return false;
            }
        });
    },

    checkLayout : function(container) {
        for ( var i = 0; i < container.items.length; i++) {
            if (this.isContainer(container.items.get(i))) {
                container.alwaysForce = true;
                break;
            }
        }
    },
    
    checkNewCompLayout : function(container, newComponent) {
        if (!container.alwaysForce) {
            container.alwaysForce = this.isContainer(newComponent);
        }
    },

    isContainer : function(component) {
        return Ext.ux.senior.layout.LayoutPlugin.containerTypes.indexOf(component.xtype) > -1;
    }

});

Ext.preg('layoutplugin', Ext.ux.senior.layout.LayoutPlugin);
