Ext.ns('Ext.ux.senior.grid.column');
/**
 * Modelo de coluna que controla diferentes tipos de componente por linha. 
 * Armazena um mapa com todos os componentes da grid relacionados  esta coluna.
 * 
 * Responsvel por renderizar os componentes e manter o mapa atualizado.
 * 
 * @author Patrick Nascimento
 */
Ext.ux.senior.grid.column.MixedComponentColumn = Ext.extend(Ext.ux.senior.grid.column.JsonTemplateColumn, {

    /**
     * Mapa com os componentes desta coluna.
     * A chave  o identificador do registro associado  linha deste componente.
     */
    components : null,

    /**
     * Para colunas onde o columnType for {@link ColumnType#CUSTOM}, essa propriedade define se o componente sempre vai ser mostrado. <br>
     * Caso true, o componente ser mostrado apenas quando o ponteiro do mouse passar sobre a linha ou quando a clula dele receber foco.
     */
    showOnHover : false,

    /**
     * Construtor deste modelo de coluna.
     * @override
     */
    constructor : function(config) {
        if (!config.json) {
            throw "The required property 'json' was not set.";
        }
        Ext.ux.senior.grid.column.MixedComponentColumn.superclass.constructor.call(this, config);

        this.components = {};
    },

    /**
     * Adicionar novos componentes para esta coluna.
     */
    addMixedComponents : function(components) {
        for (var id in components) {
            this.components[id] = components[id];
        }
    },

    /**
     * Remove componentes desta coluna.
     */
    removeMixedComponents : function(components) {
        for (var i = 0; i < components.length; i++) {
            var id = components[i];
            delete this.components[id];
        }
    },

    /**
     * Cria o componente e aplica algumas propriedades.
     * 
     * @override
     */
    createComponent : function(value, colIndex, record, store) {
        var componentConfig = this.components[record.id];

        if (componentConfig) {
            var component = Ext.create(componentConfig);

            // faz a grid tratar os eventos deste componente no servidor.
            Ext.apply(component, {
                gridId : this.gridId,
                eventTargetId : this.gridId,
                getEventTarget : function() {
                    return this.eventTargetId;
                }
            });

            // adiciona a este componente dados do registro e coluna associados a ele.
            Ext.apply(component.defaultParams, {
                recordId : record.id,
                columnName : this.name,
                field : this.dataIndex
            });

            return component;
        }
        return null;
    },

    getComponentContainerFormat : function() {
        if (this.showOnHover){
            return "<div id='{0}' class='ux-grid-cell-component-hidden'></div>";
        }
        return "<div id='{0}' class='ux-grid-cell-component'></div>";
    }

});

Ext.reg('mixedcomponentcolumn', Ext.ux.senior.grid.column.MixedComponentColumn);
Ext.grid.Column.types['mixedcomponentcolumn'] = Ext.ux.senior.grid.column.MixedComponentColumn;
