Ext.ns('Ext.ux.senior.grid.column');

/**
 * Coluna que renderiza componentes nas clulas da grid baseando-se em um template json que
 * deve ser passado na inicializao da coluna. 
 * 
 * @class Ext.ux.senior.grid.column.JsonTemplateColumn
 * @extends Ext.ux.senior.grid.column.ComponentColumn
 */
Ext.ux.senior.grid.column.JsonTemplateColumn = Ext.extend(Ext.ux.senior.grid.column.ComponentColumn, {

    /**
     * @cfg {Object} json
     * Template json do componente que ser criado na renderizao de cada clula da grid.<br>
     * Existem cinco parmetros que podem ser utilizados no template, que sero substitudos no
     * monento da renderizao. Para utiliz-los,  necessrio seguir o seguinte padro:<br>
     * "{x}"<br>
     * onde x pode ser nome de um dos parmetros disponveis ou uma expresso que vai ser executada no
     * momento da renderizao. O escopo desta expresso (this)  a prpria instncia de JsonTemplateColumn<br>
     * <br>
     * Os parmetros disponveis so: 
     * - value: Valor da clula 
     * - row: Number referente ao nmero da linha da clula.
     * - col: Number referente ao nmero da coluna da clula.
     * <br>
     * <br>
     * Exemplo de uso:
     * 
     * var columnConfig = {
     * 		xtype: 'jsontemplatecolumn',
     *		json: '{xtype: "panel", row: "{row}", html: "{value}"}'
     * }
     */

    constructor : function(config) {
        if (!config.json) {
            throw "The required property \"json\" was not set.";
        }

        Ext.ux.senior.grid.column.JsonTemplateColumn.superclass.constructor.call(this, config);
    },

    createComponent : function(value, colIndex, record, store) {
        var readOnly = !this.grid.isColumnEditable(record, colIndex);

        //Formata o template de acordo com os parmetros.
        var objConfigString = this.formatJsonTemplate(value, colIndex, readOnly, record.data.recordKey);

        //Cria o objeto de configurao do componente que ser renderizado na grid.
        //Usa o eval direto ao invs do "Ext.util.JSON.decode" para manter o escopo (this).
        var objConfig = eval("(" + objConfigString + ')');

        //Cria o objeto e retorna.
        return Ext.create(objConfig);
    },

    formatJsonTemplate : function(value, colIndex, readOnly, recordKey) {
    	return this.json.replace(/\"\{([^}]+)\}\"/g, function(paramString, paramExpr) {
            switch (paramExpr) {
            case 'value':
                return Ext.util.JSON.encode(value);
            case 'col':
                return colIndex;
            case 'readOnly':
                return readOnly;
            case 'recordKey':
                return recordKey;
            default:
                //Retorna a prpria expresso
                return paramExpr;
            }
        });
    }
});

Ext.reg('jsontemplatecolumn', Ext.ux.senior.grid.column.JsonTemplateColumn);
Ext.grid.Column.types['jsontemplatecolumn'] = Ext.ux.senior.grid.column.JsonTemplateColumn;