Ext.ns('Ext.ux.senior.grid.column');

Ext.ux.senior.grid.column.DefaultColumn = Ext.extend(Ext.grid.Column, {

    /**
     * Sobrescreve o renderer para considerar que quando um registro  phantom deve-se aplicar 
     * o doritos nas colunas que no so especiais, mesmo que o registro no esteja dirty.
     * @override
     */
    renderer : function(value, metadata, record, rowIndex, colIndex, store) {
		this.addDirtyCell(metadata, record);
		this.addErrorCell(metadata, record);
        return value == null ? "&nbsp;" : Ext.util.Format.htmlEncode(value).replace(/ /g, "&nbsp;");
    },

    /**
     * Verifica se a clula deve receber doritos
     * 
     */
    addDirtyCell : function(metadata, record) {
        if (metadata.dataIndex !== 0 && record.phantom) {
            metadata.css += ' x-grid3-dirty-cell';
        }
    },

     /**
     * Sobrescreve o mtodo para poder retornar um Editor prprio. 
     */
    getCellEditor : function(rowIndex) {
        var ed = this.getEditor(rowIndex);
        if (ed) {
            if (!ed.startEdit) {
                if (!ed.gridEditor) {
                    ed.gridEditor = new Ext.ux.senior.grid.GridEditor(ed);
                }
                ed = ed.gridEditor;
            }
        }
        return ed;
    },

    /**
     * Retorna o texto do header da coluna para ser usado como Tooltip
     */
    getHeaderTooltip : function() {
        return this.header;
    },
    
    addErrorCell : function(metadata, record){
        if (record.error && record.errorFields.indexOf(this.dataIndex) > -1) {
            metadata.css += ' cell-error';
        }
    }
});

Ext.reg('seniorcolumn', Ext.ux.senior.grid.column.DefaultColumn);
Ext.grid.Column.types['seniorcolumn'] = Ext.ux.senior.grid.column.DefaultColumn;