Ext.ns('Ext.ux.senior.grid.column');

Ext.ux.senior.grid.column.ComponentColumn = Ext.extend(Ext.ux.senior.grid.column.DefaultColumn, {

    listeners : new Object(),

    init : function(grid) {
        /* 
         * TODO verificar! Declara o scope aqui ao invs de no construtor pois o "this" do construtor acabava sendo
         * diferente do "this" deste momento.
         */
        this.scope = this;

        /*
         * Os componentes inicialmente sero  renderizados no evento "viewready".
         * Depois que a view da grid estiver pronta, os componentes podem
         * precisar ser renderizados novamente aps um evento de "refresh". 
         */
        this.grid = grid;
        this.gridEventSource = grid;
        this.gridEvent = 'viewready';

        /*
         * TODO verificar! As clulas da grid podem ser renderizadas no evento de "rowupdated" e "rowinserted"
         * tambm! Por enquanto apenas o "refresh"  chamado, mas quando as notificaes do datasource estiverem prontas,
         * provavelmente os outros dois eventos sero chamados tambm.
         */

        grid.on('viewready', function(theGrid) {
            this.gridEventSource = theGrid.view;
            this.gridEvent = 'viewupdated';
        }, this, {
            single : true
        });

        //limpa os componentes pois, no refresh da grid eles so recriados
        this.grid.getView().on('beforerefresh', function(o, record) {
            for ( var key in this.listeners) {
                Ext.destroy(this.listeners[key]);
            }
            this.listeners = new Object();
        }, this, {
            single : true
        });
        this.grid.getView().on('beforeviewupdated', function(o, record) {
            //se vieram registros  pra remover apenas eles
            if (record) {
                if (Ext.isArray(record)) {
                    Ext.each(record, function(rec) {
                        var component = this.listeners[rec];
                        if (component) {
                            delete this.listeners[rec];
                            Ext.destroy(component);
                        }
                    }, this);
                } else {
                    var component = this.listeners[record.data.recordKey];
                    if (component) {
                        delete this.listeners[record.data.recordKey];
                        Ext.destroy(component);
                    }
                }
                //seno  pra limpar tudo
            } else {
                for ( var key in this.listeners) {
                    Ext.destroy(this.listeners[key]);
                }
                this.listeners = new Object();
            }
        }, this);

        this.grid.on('beforedestroy', function(o) {
            for ( var key in this.listeners) {
                Ext.destroy(this.listeners[key]);
            }
            this.listeners = new Object();
        }, this, {
            single : true
        });
    },

    renderer : function(value, metaData, record, rowIndex, colIndex, store) {

        //Cria o componente.
        var component = this.createComponent(value, colIndex, record, store);
        if (!component) {
            return;
        }

        if (metaData.dataIndex !== 0 && record.phantom) {
            metaData.css += ' x-grid3-dirty-cell';
        }

        //Gera um id para o parent.
        var containerId = Ext.id();

        this.listeners[record.data.recordKey] = component;
        //Coloca um listener single para renderizar o componente 
        //depois que o div estiver inserido na grid.
        this.gridEventSource.on(this.gridEvent, function() {
            this.renderComponent(component, containerId);
        }, this, {
            single : true
        });

        return String.format(this.getComponentContainerFormat(), containerId);

    },

    /**
     * Retorna o formato do container deste componente na clula da grid.
     * Extenses podem adicionar estilos css, etc.
     */
    getComponentContainerFormat : function() {
        return "<div id='{0}'></div>";
    },

    //private
    renderComponent : function(component, containerId) {
        var parent = Ext.get(containerId);
        component.render(parent);
    },

    createComponent : Ext.emptyFn
});

Ext.reg('componentcolumn', Ext.ux.senior.grid.column.ComponentColumn);
Ext.grid.Column.types['componentcolumn'] = Ext.ux.senior.grid.column.ComponentColumn;