Ext.namespace('Ext.ux.senior.grid');

Ext.ux.senior.grid.GridEditor = Ext.extend(Ext.grid.GridEditor, {

    /*
    * TODO verificar! O prprio GridEditor poderia bloquear a edio que o EditorGridPanel tenta executar naturalmente (hoje em dia o bloqueio  feito retornando false no "validateedit").
    */

    /**
     * Definido offset para que, ao abrir o editor, no apaream 2 doritos pois o editor ficar alinhado  coluna, escondendo o doritos da coluna.
     */
    offsets : [ -1, 0 ],
    /**
     * Conecta o EventManagerPlugin ao gridEditor
     *  
     * @override
     */
    initComponent : function() {
        if (this.plugins) {
            if (Ext.isArray(this.plugins)) {
                this.plugins.push("eventmanager");
            } else {
                var plugin = this.plugins;
                this.plugins = [ plugin, "eventmanager" ];
            }
        } else {
            this.plugins = [ "eventmanager" ];
        }
        this.componentOwner = this.field.componentOwner;
        /*this.field.on('change', function() {
            this.completeEdit();
        }, this);*/

        Ext.ux.senior.grid.GridEditor.superclass.initComponent.call(this);
    },

    /**
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            complete : this.prepareChangeEventData
        };
    },

    /**
     * @override
     */
    getEventTarget : function() {
        return this.field.getId();
    },

    /**
     * Evento que verifiva alteraes em editores da grid e envia os valores para o Server
     * 
     * @private
     */
    prepareChangeEventData : function(ed, value, startValue) {
        if (startValue != value) {
            var eventMapping = this.field.eventMapping();
            var changeEvent = eventMapping["change"];
            if (changeEvent) {
                var reqObj = changeEvent.apply(this.field);
                reqObj.row = this.record.id;
                return reqObj;
            }
        }
    },

    /**
     * Quando a edio comear, injeta o nmero da linha da grid como parmetro padro em todos os requests que o field mandar.
     */
    startEdit : function(el, value) {
        /*
         * Assume que qualquer editor que seja passado para o DefaultColumn  um componente senior e desta forma possui o atributo defaultParams, utilizado no plugin de eventos.
         */

        /*
         * Coloca o row nos defaultParams do editor (field) para que o GridColumnEditorController que vai tratar os eventos deste editor possa garantir que o DataSource est posicionado no registro
         * correto antes de editar seus valores.
         */
        this.field.defaultParams.row = this.record.id;

        /*Seta a grid  qual este editor pertence como o corrente focado no momento*/
        FocusManager.onComponentFocus(Ext.getCmp(this.field.componentOwner));

        Ext.ux.senior.grid.GridEditor.superclass.startEdit.call(this, el, value);
    },

    getValue : function() {
        return this.field.getRawValue();
    },

    /**
     * Este componente por si s no tem foco, quem tem  o campo que este GridEditor mantm Portanto repassamos o foco para o editor interno.
     * 
     * @override
     */
    focus : function(selectText, dlay) {
        this.field.focus(selectText, dlay);
    },
    
    /**
     * A clula da grid  representada por um td.
     * Este td possui como filho uma div que  o elemento que o editor utiliza como parmetro para definir sua largura.
     * O td possui padding-right e padding-left, que aumentam seu tamanho total.
     *  necessrio considerar o tamanho do td mais o tamanho de seus paddings para que o editor ocupe todo o espao visvel da clula da grid.
     * @param w largura do td
     * @param h
     */
    setSize : function(w, h) {
        var computedStyle;

        if (typeof document.body.currentStyle != 'undefined') {
            computedStyle = document.body.currentStyle;
        } else {
            computedStyle = document.defaultView.getComputedStyle(this.boundEl.dom.parentNode, null);
        }

        var paddingLeft = computedStyle['paddingLeft'];
        var paddingRight = computedStyle['paddingRight'];

        var index = paddingLeft.indexOf("px");
        index = paddingLeft.slice(0, index);

        var paddingSize = parseInt(index);

        index = paddingRight.indexOf("px");
        index = paddingRight.slice(0, index);

        paddingSize += parseInt(index);

        if (paddingSize > 0) {
            paddingSize -= 1;
        }

        Ext.ux.senior.grid.GridEditor.superclass.setSize.call(this, w + paddingSize, h);
    }
});