function FocusNode(component, order) {
    this.component = component;
    this.order = order;
}

FocusNode.prototype = {

    constructor : FocusNode,

    prev : null,

    next : null,

    component : null,

    order : null,

    getComponent : function() {
        return this.component;
    },

    getOrder : function() {
        return this.getComponent().getFocusOrder();
    },

    setNext : function(node) {
        this.next = node;
    },

    setPrev : function(node) {
        this.prev = node;
    },

    getNext : function() {
        return this.next;
    },

    getPrev : function() {
        return this.prev;
    },

    release : function() {
        /* apenas remove os listeners adicionados no focusmanager. */
        if (this.component.removeAllListeners) {
            this.component.removeAllListeners();
        }

        /* remove o keynav adicionado no focusmanager. */
        if (this.component.keyNav) {
            this.component.keyNav.disable();
            delete this.component.keyNav;
        }

        this.prev = null;
        this.next = null;

        delete this.component;
    }
};