Ext.namespace('Ext.ux.senior');

/**
 * @class Ext.ux.senior.File
 * @extends Ext.Panel
 * 
 * Cria um painel com botes de upload, download e remove;
 * 
 * @xtype seniorfile
 */
Ext.ux.senior.File = Ext.extend(Ext.Panel, {

    layout : {
        type : 'table',
        extraCls : 'x-form-file-column'
    },
    
    setLabel : Ext.emptyFn,

    bodyCssClass : 'x-senior-file',

    // private

    initComponent : function() {
        this.uploadField = new Ext.ux.senior.FileUploadField(this.uploadConfig);
        this.uploadField.fileComponent = this;

        this.downloadButton = new Ext.ux.senior.Button(this.downloadConfig);
        this.downloadButton.addClass('x-senior-file-button');
        this.downloadButton.addClass('x-senior-file-item-selector');

        this.removeButton = new Ext.ux.senior.Button(this.removeConfig);
        this.removeButton.addClass('x-senior-file-button');
        this.removeButton.addClass('x-senior-file-item-selector');

        this.items = [ this.uploadField, this.downloadButton, this.removeButton ];

        Ext.ux.senior.File.superclass.initComponent.call(this);
        this.on('afterlayout', this.setupFile, this);
        this.on('afterlayout', this.uploadField.adjustDimensions, this.uploadField);
        this.on('afterlayout', this.adjustSize0, this);
    },

    setupFile : function() {
        this.bindListeners();
        this.configureFocus();

        this.un('afterlayout', this.setupFile, this);
    },

    configureFocus : function() {
        this.uploadField.fileInput.nextFocus = this.downloadButton;
        this.downloadButton.nextFocus = this.removeButton;
        this.downloadButton.prevFocus = this.uploadField.fileInput;
        this.removeButton.prevFocus = this.downloadButton;

        this.uploadField.fileInput.on('focus', function() {
            this.currentFocused = this.uploadField.fileInput;
            FocusManager.focusComponent(this);
        }, this);

        this.downloadButton.btnEl.on('focus', function() {
            this.currentFocused = this.downloadButton;
            FocusManager.focusComponent(this);
        }, this);

        this.removeButton.btnEl.on('focus', function() {
            this.currentFocused = this.removeButton;
            FocusManager.focusComponent(this);
        }, this);

        this.uploadField.fileInput.on('blur', this.onMimicBlur, this);

        this.downloadButton.btnEl.on('blur', this.onMimicBlur, this);

        this.removeButton.btnEl.on('blur', this.onMimicBlur, this);
    },

    onMimicBlur : function() {

        if (document.activeElement != this.uploadField.fileInput && //
        document.activeElement != this.downloadButton.btnEl && //
        document.activeElement != this.removeButton.btnEl) {
            this.currentFocused = undefined;
        }
    },

    /*
     * chamado apra ajustar a largura do componente aps ser renderizado 
     * para no ocupar toda a largura do componente pai
     */
    // private
    adjustSize0 : function() {
        var totalWidth = 18; //tamanho configurado no layoutConfig

        totalWidth += this.uploadField.wrap.getWidth();
        totalWidth += this.downloadButton.getWidth();
        totalWidth += this.removeButton.getWidth();

        this.setWidth(totalWidth);

    },

    //private
    onRender : function(ct, position) {
        Ext.ux.senior.File.superclass.onRender.call(this, ct, position);
    },

    //private
    onAfterRender : function() {
        Ext.ux.senior.File.superclass.onAfterRender.call(this);
    },

    //private
    onLayout : function(shallow, force) {
        Ext.ux.senior.File.superclass.onLayout.call(this, shallow, force);
    },
    
    /**
     * Sobrescrito para que no seja adicionado uma mscara ao desabilitar o file
     * Tarefa 405499
     */
    onDisable : function(){
        Ext.Panel.superclass.onDisable.call(this);
    },

    eventMapping : function() {
        return {
            download : function() {
                return {
                    type : 'download'
                };
            },

            removeFile : function() {
                return {
                    type : 'removeFile'
                };
            },

            uploadComplete : function(name) {
                return {
                    type : "upload",
                    fileName : encodeURIComponent(name)
                };
            },

            uploadError : function(name, message, stack) {
                return {
                    type : "uploadError",
                    fileName : encodeURIComponent(name),
                    errorMessage : message,
                    errorStack : stack
                };
            },

            fileSize : function(fSize, name) {
                return {
                    type : "fileSize",
                    size : fSize,
                    fileName : encodeURIComponent(name)
                };
            },

            uploadFile : function(fSize, fileName) {
                return {
                    type : "uploadFile",
                    // Configurao para utilizar a fila de upload.
                    connection : ConnectionManager.UPLOAD_URL,
                    // Configurao do campo utilizado para fazer o upload.
                    fileField : document.getElementById(this.uploadField.getFileInputId())
                };
            }

        };
    },

    doUpload : function() {
        this.uploadField.doUpload();
    },

    bindListeners : function() {
        this.registerKeyDownListener(this.uploadField.fileInput, Ext.EventObject.TAB);

        var keyMapping = [ Ext.EventObject.ENTER, Ext.EventObject.SPACE, Ext.EventObject.TAB ];

        this.downloadButton.on('click', function() {
            this.fireEvent('download');
        }, this);
        this.registerKeyDownListener(this.downloadButton.el, keyMapping);

        this.removeButton.on('click', function() {
            this.fireEvent('removeFile');
        }, this);
        this.registerKeyDownListener(this.removeButton.el, keyMapping);
    },

    // private
    onDestroy : function() {
        Ext.ux.senior.File.superclass.onDestroy.call(this);
        Ext.destroy(this.uploadField, this.downloadButton, this.removeButton);
    },

    block : function() {
        this.getEl().mask().addClass('loading-background');
    },

    unblock : function() {
        this.getEl().unmask();
    },

    /**
     * Retorna o Elemento que possui o Estilo desejado.
     */
    getStyleEl : function(scope) {
        var styleScope = scope.split('$')[0];
        var el = this.getEl();
        if (styleScope == 'file') {
            el = this.getEl().child('div.x-panel-body');
        }
        return el;
    },

    /* ***************************************************************************************
     *                                  CONTROLE DE FOCO DO FILE
     * ***************************************************************************************/

    focus : function(selectText, delay, event) {
        if (!this.rendered || this.isDestroyed || !this.uploadField.rendered || this.uploadField.isDestroyed) {
            return;
        }
        
        FocusManager.onComponentFocus(this);
        if (this.currentFocused) {
            return;
        }
        if (event && event.shiftKey) {
            this.focusPrevious();
        } else {
            this.focusNext();
        }
    },

    focusNext : function() {
        var button = this.currentFocused;

        if (!button) {
            button = this.uploadField.fileInput;
        }

        do {
            if (this.canFocusButton(button)) {
                button.focus();
                this.currentFocused = button;
                return;
            } else {
                button = button.nextFocus;
            }
        } while (!!button);

        FocusManager.focusComponent(this);
        this.currentFocused = undefined;
        FocusManager.focusNextComponent();
    },

    focusPrevious : function() {
        var button = this.currentFocused;

        if (!button) {
            button = this.removeButton;
        }

        do {
            if (this.canFocusButton(button)) {
                button.focus();
                this.currentFocused = button;
                return;
            } else {
                button = button.prevFocus;
            }
        } while (!!button);

        FocusManager.focusComponent(this);
        this.currentFocused = undefined;
        FocusManager.focusPrevComponent();
    },

    focusButton : function(button) {
        button.focus();
        this.currentFocused = button;
    },

    canFocusButton : function(button) {
        return !button.hidden && button !== this.currentFocused;
    },

    getButtons : function() {
        return [ this.uploadField.button, this.downloadButton, this.removeButton ];
    },

    // private
    registerKeyDownListener : function(element, keys) {
        var map = new Ext.KeyMap(element, {
            key : keys,
            fn : this.onKeyDown,
            scope : this
        });
        map.stopEvent = true;
    },

    onKeyDown : function(keyCode, evt) {
        switch (keyCode) {
        case evt.TAB:
            if (evt.shiftKey) {
                this.focusPrevious();
            } else {
                this.focusNext();
            }
            break;
        case evt.SPACE:
        case evt.ENTER:
            this.currentFocused.fireEvent('click', this, evt);
            break;
        }
    }

});

Ext.reg('seniorfile', Ext.ux.senior.File);