SeniorDDHelper.prototype = {

    Constructor : SeniorDDHelper,
    /**
     * Aplica o valor para o caso de estar editando um componente e comear um Drag (no gera o Blur e o valor pode se perder)
     */
    applyFousedComponent : function() {
        /*Caso o componente manipulado no momento no possa receber foco ento o corrente  o ultimo focado */
        var comp = FocusManager.getFocusedComponent();
        if (this.applyOnGridEditor(comp)) {
            return;
        } else {
            comp = FocusManager.getLastFocused();
            this.applyOnGridEditor(comp);
        }
    },

    applyOnGridEditor : function(comp) {
        if (comp && comp.xtype == "senioreditorgrid" && comp.activeEditor != null) {
            //tratamento especial para Grid
            var editor = comp.activeEditor;
            editor.completeEdit();
            return true;
        }
        return false;
    },

    sendRequest : function(reqObj, cmp) {
        /* Manda o request para o servidor */
        var conn = ConnectionManager.connectionFor(cmp);
        reqObj.target = conn.context;
        conn.connection[ConnectionManager.DEFAULT_URL].enqueueRequest(reqObj);
    }

};

function SeniorDDHelper() {
    /*nothing here*/
}