Ext.namespace('Ext.ux.senior');

Ext.ux.senior.SeniorDD = Ext.extend(Ext.dd.DDProxy, {

    mantainOffset : true,
    // posio do componente antes do inicio do Drag'n'Drop
    xyComponent : new Array(),

    helper : new SeniorDDHelper(),

    // conter a imagem de Yes e No
    imgPrx : null,
    // componente copiado durante o drag'n'Drop
    proxyCmp : null,

    onDragDrop : function(e, targetId) {
        var target = Ext.getCmp(targetId);
        this.resetPosition();
        // cria o objeto que representa o request que ser enviado
        var reqObj = {
            id : targetId,
            type : 'dropperformed'
        };

        // tratamento especfico para a grid
        if (target.xtype == "senioreditorgrid") {
            var rowOver = target.view.findRowIndex(e.getTarget());
            if (rowOver !== false) {
                reqObj.eventParams = {
                    row : rowOver
                };
            } else {
                // no pode mandar o request se no tiver linha.
                this.proxyCmp.destroy();
                return;
            }
        }

        (function() {
            this.helper.sendRequest(reqObj, target);
        }).defer(1, this);
        this.proxyCmp.destroy();
    },

    startDrag : function(x, y) {
        // aplica o valor possivelmente pendente do componente focado no momento do Drag
        this.helper.applyFousedComponent();

        var el = Ext.get(this.getEl());
        var dragEl = Ext.get(this.getDragEl());
        // garante o blur do componente para o caso de haver um valor mudado

        var compWrapper = Ext.getCmp(this.getEl().id);
        compWrapper.getEl().blur();

        // cria o objeto que representa o request que ser enviado
        this.createProxyElement(el, dragEl, this.componentOwner.id);
        var reqObj = {
            id : this.getEl().id,
            type : 'dragperformed',
            properties : []
        };
        // faz essa chamada com defer para garantir que os eventos de change sejam enfileirados antes
        (function() {
            this.helper.sendRequest(reqObj, Ext.getCmp(this.getEl().id));
        }).defer(1, this);
    },

    createProxyElement : function(el, dragEl, owner) {
        var fixBorderWidth = 5;
        var fixBorderHeight = 3;
        dragEl.update("");
        this.xyComponent = el.getXY(dragEl);
        this.imgPrx = dragEl.createChild({
            width : 16,
            tag : 'img',
            src : 'resources/images/shared/drop-no.gif'
        });
        this.imgPrx.setStyle('float', 'left');
        dragEl.setStyle("backgroundColor", "#FFFFFF");
        dragEl.setStyle("zIndex", 15000);
        this.statusProxyNo(dragEl);

        // clona a configurao do componente para criar uma ccpia que ser levada no Drag
        var proxyCfg = Ext.getCmp(el.id).initialConfig;

        // adiciona propriedadees  configurao
        proxyCfg.id = "ddproxy_" + this.id;
        /*caso o componente seja um textField  necessrio aplicarmos
         * a propriedade 'position' como absolute, seno a posio da imagem da drag fica desregulada*/
        if (this.componentOwner.xtype === 'seniortextfield') {
            proxyCfg.style = {
                "position" : "absolute",
                "float" : "left"
            };
        }
        proxyCfg.plugins = [];

        // seta o valor atualizado no proxy do componente
        if (el.getValue) {
            proxyCfg.value = el.getValue();
        }

        // cria o componente proxy
        this.proxyCmp = Ext.create(proxyCfg);

        // fora a renderizao
        this.proxyCmp.render(dragEl);
        this.proxyCmp.componentOwner = owner;

        var height = this.imgPrx.getHeight() > this.proxyCmp.getHeight() ? this.imgPrx.getHeight() : this.proxyCmp.getHeight();

        dragEl.setWidth(dragEl.getWidth() + this.imgPrx.getWidth() + fixBorderWidth);
        dragEl.setHeight(height + fixBorderHeight);
        // posiciona o compoente em relao ao ponteiro do mouse
        this.setDelta(-2, parseInt(dragEl.dom.style.height, 10) + 2);
    },

    onDragOver : function(e, targetId) {
        this.statusProxyOk(this.getDragEl());
    },

    onDragOut : function(e, targetId) {
        this.statusProxyNo(this.getDragEl());
    },

    onInvalidDrop : function(evt) {
        this.proxyCmp.destroy();
        this.resetPosition();
    },

    /**
     * retorna o componente  sua posio inicial (ver este item pois o ext tem uma implementao propria para isso)
     */
    resetPosition : function() {
        if (Ext.getCmp(this.id)) {
            Ext.getCmp(this.id).el.setXY(this.xyComponent, {
                type : "slider",
                duration : 0.4
            });
        }
    },

    /**
     * prepara o Elemento que ser "dragado" (dragEl) inserindo a imagem de proibido
     */
    statusProxyNo : function(el) {
        var dragEl = Ext.get(el);
        this.imgPrx.set({
            src : 'resources/images/shared/drop-no.gif'
        });

    },

    /**
     * prepara o Elemento que ser "dragado" (dragEl) inserindo a imagem de permitido drop
     */
    statusProxyOk : function(el) {
        var dragEl = Ext.get(el);
        dragEl.setStyle("backgroundColor", "#FFFFFF");
        this.imgPrx.set({
            src : 'resources/images/shared/drop-yes.gif'
        });
    }

});

Ext.reg('seniordd', Ext.ux.senior.SeniorDD);