/*
 * Created on 16/08/2011
 * 
 * Copyright 2011 Senior Sistemas Ltda. All rights reserved.
 */

/**
 * Classe utilizada para agrupar fun��es utilit�rias e atributos globais para a
 * gera��o e aplica��o de hints.
 * 
 * @author Rodrigo Hackbarth
 */
TooltipHelper = { 

    /**
     * Cria o html dos hints e os aplica a um elemento.<br />
     * Ao chamar esta fun��o, deve-se garantir que a lista de hints n�o esteja vazia.
     * 
     * @param {JSON}
     *          hints Lista de hints a aplicar
     * @param {Element}
     *          hintsTarget Elemento onde devem ser aplicados os hints
     * @param {boolean}
     *          trackMouse, <code>true</code> para que o hint se mova com o mouse enquanto ele estiver sobre o target element  
     * @param {Function}
     *          showFunction Fun��o utilizada para apresentar os hints, � opcional.
     * @param {Object}
     *          config configura��es adicionais que o desenvolvedor deseja aplicar aos hints, opcional
     * @return
     *      Objeto Ext.Tooltip criado com os par�metros informados.
     */
    createHintsHtml : function(hints, hintsTarget, trackMouse, showFunction, config, closable) {
        var htmlTp = this.createHintsHmtlTemplate(hints);
        
        var toolTipConfig = {
                target : hintsTarget,
                html : htmlTp,
                closable : closable
        };
        
        if (showFunction) {
            toolTipConfig.show = showFunction;
        }
        
        if (trackMouse) {
            toolTipConfig.anchorToTarget = false;
            toolTipConfig.trackMouse = true;
        } else {
            toolTipConfig.anchor = 'right';
        }
        
        if (hints.length > 0) {
            toolTipConfig.showDelay = hints[0].showDelay;
            toolTipConfig.hideDelay = hints[0].hideDelay;
            toolTipConfig.dismissDelay = hints[0].dismissDelay;
        }
        
        var objTooltip = new Ext.ToolTip(toolTipConfig, config);
        
        objTooltip.afterRender = objTooltip.afterRender.createSequence(function() {
            if (Senior.isIE9OrLater()) {
                var textEl = this.getEl().child('.x-tooltip-item-text');
                var buttonClose = 0;
                if(this.modal){
                	buttonClose = this.getEl().child('.x-tool-close').getWidth();
                }
                
                var img =  this.getEl().child(".x-tooltip-item");
                var imageSize = 0;
                if(img){
                	imageSize = img.getWidth();
                }
                
                
                textEl.setWidth(this.getEl().child('.x-tip-body').getWidth() - buttonClose - imageSize);
            }
        });
        
        
        Ext.apply(objTooltip, {
            toolTarget : 'body',
            
            onHide : function() {
                
                /* � necess�rio verificar se o tooltip n�o foi destru�do antes de mandar escond�-lo. 
                 * Isto porque pode acontecer dele ser destru�do antes da execu��o do m�todo que o esconde.                
                 * Tarefa: 289436
                 */
                if (!this.isDestroyed) {
                    Ext.ToolTip.prototype.onHide.call(this);
                }
            }
        });

        return objTooltip;

    },

    createHintsHmtlTemplate :function(hints) {
        var htmlTp = "<table>";
        for ( var i = 0; i < hints.length; i++) {
            var img = "";
            if (hints[i].icon != null && hints[i].icon != "") {
                img = "<div class='x-tooltip-item-div' style='width:18px'><img class='x-tooltip-item-img' src='" + hints[i].icon + "' /></div>";
                img = "<td class='x-tooltip-item' width='18px';>" + img + "</td>";
            } else {
                img = "<td class='x-tooltip-empty-item'></td>";
            }
            htmlTp += "<tr>" + img + "<td class='x-tooltip-item-text' style='font-weight:normal'>" + hints[i].text + "</td></tr>";
        }
        htmlTp += "</table>";
        return htmlTp;
    },

    /**
     * Cria um interceptador para a fun��o passada como par�metro. A fun��o desse inteceptador � permitir que apenas
     * chamadas provenientes de tecla pressionadas sejam executadas. Chamadas que n�o sejam feitas atrav�s de um evento
     * de tecla pressionada ser�o ignoradas
     * 
     * @param fn fun��o que se deseja interceptar, caso a chamada n�o tenha partido do pressionamento de uma tecla
     */
    createKeyAndClickInterceptor : function(fn) {
        return fn.createInterceptor(function(info) {
            return info === true || info != undefined && info.type == 'click';
        });
    }
};