Ext.namespace('Ext.ux.senior.form');

var originalSetReadOnlyMethod = Ext.form.TextField.prototype.setReadOnly;
var originalSetDisabledMethod = Ext.form.TextField.prototype.setDisabled;

Ext.override(Ext.form.TextField, {
    
    readOnlyClass : 'x-senior-item-readOnly',
    
    /**
     * Sobrescrito para adicionar classe CSS quando o field for readOnly e para contornar um problema no IE 11.
     * Tarefas: 404559, 400180 e 425034.
     */
    setReadOnly : function(readOnly){
        // http://stackoverflow.com/questions/3856266/readonly-input-box-bug-in-internet-explorer
        // ao tirar do modo somente leiura um campo focado no IE 10+,  necessrio selecionar o contedo para que ele se torne editvel  
        var select = Ext.isIE10p && this.rendered && this.readOnly && !readOnly && this.el.dom == document.activeElement; 
        
        originalSetReadOnlyMethod.apply(this, arguments);
        this.updateReadOnlyStyle();
        
        if (select) {
            this.el.dom.select();
        }
    }, 
    
    setDisabled : function(disabled){
        originalSetDisabledMethod.apply(this, arguments);
        this.updateReadOnlyStyle();
    }
    
});

Ext.form.TextField.prototype.updateReadOnlyStyle = function() {
    if (this.rendered) {
        if (this.readOnly && !this.disabled) {
            this.getActionEl().addClass(this.readOnlyClass);
        } else {
            this.getActionEl().removeClass(this.readOnlyClass);
        }
    }
};

/**
 * ---------------------------------------------------------------------
 * UC-FRC-0081 Operar EditBox
 * ---------------------------------------------------------------------
 * Req0001 - OK - Informar texto - 
 * Req0002 - OK - Auto complemento de mscara - 
 * Req0005 - OK - Copiar e colar 
 * Req0006 - OK - Seleo de texto ao receber foco
 * Req0008 - OK - Texto
 * Req0011 - OK - Tipo de campo 
 * Req0015 - OK - Texto padro quanto edit estiver vazio
 * Req0016 - OK - Label
 * Req0018 - OK - Captura de eventos
 * Req0019 - Teclas de atalho - Ajustado os relativos ao edit, Outras teclas so comportamento de outros componentes
 * 
 * Pendentes ou No implementados:
 * Req0007 - O  - Ligao com dataSet - Falta B2
 * Req0003 - Quantidade mxima de caracteres - verificar quando possuir caixa de mensagem
 * Req0010 - Tamanho Mximo - verificar como deve ser tratado
 * Req0017 - Limpar contedo do edit
 *
 *
 * =======================================================================
 * -----------------------------------------------------------------------
 * Eventos
 * -----------------------------------------------------------------------
 * changed : quando o valor do edit  alterado.
 * =======================================================================
 * 
 */
Ext.ux.senior.form.TextField = Ext.extend(Ext.form.TextField, {

    selectOnFocus : true,
    enableKeyEvents : true,
    // no utilizamos validao do Ext, passando false otimiza por no gerar chamadas na classe base    
    validationEvent : false, 
    hasError : false,
    

    render : function(container, position) {
        var block = SProfilerManager.start("TextField -> render()");

        var ret = Ext.ux.senior.form.TextField.superclass.render.call(this, container, position);
        SProfilerManager.stop(block);

        /*Para ser possvel fazer drag e drop de uma imagem, o preventDefault deve possuir seu valor como true,
         * mas isso faz com que no seja possvel focar o editBox quando for clicado sobre ele.
         * Agora este listener resolver o problema descrito.*/
        var el = this.getEl();
        el.on('mousedown', el.focus, el);

        return ret;
    },

    /**
     * TODO Remover ou refazer este contorno. Ele acabou impactando na edio da grid 
     * pelo FireFox. Veja a tarefa 226304.
     * 
     * Sobrescreve o mtodo para mudar a configurao do evento onBlur que o Ext faz utilizando um delay de 10ms.
     * Aparentemente este delay resolveu alguma situao, mas esta no foi identificada.
     * O problema com o delay  que em uma tela modal ao editar na grid e fechar a modal em seguida o fechamento ocorre 
     * antes do blur.
     * 
     * @override
     */
    initEvents : function() {
        Ext.ux.senior.form.TextField.superclass.initEvents.call(this, arguments);
        this.mun(this.el, 'blur', this.onBlur, this);
        /* Adiciona novamente, porm sem os 10 milissegundos */
        this.mon(this.el, 'blur', this.onBlur, this);
    },

    onKeyEvent : function(keyCode, evt) {
        // Atualiza o valor inicial do edit, para que com isso no seja enviado um "change"
        // para o server sem ter alterado o valor do edit.
        if (this.startValue != this.getValue()) {
            this.startValue = this.getValue();
            this.fireEvent('change');
        }

        return {
            type : "keypressed"
        };
    },

    /**
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            change : this.prepareChangeEventData
        };
    },

    /**
     * @private
     */
    prepareChangeEventData : function() {
        return {
            type : 'changed',
            value : this.getValue()
        };
    },

    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    getStyleEl : function(scope, toAdd) {
        var styleScope = scope.split('$')[0];

        if (styleScope == "label") {
            return this.label;
        }
        return Ext.ux.senior.form.TextField.superclass.getStyleEl.call(this, scope);

    },

    /**
     * Sobrescrito para ajustar o doritos quando as margens so aplicadas.
     * Tarefa: 287313.
     */
    applyMargins : function() {
        Ext.ux.senior.form.TextField.superclass.applyMargins.call(this);
        
        var imgEl = Ext.get(this.imgId);
        if (imgEl) {
            imgEl.anchorTo(this.getId(), 'tl', null, false, true);
        }
    }
    
});

Ext.reg('seniortextfield', Ext.ux.senior.form.TextField);
