Ext.namespace('Ext.ux.senior.form');

/**
 * 
 * Componente TextArea, com funcionalidades extendidas em relao ao TextArea do Ext 3.2.1.
 * 
 * 
 * @class Ext.ux.senior.form.TextArea
 * @extends Ext.form.TextArea
 */
Ext.ux.senior.form.TextArea = Ext.extend(Ext.form.TextArea, {

    eventMapping : null,

    /**
     * Teclas de atalho tratadas por este componente
     * 
     * @plugin EventManagerPlugin
     */
    keyMapping : [ Ext.EventObject.SPACE ],

    initComponent : function() {
        Ext.ux.senior.form.TextArea.superclass.initComponent.call(this, arguments);
        this.on('focus', this.setCursorAtTheEnd, this);
    },

    eventMapping : function() {
        return {
            change : this.prepareChangeEventData
        };
    },

    /**
     * Posiciona o cursor para o final do texto.
     */
    setCursorAtTheEnd : function(aTextArea) {
        var end = 0;
        var value = aTextArea.getValue();
        if (value) {
            end = value.length;
        }
        aTextArea.selectTextWithoutFocus.defer(10, aTextArea, end, end);
    },
    

    /**
     * Seleciona o texto sem mandar focar o componente. 
     * A rotina foi copiada do mtodo selectText do TextField sem a parte que manda focar o componente pois isso estava causando problemas nos testes automatizados
     * 
     */
    selectTextWithoutFocus : function(start, end) {
        var v = this.getRawValue();
        if (v.length > 0) {
            start = start === undefined ? 0 : start;
            end = end === undefined ? v.length : end;
            var d = this.el.dom;
            if (d.setSelectionRange) {
                d.setSelectionRange(start, end);
            } else if (d.createTextRange) {
                var range = d.createTextRange();
                range.moveStart('character', start);
                range.moveEnd('character', end - v.length);
                range.select();
            }
        }
    },

    /**
     * Prepara os dados necessrios para o envio de evento change
     */
    prepareChangeEventData : function() {
        return {
            type : 'changed',
            value : this.getValue()
        };
    },

    /**
     * @plugin EventManagerPlugin
     */
    onKeyEvent : function(key, evt) {
        var evs = Ext.EventObject;
        if (evs.SPACE == key) {
            this.appendTab(evs.ctrlKey ? "\t" : " ");
        }
    },

    /**
     * Adiciona um \t ou um espao no texto na posio do cursor.
     */
    appendTab : function(c) {
        var selection = SelectionUtil.getSelection(this);

        var beforeTab = selection.beforeText;
        var afterTab = selection.afterText;
        // as tratativas para o IE so todas voltadas  problemas com quebra de linha, onde estas se perdem se no forem feitos estes contornos

        this.setValue(beforeTab + c + afterTab);
        this.selectText(selection.selectionStart + 1, selection.selectionStart + 1);
    },

    setLabel : function(textLabel) {
        this.label.update(textLabel);
    },

    getStyleEl : function(scope) {
        var properties = scope.split('$');
        if (properties[0] == 'label') {
            return this.label;
        }

        return Ext.ux.senior.form.TextArea.superclass.getStyleEl.call(this, scope);
    }
});

Ext.reg('seniortextarea', Ext.ux.senior.form.TextArea);
