Ext.namespace('Ext.ux.senior');
/**
 * Aba do tabGroup, os registos esto no tabPanel
 * 
 * 
 * @author rafael.matiello
 */
Ext.ux.senior.TabSheet = Ext.extend(Ext.Panel, {

    initComponent : function() {
        Ext.ux.senior.TabSheet.superclass.initComponent.call(this, arguments);
    },

    /**
     * Mapeia os eventos do componente 
     * 
     * @public
     */
    eventMapping : function() {
        return {
            afterrender : this.afterRenderEvent
        };
    },

    /**
     * Url do icone da tabSheet
     * @type String
     */
    icon : '',

    /**
     * Seta o icone na aba
     * @public
     */
    setIcon : function(iconeTab) {
        this.icon = iconeTab;
        this.updateIcon(this.ownerCt);
    },

    /**
     * Responsvel por renderizar o icon na aba
     * @public
     */
    updateIcon : function(tabGroup) {
        /* Seta css */
        this.setIconClass('x-tab-with-icon');
        if (this.icon) {
            /* Carrega htmlElement da tabSheet */
            var temp = tabGroup.getTabEl(this);
            /* Carrega o elemento que vai conter o icone */
            var span = temp.getElementsByTagName('span');
            var style = span[1].style;
            style.backgroundImage = 'url(' + this.icon + ')';
            style.backgroundPosition = 'left';
            style.paddingLeft = '20px';
            style.backgroundRepeat = 'no-repeat';
        }
    }

});

Ext.reg('seniortabsheet', Ext.ux.senior.TabSheet);