Ext.namespace('Ext.ux.senior');

/**
 * UC-FRC-0084 - Operar TabGroup <br>
 * REQ0001 - Comportamento padro deste componente - Falta ver key<br>
 * REQ0002 - OK - enableTabScroll <br>
 * REQ0011 - ok - Por TAB e ShiftTab o controle de foco cuida disto, por ctrl + right | left, da de usar um keynav, ou keymap para mandar navegar<br>
 * REQ0008 - OK - propriedade items, para renderizar mais de uma aba, e para renderizar abas <br>
 * REQ0004 - ok - getTabEl().setVisible(false), ou hideTabStripItem para todos os itens, ou apenas usar o cardlayout<br>
 * REQ0005 - ok - propriedade title junto com a configurao do item interno <br>
 * REQ0006 - ok - evento tabchange <br>
 * REQ0007 - ok - setActiveTab( String/Number item )<br>
 * REQ0003 - ok<br>
 * REQ0009 - ok - adiado<br>
 * REQ0010 - ok<br>
 * 
 * Obs: para operaes de atualizao no tabpanel usar beginUpdate e endUpdate
 */
Ext.ux.senior.TabPanel = Ext.extend(Ext.TabPanel, {

    /**
     * @cfg {String[]} incorrectChildren
     */

    /**
     * Constantes utilizadas para o ndice da classe do estilo dinmico
     */
    TABS_TOP : 0,

    TABS_BTM_RIGHT : 1,

    TABS_BTM_LEFT : 2,

    BACKGROUND_COLOR : 3,

    BORDER_COLOR : 4,

    showHeader : true,
    needsSupressFirstTabChange : true,
    enableTabScroll : true,
    activeTabStyles : [],
    inactiveTabStyles : [],

    keyMapping : [ Ext.EventObject.RIGHT, Ext.EventObject.LEFT ],
    
    keyStopEvent : false,

    initComponent : function() {
        Ext.ux.senior.TabPanel.superclass.initComponent.call(this, arguments);

    },

    eventMapping : function() {
        return {
            tabchange : this.tabChangeEvent,
            afterrender : this.afterRenderEvent
        };
    },

    /**
     * Sobrescrito para adicionar evento de foco para cada tabsheet e adicionar espao no
     * ttulo da tabsheet quando o ttulo for nulo ou vazio.
     *
     * @override
     */
    initTab : function(item, index) {
        Ext.ux.senior.TabPanel.superclass.initTab.call(this, item, index);

        if (item.title == null || item.title.trim() == '') {
            item.setTitle("&nbsp;");
        }

        if (item.icon != '' && item.icon != null) {
            item.updateIcon(item.ownerCt);
        }
        
        this.createIncorrectChildEl(item);
        
        var focusElement = Ext.fly(item.tabEl).child('a.x-tab-right');
        if (focusElement) {
            /* quando receber foco, vai adicionar uma borda pontilhada, para ter algum efeito visual de focado. */
            focusElement.addClassOnFocus('ux-senior-tabpanel-focus');
            /* adiciona borda transparente para quando adicionar o pontilhado no alterar o tamanho. */
            focusElement.addClass('ux-senior-tabpanel-transparentborder');
        }
    },

    afterRenderEvent : function(tabPanel) {
        /* verifica se precisa incluir ou remover o header */
        tabPanel.headerRender();

        /* marca para seleo */
        tabPanel.strip.on('mousedown', tabPanel.stripMouseDown, tabPanel);

        /* posiciona o boto de collapse  esquerda no header */
        if (this.collapsible) {
            var toggle = this.tools.toggle;
            toggle.addClass('x-collapse-left');
        }

        if (this.incorrectChildren) {
            this.setIncorrectChildren(this.incorrectChildren);
        }

        return null;
    },

    tabChangeEvent : function(tabPanel) {
        var objData = tabPanel.tabChange();
        tabPanel.focus();
        return objData;
    },

    onKeyEvent : function(keycode, event) {

        /**
         * Ctrl + seta para direito ou seta para esquerda para trocar de abas
         */
        if (event.ctrlKey == true && (Ext.EventObject.RIGHT == keycode || Ext.EventObject.LEFT == keycode)) {
            if (this.getActiveTab() == null) {
                if (this.items.items.length > 0) {
                    this.setActiveTab(this.items.items[i].id);
                }
            } 

            var tabEl = Ext.fly(this.getActiveTab().tabEl);
            var tab = tabEl.child('a.x-tab-right', true);
            if (tab === event.target) {
                this.keyChangedTab(keycode, event);
                this.focus();
            }
        }
    },

    /**
     * Cria requisio de click em abas, que so enviada para o servidor.
     */
    tabChange : function() {

        this.clearAllStyles();
        this.applyAllStyles();

        if (!this.needsSupressFirstTabChange && !this.fromServer) {
            return {
                type : 'tabchanged',
                index : this.items.indexOf(this.getActiveTab())
            };

        } else {
            this.needsSupressFirstTabChange = false;
        }
        this.getActiveTab().doLayout();

    },

    /**
     * Retorna o Elemento que trata o estilo desejado.
     * @param scope  String concatenada com o escopo e a propriedade do estilo desejado.
     */
    getStyleEl : function(scope, index) {
        var el = Ext.ux.senior.TabPanel.superclass.getStyleEl.call(this, scope);

        var property = scope.split("$");

        if (property[0] == "tabgroup.header" && property[1].indexOf('font') > -1) {
            var idx = Ext.isNumber(this.getActiveTab()) ? this.getActiveTab() : this.items.indexOf(this.getActiveTab());
            var tab = idx > 0 ? this.items.get(0) : this.items.last();
            el = Ext.get(tab.tabEl).child('.x-tab-strip span.x-tab-strip-text');

        }

        return el;
    },

    /**
     * Configura a aba que esta ativa, somente o server utiliza este mtodo por questo de sincronizao de processo
     * @param item item ativo
     * @public
     */
    setActiveTabServer : function(item) {
        this.fromServer = true;
        try {
            Ext.ux.senior.TabPanel.superclass.setActiveTab.call(this, item);
        } finally {
            this.fromServer = false;
        }
    },

    /**
     * Funo responsvel por navegar entre as sheets.
     */
    keyChangedTab : function(key, event) {
        var items = this.items.items;
        var activeTab = this.getActiveTab();
        var length = items.length;

        for (var i = 0; i < items.length; i++) {
            /* procura a tab ativa */
            if (activeTab.id == items[i].id) {
                /* se a tecla for RIGHT */
                var inc = key == Ext.EventObject.RIGHT ? +1 : -1;
                var tab = items[(i + inc + length) % length];
                this.setActiveTab(tab.id);
                return;
            }
        }
    },

    /**
     * modifica o estado do cabealho, caso ele no seja visualizado.
     */
    headerRender : function() {
        /* se no  para exibir o cabealho do tabGroup */
        if (!this.showHeader) {
            var el = this.getEl();

            var li;
            if (this.tabPosition == "top") {
                /* pega o cabealho */
                li = el.child('div.x-tab-panel-header');
            } else {
                /* pega o rodap */
                li = el.child('div.x-tab-panel-footer');
            }

            /* coloca o cabelho para no ser exibido */
            li.dom.style.display = 'none';
        }
    },

    /**
     * Focus na aba
     */
    focus : function() {
        try {
            /* busca a sheet ativa 'foca' ela (para mostrar algo visual) */
            var tabEl = this.getActiveTab().tabEl;
            var element = Ext.fly(tabEl);
            element.child('a.x-tab-right', true).focus();
            /* como ele est focando num elemento e no no componente, precisamos gerar o aviso de foco manualmente */
            this.fireEvent('focus', this);
        } catch (e) {
            /* no precisa tratar, gera erro no IE quando  solicitado foco de um objeto que esta invisivel e no pode */
            /* ser focado! */
        }
    },

    /* clique na aba de tabsheets. */
    stripMouseDown : function(e) {
        var target = this.findTargets(e);

        if (target.item) {
            this.focus();
        }
    },

    doLayout : function() {
        Ext.ux.senior.TabPanel.superclass.doLayout.call(this, arguments);
        /* faz um onResize para garantir que o tamanho do layout ser atualizado.
         * quando existe um gridLayout e um panel collapsible lado a lado,
         * ao colapsar o panel a grid nao ajustava sua largura. - Tarefa 239982  */
        this.onResize();
    },

    getTabAtIndex : function(index) {
        if (this.tabPosition == 'top') {
            return Ext.get(this.header.query('li')[index]);
        } else {
            return Ext.get(this.footer.query('li')[index]);
        }
    },

    /**
     * Limpa os estilos aplicados.
     * 
     * Guarda os estilos em dois arrays conforme o escopo.
     * Se for tabgroup.header guarda no array <code>inactiveTabStyles</code>
     * Se for tabgroup.header.active guarda no array <code>activeTabStyles</code>
     * 
     * Depois aplica os estilos.
     *
     * <pre>
     * Exemplo de como o array de estilos sero guardados nos arrays:
     * 
     * [{
     *      indexTab: 0, 
     *      elementsInfo: [{ 
     *          el: (elemento HTML onde o estilo vai ser adicionado)
     *          cls: 'blue-style'
     *      },{
     *          el: (elemento HTML onde o estilo vai ser adicionado)
     *          cls: 'blue-style'
     *      }]
     *  },{
     *       indexTab: 1, 
     *       elementsInfo:[{ 
     *          el: (elemento HTML onde o estilo vai ser adicionado)
     *          cls: 'red-style'
     *      }]
     * }]
     *  
     * </pre> 
     *  
     * @param styles array de objetos com informaes das classes de estilo a serem aplicadas. 
     */
    setTabStyle : function(styles) {
        //Remove os estilos aplicados atualmente
        this.clearAllStyles();
        this.activeTabStyles = [];
        this.inactiveTabStyles = [];

        var compiledStyles = eval(styles);
        for ( var i = 0; i < compiledStyles.length; i++) {
            var style = compiledStyles[i];
            var scope = compiledStyles[i].scope;
            var property = scope.split('$')[1];
            var tab = this.getTabAtIndex(style.index);
            var isTop = this.tabPosition == 'top';
            var styleElements = []; // ir armazenar objetos que contm um elemento e a classe a ser aplicada nesse elemento.

            if (property.indexOf('font') > -1) {
                styleElements = styleElements.concat( {
                    el : tab.child('span.x-tab-strip-text'),
                    cls : style.cls[this.TABS_TOP]
                });
            } else if (property.indexOf('border-color') > -1 || property.indexOf('background') > -1) {
                styleElements = this.getStyleElementsForBackground(tab, style);

                if (this.isHeaderActiveScope(scope)) {
                    if (isTop) {
                        styleElements = styleElements.concat( {
                            el : this.header.child('ul'),
                            cls : style.cls[this.BORDER_COLOR]
                        });
                    }
                }
            }

            if (this.isHeaderActiveScope(scope)) {
                // elemento que recebe background-color da tab ativa
                styleElements = styleElements.concat( {
                    el : isTop ? this.header : this.footer,
                    cls : style.cls[this.BACKGROUND_COLOR]
                });

                this.activeTabStyles = this.activeTabStyles.concat( {
                    indexTab : style.index,
                    elementsInfo : styleElements
                });
            } else {
                this.inactiveTabStyles = this.inactiveTabStyles.concat( {
                    indexTab : style.index,
                    elementsInfo : styleElements
                });
            }
        }

        this.applyAllStyles();
    },

    /**
     * Retorna se o escopo passado refere-se ao escopo de tab ativa.
     * @param scope o escopo a ser verificado
     * @returns <code>true</code> se for escopo de tab ativa, do contrrio <code>false</code>
     */
    isHeaderActiveScope : function(scope) {
        return scope.split('$')[0].indexOf('header.active') > -1;
    },

    /**
     * Retona um array com objetos contendo os elementos HTML onde cada classe de estilo deve ser adicionada.
     * @param tab a tab onde o estilo vai ser aplicado depois.
     * @param style objeto com as informaes da classe de estilo 
     * @returns um array com os elementos HTML e o nome das classes de estilo
     */
    getStyleElementsForBackground : function(tab, style) {
        var isTop = this.tabPosition == 'top';
        var styleElements = [ {
            el : tab.child('a.x-tab-right'),
            cls : style.cls[isTop ? this.TABS_TOP : this.TABS_BTM_RIGHT]
        }, {
            el : tab.child('em.x-tab-left'),
            cls : style.cls[isTop ? this.TABS_TOP : this.TABS_BTM_LEFT]
        } ];

        if (isTop) {
            styleElements = styleElements.concat( {
                el : tab.child('span.x-tab-strip-inner'),
                cls : style.cls[this.TABS_TOP]
            });
        }

        return styleElements;
    },

    /**
     * Aplica os estilos de tab ativa e inativa
     * @private
     */
    applyAllStyles : function() {
        this.applyTabStyles(this.inactiveTabStyles, function(indexTab) {
            return this.getActiveTabIndex() != indexTab;
        });
        this.applyTabStyles(this.activeTabStyles, function(indexTab) {
            return this.getActiveTabIndex() == indexTab;
        });
    },

    /**
     * Aplica as classes de estilo das tabs que possuem estiloa ser aplicado.
     * 
     * @param tabStyles array com os objetos que contem informaes como o ndice da tab, os elementos onde os estilos devem ser aplicados e o nome das classes de estilo 
     * @param addFilterFunctio funo que filtra as tabs que recebero ou no o estilo, se o retorno desta funo for <code>true</code> o estilo ser adicionado, 
     * caso contrrio no ser adicionado.
     * @private
     */
    applyTabStyles : function(tabStyles, addFilterFunction) {
        for ( var i = 0; i < tabStyles.length; i++) {
            var tabStyle = tabStyles[i];
            for ( var j = 0; j < tabStyle.elementsInfo.length; j++) {
                var info = tabStyle.elementsInfo[j];
                if (info.el && addFilterFunction.call(this, tabStyle.indexTab)) {
                    info.el.addClass(info.cls);
                }
            }

        }
    },

    /**
     * Limpa os estilos de tab ativa e inativa.
     * @private
     */
    clearAllStyles : function() {
        this.removeTabStyles(this.inactiveTabStyles);
        this.removeTabStyles(this.activeTabStyles);
    },

    /**
     * Remove as classes de estilo dos elementos
     * 
     * @param tabStyles array contendo objetos com os elementos e o nome das classes de estilo.
     * @private
     */
    removeTabStyles : function(tabStyles) {
        for ( var i = 0; i < tabStyles.length; i++) {
            var tabStyle = tabStyles[i];
            for ( var j = 0; j < tabStyle.elementsInfo.length; j++) {
                var info = tabStyle.elementsInfo[j];
                if (info.el) {
                    info.el.removeClass(info.cls);
                }
            }
        }
    },

    /**
     * Obtm o ndice da tab ativa
     * @returns
     */
    getActiveTabIndex : function() {
        return this.items.indexOfKey(this.getActiveTab().getId());
    },

    /**
     * configura o estilo dos componentes filhos que possuem algum tipo de erro.
     */
    setIncorrectChildren : function(incorrectChildren) {
        
        if(this.incorrectChildren){
            for ( var i = 0; i < this.incorrectChildren.length; i++) {
                var tabId = this.incorrectChildren[i];
                var indexTab = this.items.indexOfKey(tabId);
                if (indexTab > -1) {
                    var tab = this.getTabAtIndex(indexTab);
                    if (tab) {
                        tab.child('img').removeClass('invalid-field');
                    }
                }
            }
        }
        

        this.incorrectChildren = incorrectChildren;

        for ( var i = 0; i < this.incorrectChildren.length; i++) {
            var tabId = this.incorrectChildren[i];
            var indexTab = this.items.indexOfKey(tabId);
            if (indexTab > -1) {
                var tab = this.getTabAtIndex(indexTab);
                if (tab) {
                    var imgEl = tab.child('img');
                    this.updateIncorrectChildElPosition(imgEl, tab.child('span.x-tab-strip-text'));
                    if(tabId != this.getActiveTab().getId()){
                        imgEl.addClass('invalid-field');
                    }
                }
            }
        }

    },
    
    updateIncorrectChildElPosition : function(imgEl,textEl){
        var left = textEl.getX() + 'px';
        var top = (textEl.getY() + textEl.getHeight() - 7) + 'px';
        
        imgEl.setStyle('left', left);
        imgEl.setStyle('top', top);
        imgEl.setStyle("width", (textEl.getWidth() + 3)+'px');
    },
    
    createIncorrectChildEl : function(item){
        var tabId = item.id;
        var indexTab = this.items.indexOfKey(tabId);
        var tab = this.getTabAtIndex(indexTab);
        
        var textEl = tab.child('span.x-tab-strip-text');
        var img = document.createElement("img");
        var imgEl = new Ext.Element(img);
        this.imgId = "img_" + tabId;

        imgEl.set( {
            id : "img_" + tabId,
            src : "resources/images/shared/s.gif"
        });

        imgEl.setStyle("position", "fixed");
        imgEl.setStyle("height", "5px");
        
        this.updateIncorrectChildElPosition(imgEl, textEl);
        
        textEl.parent('span').appendChild(imgEl);
    }

});

Ext.reg('seniortabpanel', Ext.ux.senior.TabPanel);
